/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import cck.stat.TimeSequence;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;

public class SimPerfMonitor
extends MonitorFactory {
    public final Option.Double FREQUENCY = this.newOption("frequency", 100.0, "This option is used in the simulator profiling monitor to determine how many times per simulated second to sample the simulator's performance.");

    public SimPerfMonitor() {
        super("The \"simperf\" monitor profiles the performance of the simulator itself by periodically recording the cycles executed and total time consumed by simulation and generates a report.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        final Simulator simulator;
        final TimeSequence data;
        long start;
        long interval;

        Mon(Simulator s) {
            this.simulator = s;
            this.data = new TimeSequence();
            this.start = System.currentTimeMillis();
            this.interval = (long)((double)this.simulator.getClock().getHZ() / SimPerfMonitor.this.FREQUENCY.get());
            this.simulator.insertEvent(new Event(), this.interval);
        }

        public void report() {
            TermUtil.printSeparator("Simulator performance results for node " + this.simulator.getID());
            Terminal.printGreen("  Time    Millis  Instant     Cumulative");
            Terminal.nextln();
            TermUtil.printSeparator();
            TimeSequence.Measurement m = new TimeSequence.Measurement();
            TimeSequence.Iterator i = this.data.iterator(0L);
            int cntr = 0;
            long pcycles = 0L;
            long pmillis = 0L;
            while (i.hasNext()) {
                long imilli;
                long icycle;
                i.next(m);
                long cycles = m.time;
                int millis = m.value;
                if (cntr == 0) {
                    icycle = cycles;
                    imilli = millis;
                } else {
                    icycle = cycles - pcycles;
                    imilli = (long)millis - pmillis;
                }
                float cumul = (float)cycles / (float)millis / 1000.0f;
                float inst = (float)icycle / (float)imilli / 1000.0f;
                String mstr = StringUtil.leftJustify((float)millis / 1000.0f, 6);
                String ccstr = StringUtil.leftJustify(imilli, 6);
                String cstr = StringUtil.leftJustify(cumul, 12);
                String istr = StringUtil.leftJustify(inst, 12);
                Terminal.println("  " + mstr + "  " + ccstr + "  " + istr + "" + cstr);
                ++cntr;
                pmillis = millis;
                pcycles = cycles;
            }
            Terminal.nextln();
        }

        class Event
        implements Simulator.Event {
            Event() {
            }

            public void fire() {
                long time = Mon.this.simulator.getState().getCycles();
                long millis = System.currentTimeMillis() - Mon.this.start;
                Mon.this.data.add(time, (int)millis);
                Mon.this.simulator.insertEvent(this, Mon.this.interval);
            }
        }
    }
}

