/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.USART;
import avrora.sim.platform.SerialForwarder;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SerialMonitor
extends MonitorFactory {
    protected final Option.List PORTS = this.newOptionList("ports", "0:0:2390", "The \"ports\" option specifies a list of server ports that the simulator will listen on to connect to the serial forwarder for each node. The format is to first give the node number, the UART number, and then the port number ($node:$uart:$port,$node:$uart:$port).");
    protected final Option.List DEVICE = this.newOptionList("devices", "", "The \"device\" option can be used to specify the devices (represented as file names) to connect to each of the nodes' serial port. The format is to first give the node number, the UART number, and then a file name for the input file, and (optionally) a file name for the output ($node:$uart:$in[:$out],$node:$uart:$in[:$out]).");
    protected final Option.Str COMMAND = this.newOption("command", "", "The \"command\" option defines an external command to connect to the serial port of the simulated system.");
    HashMap portMap = new HashMap();

    public SerialMonitor() {
        super("The \"serial\" monitor allows the serial port (UART) of a node in the simulation to be connected to a socket so that data from the program running in the simulation can be outputted, and external data can be fed into the serial port of the simulated node.");
    }

    public void processOptions(Options o) {
        super.processOptions(o);
        this.processSocketConnections();
        this.processDeviceConnections();
    }

    private void processSocketConnections() {
        for (String pid : this.PORTS.get()) {
            String[] str = pid.split(":");
            if (str.length < 3) {
                Util.userError("Format error in \"ports\" option");
            }
            int nid = Integer.parseInt(str[0]);
            int uart = Integer.parseInt(str[1]);
            int port = Integer.parseInt(str[2]);
            SocketConnection conn = new SocketConnection();
            conn.usart = uart;
            conn.port = port;
            this.addConnection(nid, conn);
        }
    }

    private void processDeviceConnections() {
        for (String pid : this.DEVICE.get()) {
            String[] str = pid.split(":");
            if (str.length < 3) {
                Util.userError("Format error in \"device\" option");
            }
            int nid = Integer.parseInt(str[0]);
            int uart = Integer.parseInt(str[1]);
            String inf = str[2];
            String outf = str.length > 3 ? str[3] : inf;
            FileConnection conn = new FileConnection();
            conn.usart = uart;
            conn.infile = inf;
            conn.outfile = outf;
            this.addConnection(nid, conn);
        }
    }

    private void addConnection(int nid, Connection ucon) {
        Integer nidI = new Integer(nid);
        HashSet<Connection> set = (HashSet<Connection>)this.portMap.get(nidI);
        if (set == null) {
            set = new HashSet<Connection>();
            this.portMap.put(nidI, set);
        }
        set.add(ucon);
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        Monitor(Simulator s) {
            Set conns = (Set)SerialMonitor.this.portMap.get(new Integer(s.getID()));
            if (conns != null) {
                for (Connection conn : conns) {
                    AtmelMicrocontroller mcu = (AtmelMicrocontroller)s.getMicrocontroller();
                    USART usart = (USART)mcu.getDevice("usart" + conn.usart);
                    if (usart == null && conn.usart == 0) {
                        usart = (USART)mcu.getDevice("usart");
                    }
                    conn.connect(usart);
                }
            }
        }

        public void report() {
        }
    }

    class CommandConnection
    extends Connection {
        String[] command;

        CommandConnection() {
        }

        void connect(USART usart) {
            new SerialForwarder(usart, this.command);
        }
    }

    class FileConnection
    extends Connection {
        String infile;
        String outfile;

        FileConnection() {
        }

        void connect(USART usart) {
            new SerialForwarder(usart, this.infile, this.outfile);
        }
    }

    class SocketConnection
    extends Connection {
        int port;

        SocketConnection() {
        }

        void connect(USART usart) {
            new SerialForwarder(usart, this.port);
        }
    }

    abstract class Connection {
        int usart;

        Connection() {
        }

        abstract void connect(USART var1);
    }
}

