/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.SPI;
import avrora.sim.platform.SPIForwarder;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.util.HashMap;

public class SPIMonitor
extends MonitorFactory {
    protected final Option.List PORTS = this.newOptionList("ports", "0:2391", "The \"ports\" option specifies a list of server ports that the simulator will listen on to connect to the serial forwarder for each node. The format is to first give the node number, and then the port number ($node:$port,$node:$port).");
    protected final Option.Long BPS = this.newOption("bps", 2400L, "This option controls the bit rate of the controlling SPI transfer device.");
    protected final Option.Bool MASTER = this.newOption("master", true, "This option controls whether the SPI forwarder device will act as the master or the slave in the SPI connection.");
    HashMap portMap = new HashMap();

    public SPIMonitor() {
        super("The \"spi\" monitor allows the SPI of a node in the simulation to be connected to a socket so that data from the program running in the simulation can be outputted, and external data can be fed into the SPI of the simulated node.");
    }

    public void processOptions(Options o) {
        super.processOptions(o);
        this.processSocketConnections();
    }

    private void processSocketConnections() {
        for (String pid : this.PORTS.get()) {
            String[] str = pid.split(":");
            if (str.length < 2) {
                Util.userError("Format error in \"ports\" option");
            }
            int nid = Integer.parseInt(str[0]);
            int port = Integer.parseInt(str[1]);
            SocketConnection conn = new SocketConnection();
            conn.port = port;
            this.portMap.put(new Integer(nid), conn);
        }
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        Monitor(Simulator s) {
            Connection conn = (Connection)SPIMonitor.this.portMap.get(new Integer(s.getID()));
            if (conn != null) {
                AtmelMicrocontroller mcu = (AtmelMicrocontroller)s.getMicrocontroller();
                SPI spi = (SPI)mcu.getDevice("spi");
                conn.connect(spi);
            }
        }

        public void report() {
        }
    }

    class SocketConnection
    extends Connection {
        int port;

        SocketConnection() {
        }

        void connect(SPI spi) {
            new SPIForwarder(spi, this.port, (int)SPIMonitor.this.BPS.get(), SPIMonitor.this.MASTER.get());
        }
    }

    abstract class Connection {
        Connection() {
        }

        abstract void connect(SPI var1);
    }
}

