/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.clock.MainClock;
import cck.util.TimeUtil;

public class RealTimeMonitor
extends MonitorFactory {
    public RealTimeMonitor() {
        super("The \"real-time\" monitor slows down the simulation so that it runs as close as possible to real-time.");
    }

    public Monitor newMonitor(Simulator s) {
        s.insertEvent(new ThrottleEvent(s), 1L);
        return null;
    }

    private class ThrottleEvent
    implements Simulator.Event {
        boolean initialized;
        long beginMs;
        final long period;
        final MainClock clock;

        public ThrottleEvent(Simulator s) {
            this.clock = s.getClock();
            this.period = this.clock.getHZ() / 100L;
        }

        public void fire() {
            if (!this.initialized) {
                this.initialized = true;
                this.beginMs = System.currentTimeMillis();
                this.clock.insertEvent(this, this.period);
                return;
            }
            long cycles = this.clock.getCount();
            long msGoal = (long)TimeUtil.cyclesToMillis(cycles, this.clock.getHZ());
            while (System.currentTimeMillis() - this.beginMs < msGoal) {
            }
            this.clock.insertEvent(this, this.period);
        }
    }
}

