/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.AbstractInstr;
import avrora.core.Program;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.stat.StatUtil;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public class ProfileMonitor
extends MonitorFactory {
    public final Option.Bool CYCLES = this.newOption("record-cycles", true, "This option controls whether this monitor will record the cycles consumed by each instruction or basic block. ");
    public final Option.Long PERIOD = this.newOption("period", 0L, "This option specifies whether the profiling will be exact or periodic. When this option is set to non-zero, then a sample of the program counter is taken at the specified period in clock cycles, rather than through probes at each instruction.");
    public final Option.Bool CLASSES = this.newOption("instr-classes", false, "This option selects whether the profiling monitor will generate a report of the types of instructions that were executed most frequently by the program.");

    public ProfileMonitor() {
        super("The \"profile\" monitor profiles the execution history of every instruction in the program and generates a textual report of the execution frequency for all instructions.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        public final Simulator simulator;
        public final Program program;
        public final long[] icount;
        public final long[] itime;
        long totalcount;
        long totalcycles;

        Mon(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.icount = new long[this.program.program_end];
            this.itime = new long[this.program.program_end];
            long period = ProfileMonitor.this.PERIOD.get();
            if (period > 0L) {
                s.insertEvent(new PeriodicProfile(period), period);
            } else if (ProfileMonitor.this.CYCLES.get()) {
                s.insertProbe(new CCProbe());
            } else {
                s.insertProbe(new CProbe());
            }
        }

        public void report() {
            this.computeTotals();
            this.reportProfile();
            if (ProfileMonitor.this.CLASSES.get()) {
                this.reportInstrProfile();
            }
            Terminal.nextln();
        }

        private void reportProfile() {
            int imax = this.icount.length;
            TermUtil.printSeparator("Profiling results for node " + this.simulator.getID());
            Terminal.printGreen("       Address     Count  Run     Cycles     Cumulative");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            int cntr = 0;
            while (cntr < imax) {
                String addr;
                int nextpc;
                int start = cntr;
                int runlength = 1;
                long curcount = this.icount[cntr];
                long cumulcycles = this.itime[cntr];
                while (cntr < imax - 2 && (nextpc = this.program.getNextPC(cntr)) < this.icount.length && this.icount[nextpc] == curcount) {
                    ++runlength;
                    cumulcycles += this.itime[nextpc];
                    cntr = nextpc;
                }
                String cnt = StringUtil.rightJustify(curcount, 8);
                float pcnt = this.computePercent((long)runlength * curcount, cumulcycles);
                String percent = "";
                if (runlength > 1) {
                    addr = StringUtil.addrToString(start) + '-' + StringUtil.addrToString(cntr);
                    percent = " x" + runlength;
                } else {
                    addr = "       " + StringUtil.addrToString(start);
                }
                percent = StringUtil.leftJustify(percent, 7);
                if (curcount != 0L) {
                    percent = percent + StringUtil.rightJustify(cumulcycles, 8);
                    percent = percent + " = " + StringUtil.rightJustify(StringUtil.toFixedFloat(pcnt, 4), 8) + " %";
                }
                TermUtil.reportQuantity(' ' + addr, cnt, percent);
                cntr = this.program.getNextPC(cntr);
            }
        }

        private void computeTotals() {
            this.totalcycles = StatUtil.sum(this.itime);
            this.totalcount = StatUtil.sum(this.icount);
        }

        private float computePercent(long count, long cycles) {
            if (ProfileMonitor.this.CYCLES.get()) {
                return 100.0f * (float)cycles / (float)this.totalcycles;
            }
            return 100.0f * (float)count / (float)this.totalcount;
        }

        private void reportInstrProfile() {
            List l = this.computeInstrProfile();
            TermUtil.printSeparator(78, "Profiling Results by Instruction Type");
            Terminal.printGreen(" Instruction      Count    Cycles   Percent");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            for (InstrProfileEntry ipe : l) {
                float pcnt = this.computePercent(ipe.count, ipe.cycles);
                String p = StringUtil.toFixedFloat(pcnt, 4) + " %";
                Terminal.printGreen("   " + StringUtil.rightJustify(ipe.name, 9));
                Terminal.print(": ");
                Terminal.printBrightCyan(StringUtil.rightJustify(ipe.count, 9));
                Terminal.print("  " + StringUtil.rightJustify(ipe.cycles, 8));
                Terminal.print("  " + StringUtil.rightJustify(p, 10));
                Terminal.nextln();
            }
        }

        private List computeInstrProfile() {
            HashMap<String, InstrProfileEntry> cmap = new HashMap<String, InstrProfileEntry>();
            for (int cntr = 0; cntr < this.icount.length; ++cntr) {
                AbstractInstr i;
                if (this.icount[cntr] == 0L || (i = this.program.readInstr(cntr)) == null) continue;
                String variant = i.getName();
                InstrProfileEntry entry = (InstrProfileEntry)cmap.get(variant);
                if (entry == null) {
                    entry = new InstrProfileEntry();
                    entry.name = variant;
                    cmap.put(variant, entry);
                }
                entry.count += this.icount[cntr];
                entry.cycles += this.itime[cntr];
            }
            Enumeration e = Collections.enumeration(cmap.values());
            ArrayList l = Collections.list(e);
            Collections.sort(l);
            return l;
        }

        class InstrProfileEntry
        implements Comparable {
            String name;
            long count;
            long cycles;

            InstrProfileEntry() {
            }

            public int compareTo(Object o) {
                InstrProfileEntry other = (InstrProfileEntry)o;
                if (this.cycles > 0L) {
                    if (other.cycles > this.cycles) {
                        return 1;
                    }
                    if (other.cycles < this.cycles) {
                        return -1;
                    }
                } else {
                    if (other.count > this.count) {
                        return 1;
                    }
                    if (other.count < this.count) {
                        return -1;
                    }
                }
                return 0;
            }
        }

        public class CProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State state, int pc) {
                int n = pc;
                Mon.this.icount[n] = Mon.this.icount[n] + 1L;
            }
        }

        public class CCProbe
        implements Simulator.Probe {
            protected long timeBegan;

            public void fireBefore(State state, int pc) {
                int n = pc;
                Mon.this.icount[n] = Mon.this.icount[n] + 1L;
                this.timeBegan = state.getCycles();
            }

            public void fireAfter(State state, int pc) {
                int n = pc;
                Mon.this.itime[n] = Mon.this.itime[n] + (state.getCycles() - this.timeBegan);
            }
        }

        public class PeriodicProfile
        implements Simulator.Event {
            private final long period;

            PeriodicProfile(long p) {
                this.period = p;
            }

            public void fire() {
                int n = Mon.this.simulator.getState().getPC();
                Mon.this.icount[n] = Mon.this.icount[n] + 1L;
                Mon.this.simulator.insertEvent(this, this.period);
            }
        }
    }
}

