/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.util.MemPrint;
import cck.text.StringUtil;
import cck.util.Option;
import java.text.StringCharacterIterator;
import java.util.Iterator;

public class PrintMonitor
extends MonitorFactory {
    protected final Option.Str VARIABLENAME = this.newOption("VariableName", "debugbuf1", "This option specifies the name of the variable to print");
    protected final Option.Str LEN = this.newOption("Len", "30", "This option specifies the length of the variable to print");
    protected final Option.Str LOG = this.newOption("logfile", "", "This option specifies whether the print monitor should log changes to each node's energy state. If this option is specified, then each node's print statements will be written to <option>.#, where '#' represents the node ID.");

    public PrintMonitor() {
        super("The \"print\" monitor watches a dedicated range of SRAM for instructions to print a string or int to the screen.  Set the VariableName and avroraZ will look directly inside the map file the part of the SRAM to print.Check http://citavroraz.wiki.sourceforge.net/AvroraZ+monitors to know how topass the variable format to avroraZ and thus get a proper printing ");
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        public final MemPrint memprofile;
        private final String varname;
        private final String l;
        private int BASE;
        protected Simulator simulator;
        private String fileName;

        Monitor(Simulator s) {
            this.varname = PrintMonitor.this.VARIABLENAME.get();
            this.l = PrintMonitor.this.LEN.get();
            this.simulator = s;
            Program p = s.getProgram();
            Iterator it = p.getSourceMapping().getIterator();
            while (it.hasNext()) {
                SourceMapping.Location tempLoc = (SourceMapping.Location)it.next();
                if (!this.varname.equals(tempLoc.name)) continue;
                String st = StringUtil.toHex(tempLoc.vma_addr, 3);
                st = st.substring(3, 6);
                this.BASE = StringUtil.readHexValue(new StringCharacterIterator(st), 3);
            }
            int MAX = Integer.parseInt(this.l);
            this.fileName = !PrintMonitor.this.LOG.isBlank() ? PrintMonitor.this.LOG.get() + this.simulator.getID() : "";
            this.memprofile = new MemPrint(this.BASE, MAX, this.fileName);
            s.insertWatch(this.memprofile, this.BASE);
        }

        public void report() {
        }
    }
}

