/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.output.SimPrinter;
import avrora.sim.platform.Platform;
import avrora.sim.radio.CC1000Radio;
import avrora.sim.radio.CC2420Radio;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Radio;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PacketMonitor
extends MonitorFactory {
    protected Option.Bool BITS = this.newOption("show-bits", false, "This option enables the printing of packets as they are transmitted.");
    protected Option.Bool PACKETS = this.newOption("show-packets", true, "This option enables the printing of packet contents in bits rather than in bytes.");
    protected Option.Str START_SYMBOL = this.newOption("start-symbol", "", "When this option is not blank, the packet monitor will attempt to match the start symbol of packet data in order to display both the preamble, start symbol, and packet contents.");
    protected List monitors = new LinkedList();

    public PacketMonitor() {
        super("The \"packet\" monitor tracks packets sent and received by nodes in a sensor network.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    class Mon
    implements Monitor,
    Medium.Probe {
        LinkedList bytes;
        final Simulator simulator;
        final SimPrinter printer;
        final boolean showPackets;
        final boolean bits;
        int bytesTransmitted;
        int packetsTransmitted;
        int bytesReceived;
        int packetsReceived;
        int bytesCorrupted;
        int packetsLostinMiddle;
        boolean matchStart;
        byte startSymbol;
        long startCycle;

        Mon(Simulator s) {
            this.simulator = s;
            Platform platform = this.simulator.getMicrocontroller().getPlatform();
            Radio radio = (Radio)platform.getDevice("radio");
            radio.getTransmitter().insertProbe(this);
            radio.getReceiver().insertProbe(this);
            this.printer = SimUtil.getPrinter(this.simulator, "monitor.packet");
            this.printer.enabled = true;
            this.showPackets = PacketMonitor.this.PACKETS.get();
            this.bytes = new LinkedList();
            this.bits = PacketMonitor.this.BITS.get();
            this.getStartSymbol(radio);
            PacketMonitor.this.monitors.add(this);
        }

        private void getStartSymbol(Radio radio) {
            if (!PacketMonitor.this.START_SYMBOL.isBlank()) {
                this.matchStart = true;
                this.startSymbol = (byte)StringUtil.readHexValue(new StringCharacterIterator(PacketMonitor.this.START_SYMBOL.get()), 2);
            } else {
                if (radio instanceof CC1000Radio) {
                    this.matchStart = true;
                    this.startSymbol = (byte)51;
                }
                if (radio instanceof CC2420Radio) {
                    this.matchStart = true;
                    this.startSymbol = (byte)-89;
                }
            }
        }

        public void fireBeforeTransmit(Medium.Transmitter t, byte val) {
            if (this.bytes.size() == 0) {
                this.startCycle = this.simulator.getClock().getCount();
            }
            this.bytes.addLast(new Character((char)(0xFF & val)));
            ++this.bytesTransmitted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void fireBeforeTransmitEnd(Medium.Transmitter t) {
            ++this.packetsTransmitted;
            if (this.showPackets) {
                StringBuffer buf = this.renderPacket("----> ");
                Class<Terminal> clazz = Terminal.class;
                // MONITORENTER : cck.text.Terminal.class
                Terminal.println(buf.toString());
                // MONITOREXIT : clazz
            }
            this.bytes = new LinkedList();
        }

        public void fireAfterReceive(Medium.Receiver r, char val) {
            if (this.bytes.size() == 0) {
                this.startCycle = this.simulator.getClock().getCount();
            }
            if (Medium.isCorruptedByte(val)) {
                ++this.bytesCorrupted;
            }
            ++this.bytesReceived;
            this.bytes.addLast(new Character(val));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireAfterReceiveEnd(Medium.Receiver r) {
            Iterator b = this.bytes.iterator();
            int cnt = 0;
            boolean LostBytesinPacket = false;
            while (b.hasNext()) {
                char c = ((Character)b.next()).charValue();
                switch (++cnt) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (c == '\u0000') break;
                        LostBytesinPacket = true;
                        break;
                    }
                    case 4: {
                        if (c == '\u000f') break;
                        LostBytesinPacket = true;
                        break;
                    }
                    case 5: {
                        if (c == '\u00a7') break;
                        LostBytesinPacket = true;
                        break;
                    }
                    case 6: {
                        if (c == (char)(this.bytes.size() - 6)) break;
                        LostBytesinPacket = true;
                        break;
                    }
                }
            }
            if (!LostBytesinPacket) {
                ++this.packetsReceived;
                if (this.showPackets) {
                    StringBuffer buf = this.renderPacket("<==== ");
                    Class<Terminal> clazz = Terminal.class;
                    synchronized (Terminal.class) {
                        Terminal.println(buf.toString());
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                    }
                }
            } else {
                ++this.packetsLostinMiddle;
            }
            {
                this.bytes = new LinkedList();
                return;
            }
        }

        private StringBuffer renderPacket(String prefix) {
            StringBuffer buf = new StringBuffer(3 * this.bytes.size() + 45);
            SimUtil.getIDTimeString(buf, this.simulator);
            Terminal.append(14, buf, prefix);
            Iterator i = this.bytes.iterator();
            int cntr = 0;
            boolean inPreamble = true;
            while (i.hasNext()) {
                char t = ((Character)i.next()).charValue();
                inPreamble = this.renderByte(++cntr, t, inPreamble, buf);
                if (!i.hasNext()) continue;
                buf.append('.');
            }
            this.appendTime(buf);
            return buf;
        }

        private void appendTime(StringBuffer buf) {
            long cycles = this.simulator.getClock().getCount() - this.startCycle;
            double ms = this.simulator.getClock().cyclesToMillis(cycles);
            buf.append("  ");
            buf.append(StringUtil.toFixedFloat((float)ms, 3));
            buf.append(" ms");
        }

        private boolean renderByte(int cntr, char value, boolean inPreamble, StringBuffer buf) {
            int color = 16;
            byte bval = (byte)value;
            if (!this.bits && Medium.isCorruptedByte(value)) {
                color = 1;
            } else if (this.matchStart && cntr > 4) {
                if (inPreamble && cntr == 5) {
                    if (bval == this.startSymbol) {
                        color = 11;
                        inPreamble = false;
                    }
                } else if (!inPreamble && cntr > 5) {
                    color = 2;
                }
            }
            this.renderByte(buf, color, value);
            return inPreamble;
        }

        private void renderByte(StringBuffer buf, int color, char value) {
            if (this.bits) {
                byte corrupted = Medium.getCorruptedBits(value);
                for (int i = 7; i >= 0; --i) {
                    boolean bit;
                    boolean bl = bit = (value >> i & 1) != 0;
                    if ((corrupted >> i & 1) != 0) {
                        Terminal.append(1, buf, bit ? "1" : "0");
                        continue;
                    }
                    Terminal.append(color, buf, bit ? "1" : "0");
                }
            } else {
                Terminal.append(color, buf, StringUtil.toHex((byte)value, 2));
            }
        }

        public void report() {
            if (PacketMonitor.this.monitors != null) {
                TermUtil.printSeparator(78, "Packet monitor results");
                Terminal.printGreen("Node     sent (b/p)          recv (b/p)    corrupted (b)   lostinMiddle(p)");
                Terminal.nextln();
                TermUtil.printThinSeparator();
                for (Mon mon : PacketMonitor.this.monitors) {
                    Terminal.print(StringUtil.rightJustify(mon.simulator.getID(), 4));
                    Terminal.print(StringUtil.rightJustify(mon.bytesTransmitted, 10));
                    Terminal.print(" / ");
                    Terminal.print(StringUtil.leftJustify(mon.packetsTransmitted, 8));
                    Terminal.print(StringUtil.rightJustify(mon.bytesReceived, 10));
                    Terminal.print(" / ");
                    Terminal.print(StringUtil.leftJustify(mon.packetsReceived, 8));
                    Terminal.print(StringUtil.rightJustify(mon.bytesCorrupted, 10));
                    Terminal.print(StringUtil.rightJustify(mon.packetsLostinMiddle, 8));
                    Terminal.nextln();
                }
                PacketMonitor.this.monitors = null;
                Terminal.nextln();
            }
        }
    }
}

