/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.actions.SimAction;
import avrora.arch.avr.AVRProperties;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.util.MemoryProfiler;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.util.List;

public class MemoryMonitor
extends MonitorFactory {
    public final Option.List LOCATIONS = this.newOptionList("locations", "", "This option, when set, specifies a list of memory locations to instrument. When this option is not specified, the monitor will instrument all reads and writes to memory.");
    public final Option.Bool LOWER_ADDRESS = this.newOption("low-addresses", false, "When this option is enabled, the memory monitor will be inserted for lower addresses, recording reads and writes to the general purpose registers on the AVR and also IO registers through direct and indirect memory reads and writes.");

    public MemoryMonitor() {
        super("The \"memory\" monitor collects information about the memory usage statistics of the program, including the number of reads and writes to every byte of data memory.");
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        public final Simulator simulator;
        public final Microcontroller microcontroller;
        public final Program program;
        public final int ramsize;
        public final int memstart;
        public final MemoryProfiler memprofile;

        Monitor(Simulator s) {
            this.simulator = s;
            this.microcontroller = this.simulator.getMicrocontroller();
            this.program = this.simulator.getProgram();
            AVRProperties p = (AVRProperties)this.microcontroller.getProperties();
            this.ramsize = p.sram_size + p.ioreg_size + 32;
            this.memstart = MemoryMonitor.this.LOWER_ADDRESS.get() ? 0 : 32 + p.ioreg_size;
            this.memprofile = new MemoryProfiler(this.ramsize);
            this.insertWatches();
        }

        private void insertWatches() {
            if (!MemoryMonitor.this.LOCATIONS.get().isEmpty()) {
                List l = MemoryMonitor.this.LOCATIONS.get();
                List loc = SimAction.getLocationList(this.program, l);
                for (SourceMapping.Location location : loc) {
                    this.simulator.insertWatch(this.memprofile, location.vma_addr - 0x800000);
                }
            } else {
                for (int cntr = this.memstart; cntr < this.ramsize; ++cntr) {
                    this.simulator.insertWatch(this.memprofile, cntr);
                }
            }
        }

        public void report() {
            TermUtil.printSeparator("Memory profiling results for node " + this.simulator.getID());
            Terminal.printGreen("   Address     Reads               Writes");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            double rtotal = 0.0;
            long[] rcount = this.memprofile.rcount;
            double wtotal = 0.0;
            long[] wcount = this.memprofile.wcount;
            int imax = rcount.length;
            for (int cntr = 0; cntr < imax; ++cntr) {
                rtotal += (double)rcount[cntr];
                wtotal += (double)wcount[cntr];
            }
            int zeroes = 0;
            for (int cntr = this.memstart; cntr < imax; ++cntr) {
                long r = rcount[cntr];
                long w = wcount[cntr];
                zeroes = r == 0L && w == 0L ? ++zeroes : 0;
                if (zeroes == 2) {
                    Terminal.println("                   .                    .");
                    continue;
                }
                if (zeroes > 2) continue;
                String addr = StringUtil.addrToString(cntr);
                this.printLine(addr, r, rtotal, w, wtotal);
            }
            this.printLine("total ", (long)rtotal, rtotal, (long)wtotal, wtotal);
            Terminal.nextln();
        }

        private void printLine(String addr, long r, double rtotal, long w, double wtotal) {
            String rcnt = StringUtil.rightJustify(r, 8);
            float rpcnt = (float)((double)(100L * r) / rtotal);
            String rpercent = StringUtil.rightJustify(StringUtil.toFixedFloat(rpcnt, 4), 8) + " %";
            String wcnt = StringUtil.rightJustify(w, 8);
            float wpcnt = (float)((double)(100L * w) / wtotal);
            String wpercent = StringUtil.rightJustify(StringUtil.toFixedFloat(wpcnt, 4), 8) + " %";
            Terminal.printGreen("    " + addr);
            Terminal.print(": ");
            Terminal.printBrightCyan(rcnt);
            Terminal.print(' ' + "  " + rpercent);
            Terminal.printBrightCyan(wcnt);
            Terminal.println(' ' + "  " + wpercent);
        }
    }
}

