/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.output.SimPrinter;
import avrora.sim.platform.Platform;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Radio;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import java.util.LinkedList;
import java.util.List;

public class LQIMonitor
extends MonitorFactory {
    protected List monitors = new LinkedList();

    public LQIMonitor() {
        super("The \"LQI\" monitor tracks Received Signal Strength Indicator (RSSI) and correlation values for every packet received in each mote of the WSN.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    class Mon
    implements Monitor,
    Medium.Probe {
        LinkedList bytes;
        final Simulator simulator;
        final SimPrinter printer;
        int Samples;
        long cycles;
        double sec;
        int RSSIsum;
        int Corrsum;
        int RSSIav;

        Mon(Simulator s) {
            this.simulator = s;
            Platform platform = this.simulator.getMicrocontroller().getPlatform();
            Radio radio = (Radio)platform.getDevice("radio");
            radio.getReceiver().insertProbe(this);
            this.printer = SimUtil.getPrinter(this.simulator, "monitor.LQI");
            this.printer.enabled = true;
            LQIMonitor.this.monitors.add(this);
        }

        public void fireCorrValue(Medium.Receiver r, byte val) {
            Terminal.print(StringUtil.rightJustify(this.simulator.getID(), 4));
            this.cycles = this.simulator.getClock().getCount();
            this.sec = this.simulator.getClock().cyclesToMillis(this.cycles) / 1000.0;
            Terminal.print(StringUtil.rightJustify((int)this.sec, 11));
            Terminal.print(StringUtil.rightJustify("Corr,", 11));
            Terminal.print(StringUtil.rightJustify(val, 0));
            Terminal.nextln();
            ++this.Samples;
        }

        public void fireRSSI(Medium.Receiver r, byte val) {
            Terminal.print(StringUtil.rightJustify(this.simulator.getID(), 4));
            this.cycles = this.simulator.getClock().getCount();
            this.sec = this.simulator.getClock().cyclesToMillis(this.cycles) / 1000.0;
            Terminal.print(StringUtil.rightJustify((int)this.sec, 11));
            Terminal.print(StringUtil.rightJustify("RSSI,", 11));
            Terminal.print(StringUtil.rightJustify(val, 0));
            Terminal.nextln();
            ++this.Samples;
        }

        public void fireBeforeTransmit(Medium.Transmitter t, byte val) {
        }

        public void fireBeforeTransmitEnd(Medium.Transmitter t) {
        }

        public void fireAfterReceive(Medium.Receiver r, char val) {
        }

        public void fireAfterReceiveEnd(Medium.Receiver r) {
        }

        public void report() {
            if (LQIMonitor.this.monitors != null) {
                TermUtil.printSeparator(78, "LQI monitor results");
                Terminal.printGreen("Node  Nsamples");
                Terminal.nextln();
                TermUtil.printThinSeparator();
                for (Mon mon : LQIMonitor.this.monitors) {
                    Terminal.print(StringUtil.rightJustify(mon.simulator.getID(), 4));
                    Terminal.print(StringUtil.rightJustify(mon.Samples, 10));
                    Terminal.nextln();
                }
                LQIMonitor.this.monitors = null;
                Terminal.nextln();
            }
        }
    }
}

