/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.platform.LED;
import avrora.sim.platform.Platform;
import avrora.sim.util.SimUtil;
import cck.text.Terminal;

public class LEDMonitor
extends MonitorFactory {
    public LEDMonitor() {
        super("This monitor records and traces each change to the state of the LEDs of a device.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    protected class Mon
    implements Monitor,
    FiniteStateMachine.Probe {
        LED.LEDGroup ledgroup;

        public Mon(Simulator s) {
            Platform platform = s.getMicrocontroller().getPlatform();
            Object dev = platform.getDevice("leds");
            if (dev instanceof LED.LEDGroup) {
                this.ledgroup = (LED.LEDGroup)dev;
                LED[] leds = this.ledgroup.leds;
                for (int cntr = 0; cntr < leds.length; ++cntr) {
                    leds[cntr].state.insertProbe(this);
                }
            }
        }

        public void fireBeforeTransition(int beforeState, int afterState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireAfterTransition(int beforeState, int afterState) {
            if (beforeState == afterState) {
                return;
            }
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                Terminal.print(SimUtil.getIDTimeString(this.ledgroup.sim));
                LED[] leds = this.ledgroup.leds;
                for (int cntr = 0; cntr < leds.length; ++cntr) {
                    if (leds[cntr].getState() == 0) {
                        Terminal.print("off ");
                        continue;
                    }
                    Terminal.print(leds[cntr].colornum, "on  ");
                }
                Terminal.nextln();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void report() {
        }
    }
}

