/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.InterruptTable;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.util.SimUtil;
import cck.stat.MinMaxMean;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.util.Arrays;

public class InterruptMonitor
extends MonitorFactory {
    protected final Option.Bool SHOW = this.newOption("show-interrupts", false, "This option, when specified, will cause the interrupt monitor to bring out changes to the state of each interrupt.");
    protected final Option.Bool INV_ONLY = this.newOption("invocations-only", true, "This option, when specified, will cause the interrupt to print only invocations of the specified interrupts, and not enablings, disablings, postings, and unpostings.");

    public InterruptMonitor() {
        super("The interrupt monitor tracks changes to the state of interrupts, including posting, enabling, and invoking of interrupts.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    class Mon
    implements Monitor,
    Simulator.InterruptProbe {
        final MCUProperties props;
        final Simulator simulator;
        final InterruptTable interrupts;
        final long[] invocations;
        final long[] lastInvoke;
        final long[] lastPost;
        final MinMaxMean[] meanInvoke;
        final MinMaxMean[] meanLatency;
        final MinMaxMean[] meanWake;
        boolean show;
        boolean invokeOnly;

        Mon(Simulator s) {
            this.simulator = s;
            this.props = this.simulator.getMicrocontroller().getProperties();
            InterruptTable interruptTable = this.simulator.getInterpreter().getInterruptTable();
            interruptTable.insertProbe(this);
            this.interrupts = interruptTable;
            int numInts = this.interrupts.getNumberOfInterrupts();
            this.invocations = new long[numInts];
            this.lastInvoke = new long[numInts];
            this.lastPost = new long[numInts];
            this.meanInvoke = new MinMaxMean[numInts];
            this.meanLatency = new MinMaxMean[numInts];
            this.meanWake = new MinMaxMean[numInts];
            Arrays.fill(this.lastInvoke, -1L);
            Arrays.fill(this.lastPost, -1L);
            for (int cntr = 0; cntr < numInts; ++cntr) {
                this.meanInvoke[cntr] = new MinMaxMean("Inter-arrival time");
                this.meanLatency[cntr] = new MinMaxMean("Latency");
                this.meanWake[cntr] = new MinMaxMean("Wakeup time");
            }
            this.show = InterruptMonitor.this.SHOW.get();
            this.invokeOnly = InterruptMonitor.this.INV_ONLY.get();
        }

        private void print(String s, int inum) {
            StringBuffer buf = new StringBuffer();
            SimUtil.getIDTimeString(buf, this.simulator);
            Terminal.append(2, buf, s);
            if (inum > 0) {
                buf.append(": ");
                Terminal.append(14, buf, "#" + inum + " (" + this.props.getInterruptName(inum) + ")");
            }
            Terminal.println(buf.toString());
        }

        public void fireBeforeInvoke(State s, int inum) {
            if (this.show) {
                this.print("invoke interrupt", inum);
            }
            int n = inum;
            this.invocations[n] = this.invocations[n] + 1L;
            long time = s.getCycles();
            if (this.lastInvoke[inum] > 0L) {
                this.meanInvoke[inum].record((int)(time - this.lastInvoke[inum]));
            }
            if (this.lastPost[inum] > 0L && this.lastPost[inum] > this.lastInvoke[inum]) {
                this.meanLatency[inum].record((int)(time - this.lastPost[inum]));
            }
            this.lastInvoke[inum] = time;
        }

        public void fireAfterInvoke(State s, int inum) {
            long time = s.getCycles();
            if (this.lastInvoke[inum] > 0L) {
                this.meanWake[inum].record((int)(time - this.lastInvoke[inum]));
            }
        }

        public void fireWhenDisabled(State s, int inum) {
            if (this.show && !this.invokeOnly) {
                if (inum != 0) {
                    this.print("disable interrupt", inum);
                } else {
                    this.print("disable interrupts", inum);
                }
            }
        }

        public void fireWhenEnabled(State s, int inum) {
            if (this.show && !this.invokeOnly) {
                if (inum != 0) {
                    this.print("enable interrupt", inum);
                } else {
                    this.print("enable interrupts", inum);
                }
            }
        }

        public void fireWhenPosted(State s, int inum) {
            if (this.show && !this.invokeOnly) {
                this.print("post interrupt", inum);
            }
            this.lastPost[inum] = s.getCycles();
        }

        public void fireWhenUnposted(State s, int inum) {
            if (this.show && !this.invokeOnly) {
                this.print("unpost interrupt", inum);
            }
        }

        public void report() {
            TermUtil.printSeparator("Interrupt monitor results for node " + this.simulator.getID());
            Terminal.printGreen("Num  Name        Invocations  Separation  Latency     Wakeup");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            for (int cntr = 1; cntr < this.invocations.length; ++cntr) {
                this.meanInvoke[cntr].process();
                this.meanLatency[cntr].process();
                Terminal.printBrightCyan(StringUtil.rightJustify(cntr, 3));
                Terminal.print("  ");
                Terminal.printGreen(StringUtil.leftJustify(this.props.getInterruptName(cntr), 15));
                Terminal.printBrightCyan(StringUtil.rightJustify(this.invocations[cntr], 8));
                Terminal.print("  ");
                Terminal.print(this.invocationSeparation(cntr));
                Terminal.print("  ");
                Terminal.print(this.invocationLatency(cntr));
                Terminal.print("  ");
                Terminal.print(this.invocationWakeup(cntr));
                Terminal.nextln();
            }
            Terminal.nextln();
        }

        private String invocationLatency(int cntr) {
            if (this.invocations[cntr] > 0L) {
                return StringUtil.leftJustify(this.meanLatency[cntr].mean, 10);
            }
            return StringUtil.space(10);
        }

        private String invocationSeparation(int cntr) {
            if (this.invocations[cntr] > 0L) {
                return StringUtil.leftJustify(this.meanInvoke[cntr].mean, 10);
            }
            return StringUtil.space(10);
        }

        private String invocationWakeup(int cntr) {
            if (this.invocations[cntr] > 0L) {
                return StringUtil.leftJustify(this.meanWake[cntr].mean, 10);
            }
            return StringUtil.space(10);
        }
    }
}

