/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.actions.SimAction;
import avrora.core.SourceMapping;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.util.Option;
import cck.util.Util;

public class InteractiveMonitor
extends MonitorFactory {
    protected final Option.List BREAKPOINTS = this.newOptionList("breakpoints", "", "This option selects a list of breakpoints in the program that can be either labels (such as the start of a function) or hexadecimal addresses that begin with \"0x\". Breakpoints will be inserted into the program and the simulation will terminate when any of these locations are reached.");

    public InteractiveMonitor() {
        super("The \"interactive\" monitor allows the user to interact with the program asit executes, including placing breakpoints, watchpoints, and inspecting the stateof the simulation. Currently, it only supports terminating the simulation at breakpoints.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public static class BreakPointProbe
    extends Simulator.Probe.Empty {
        public void fireBefore(State s, int pc) {
            throw new SimAction.BreakPointException(pc, s);
        }
    }

    class Mon
    implements Monitor {
        Simulator simulator;
        SourceMapping sourceMap;

        Mon(Simulator s) {
            this.simulator = s;
            this.sourceMap = s.getProgram().getSourceMapping();
            for (String str : InteractiveMonitor.this.BREAKPOINTS.get()) {
                SourceMapping.Location l = this.sourceMap.getLocation(str);
                if (l == null) {
                    Util.userError("Label not found", str);
                }
                this.simulator.insertProbe(new BreakPointProbe(), l.lma_addr);
            }
        }

        public void report() {
        }
    }
}

