/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.text.StringUtil;
import cck.text.Terminal;

public class IcallMonitor
extends MonitorFactory {
    public IcallMonitor() {
        super("The \"icall\" monitor is used to detect possible bogus icalls, it simply checks that the target for each icall has a source mapping associated with it.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        public final Simulator simulator;
        private final SourceMapping sourceMap;

        Mon(Simulator s) {
            this.simulator = s;
            Program p = s.getProgram();
            this.sourceMap = p.getSourceMapping();
            int pc = 0;
            while (pc < p.program_end) {
                LegacyInstr i = (LegacyInstr)p.readInstr(pc);
                if (i != null && i instanceof LegacyInstr.ICALL) {
                    s.insertProbe(new IcallProbe(), pc);
                }
                pc = p.getNextPC(pc);
            }
        }

        public void reportIndirectCall(State state, int pc) {
            LegacyState s = (LegacyState)this.simulator.getState();
            int icall_addr = 2 * s.getRegisterWord(LegacyRegister.getRegisterByNumber(30));
            String icall_fn = this.sourceMap.getName(icall_addr);
            if (icall_addr == 0) {
                Terminal.printRed("OOPS: icall to 0000");
                Terminal.nextln();
                System.exit(-1);
            }
            if (icall_fn == null) {
                Terminal.printRed("OOPS: probably bogus icall to ");
                Terminal.printRed(StringUtil.toHex(icall_addr, 4));
                Terminal.printRed(" " + icall_fn);
                Terminal.nextln();
            }
        }

        public void report() {
        }

        public class IcallProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State state, int pc) {
                Mon.this.reportIndirectCall(state, pc);
            }
        }
    }
}

