/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.avr.AVRProperties;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.output.SimPrinter;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Option;

public class IORegMonitor
extends MonitorFactory {
    final Option.List IOREGS = this.newOptionList("ioregs", "all", "This option accepts a list of IO register names which will be monitored during the simulation. For example, specifying \"PORTA,DDR\" as this option's value will enable monitoring of reads and writes to the PORTA and DDRA IO registers. If the string \"all\" is specified as one of the items of the list, then all IO registers will be monitored.");

    public IORegMonitor() {
        super("This \"ioregs\" monitor tracks the updates to IO registers on the microcontroller, including IO registers corresponding to devices such as the timer, UART, SPI, etc.");
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    class Monitor
    implements avrora.monitors.Monitor {
        SimPrinter printer;

        Monitor(Simulator s) {
            this.printer = SimUtil.getPrinter(s, "monitors.ioregs");
            this.insertWatches(s);
            this.printer.enabled = true;
        }

        private void insertWatches(Simulator s) {
            Microcontroller m = s.getMicrocontroller();
            if (IORegMonitor.this.IOREGS.get().contains("all")) {
                this.insertAllWatches(m, s);
            } else {
                this.insertSingleWatches(m, s);
            }
        }

        private void insertAllWatches(Microcontroller m, Simulator s) {
            AVRProperties props = (AVRProperties)m.getProperties();
            int size = props.ioreg_size;
            for (int cntr = 0; cntr < size; ++cntr) {
                String name = props.getIORegName(cntr);
                if (name == null) {
                    name = StringUtil.to0xHex(cntr, 2);
                }
                s.insertWatch(new Watch(name), cntr + 32);
            }
        }

        private void insertSingleWatches(Microcontroller m, Simulator s) {
            for (String str : IORegMonitor.this.IOREGS.get()) {
                int ior = StringUtil.isHex(str) ? StringUtil.evaluateIntegerLiteral(str) + 32 : m.getProperties().getIORegAddr(str);
                s.insertWatch(new Watch(str), ior);
            }
        }

        public void report() {
        }

        class Watch
        extends Simulator.Watch.Empty {
            String name;

            Watch(String name) {
                this.name = StringUtil.leftJustify(name, 6);
            }

            public void fireBeforeWrite(State state, int data_addr, byte value) {
                Monitor.this.printer.println(this.name + "    <=   " + this.render(value));
            }

            public void fireAfterRead(State state, int data_addr, byte val) {
                Monitor.this.printer.println(this.name + "      -> " + this.render(val));
            }

            private String render(byte value) {
                return StringUtil.toHex(value, 2) + " " + StringUtil.toBin(value, 8);
            }
        }
    }
}

