/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.output.SimPrinter;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class GDBServer
extends MonitorFactory {
    public static String HELP = "The \"gdb\" monitor implements the GNU Debugger (gdb) remote serial protocol. The server will create a server socket which GDB can connect to in order to send commands to Avrora. This allows gdb to be used as a front end for debugging a program running inside of Avrora.";
    private final Option.Long PORT = this.newOption("port", 10001L, "This option specifies the port on which the GDB server will listen for a connection from the GDB front-end.");

    public GDBServer() {
        super(HELP);
    }

    public Monitor newMonitor(Simulator s) {
        return new GDBMonitor(s, (int)this.PORT.get());
    }

    protected class GDBMonitor
    implements Monitor {
        final Simulator simulator;
        ServerSocket serverSocket;
        Socket socket;
        InputStream input;
        OutputStream output;
        final int port;
        BreakpointProbe BREAKPROBE = new BreakpointProbe();
        StepProbe STEPPROBE = new StepProbe();
        SimPrinter printer;
        boolean isStepping;
        private static final int MEMMASK = 0xF00000;
        private static final int MEMBEGIN = 0x800000;

        GDBMonitor(Simulator s, int p) {
            this.simulator = s;
            this.port = p;
            this.printer = SimUtil.getPrinter(this.simulator, "monitor.gdb");
            try {
                this.serverSocket = new ServerSocket(this.port);
            }
            catch (IOException e) {
                Util.userError("GDBServer could not create socket on port " + this.port, e.getMessage());
            }
            this.simulator.insertProbe(new StartupProbe(), 0);
            this.isStepping = false;
            this.simulator.insertProbe(this.STEPPROBE);
            this.simulator.insertErrorWatch(new ExceptionWatch("sram"));
        }

        public void report() {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                throw Util.failure("Unexpected IOException: " + e);
            }
        }

        void commandLoop(String reply) {
            try {
                String command;
                if (reply != null) {
                    this.sendPacket(reply);
                }
                do {
                    if ((command = this.readCommand()) == null) {
                        Terminal.println("GDBServer: null command, stopping simulator");
                        this.simulator.stop();
                        break;
                    }
                    if (!this.printer.enabled) continue;
                    this.printer.println(" --> " + command);
                } while (!this.executeCommand(command));
            }
            catch (IOException e) {
                throw Util.failure("Unexpected IOException: " + e);
            }
        }

        boolean executeCommand(String command) throws IOException {
            StringCharacterIterator i = new StringCharacterIterator(command);
            if (i.current() == '+') {
                i.next();
            }
            if (!StringUtil.peekAndEat((CharacterIterator)i, '$')) {
                this.commandError();
                return false;
            }
            char c = i.current();
            i.next();
            switch (c) {
                case 'c': {
                    this.sendPlus();
                    return true;
                }
                case 'D': {
                    Terminal.println("GDBServer: disconnected");
                    this.sendPlus();
                    this.simulator.stop();
                    return true;
                }
                case 'g': {
                    this.readAllRegisters();
                    return false;
                }
                case 'G': {
                    break;
                }
                case 'H': {
                    this.sendPacketOK("OK");
                    return false;
                }
                case 'i': {
                    this.isStepping = true;
                    break;
                }
                case 'k': {
                    Terminal.println("GDBServer: killed remotely");
                    this.sendPlus();
                    this.simulator.stop();
                    return true;
                }
                case 'm': {
                    this.readMemory(i);
                    return false;
                }
                case 'M': {
                    break;
                }
                case 'p': {
                    this.readOneRegister(i);
                    return false;
                }
                case 'P': {
                    break;
                }
                case 'q': {
                    break;
                }
                case 's': {
                    this.isStepping = true;
                    this.sendPlus();
                    return true;
                }
                case 'z': {
                    this.setBreakPoint(i, false);
                    return false;
                }
                case 'Z': {
                    this.setBreakPoint(i, true);
                    return false;
                }
                case '?': {
                    this.sendPacketOK("S05");
                    return false;
                }
            }
            this.sendPacketOK("");
            return false;
        }

        private void sendPlus() throws IOException {
            this.output.write(43);
        }

        void commandError() throws IOException {
            this.output.write(45);
        }

        void setBreakPoint(CharacterIterator i, boolean on) throws IOException {
            char num = i.current();
            i.next();
            switch (num) {
                case '0': 
                case '1': {
                    if (!StringUtil.peekAndEat(i, ',')) break;
                    int addr = StringUtil.readHexValue(i, 4);
                    if (!StringUtil.peekAndEat(i, ',')) break;
                    int len = StringUtil.readHexValue(i, 4);
                    for (int cntr = addr; cntr < addr + len; cntr += 2) {
                        this.setBreakPoint(addr, on);
                    }
                    this.sendPacketOK("OK");
                    return;
                }
            }
            this.sendPacketOK("");
        }

        void setBreakPoint(int addr, boolean on) {
            if (on) {
                this.simulator.insertProbe(this.BREAKPROBE, addr);
            } else {
                this.simulator.removeProbe(this.BREAKPROBE, addr);
            }
        }

        void readAllRegisters() throws IOException {
            StringBuffer buf = new StringBuffer(84);
            LegacyState s = (LegacyState)this.simulator.getState();
            for (int cntr = 0; cntr < 32; ++cntr) {
                this.appendGPR(s, cntr, buf);
            }
            this.appendSREG(s, buf);
            this.appendSP(s, buf);
            this.appendPC(s, buf);
            this.sendPacketOK(buf.toString());
        }

        private void appendPC(State s, StringBuffer buf) {
            int pc = s.getPC();
            buf.append(StringUtil.toLowHex(pc & 0xFF, 2));
            buf.append(StringUtil.toLowHex(pc >> 8 & 0xFF, 2));
            buf.append(StringUtil.toLowHex(pc >> 16 & 0xFF, 2));
            buf.append(StringUtil.toLowHex(pc >> 24 & 0xFF, 2));
        }

        private void appendSP(State s, StringBuffer buf) {
            buf.append(StringUtil.toLowHex(s.getSP() & 0xFF, 2));
            buf.append(StringUtil.toLowHex(s.getSP() >> 8 & 0xFF, 2));
        }

        private void appendSREG(LegacyState s, StringBuffer buf) {
            buf.append(StringUtil.toLowHex(s.getSREG() & 0xFF, 2));
        }

        private void appendGPR(LegacyState s, int cntr, StringBuffer buf) {
            byte value = s.getRegisterByte(LegacyRegister.getRegisterByNumber(cntr));
            buf.append(StringUtil.toLowHex(value & 0xFF, 2));
        }

        void readOneRegister(CharacterIterator i) throws IOException {
            StringBuffer buf = new StringBuffer(8);
            LegacyState s = (LegacyState)this.simulator.getState();
            int num = StringUtil.readHexValue(i, 2);
            if (num < 32) {
                this.appendGPR(s, num, buf);
            } else if (num == 32) {
                this.appendSREG(s, buf);
            } else if (num == 33) {
                this.appendSP(s, buf);
            } else if (num == 34) {
                this.appendPC(s, buf);
            } else {
                buf.append("ERR");
            }
            this.sendPacketOK(buf.toString());
        }

        void readMemory(CharacterIterator i) throws IOException {
            int addr = StringUtil.readHexValue(i, 8);
            int length = 1;
            if (StringUtil.peekAndEat(i, ',')) {
                length = StringUtil.readHexValue(i, 8);
            }
            LegacyState s = (LegacyState)this.simulator.getState();
            StringBuffer buf = new StringBuffer(length * 2);
            if ((addr & 0xF00000) == 0x800000) {
                addr &= 0xFF0FFFFF;
                for (int cntr = 0; cntr < length; ++cntr) {
                    byte value = s.getDataByte(addr + cntr);
                    buf.append(StringUtil.toLowHex(value & 0xFF, 2));
                }
            } else {
                for (int cntr = 0; cntr < length; ++cntr) {
                    byte value = s.getProgramByte(addr + cntr);
                    buf.append(StringUtil.toLowHex(value & 0xFF, 2));
                }
            }
            this.sendPacketOK(buf.toString());
        }

        void sendPacketOK(String s) throws IOException {
            this.sendPlus();
            this.sendPacket(s);
        }

        void sendPacket(String packet) throws IOException {
            byte[] bytes = packet.getBytes();
            int cksum = 0;
            int cntr = 0;
            while (cntr < bytes.length) {
                cksum += bytes[cntr++];
            }
            String np = '$' + packet + '#' + StringUtil.toLowHex(cksum & 0xFF, 2);
            if (this.printer.enabled) {
                this.printer.println("   <-- " + np + "");
            }
            this.output.write(np.getBytes());
        }

        String readCommand() throws IOException {
            int i = this.input.read();
            if (i < 0) {
                return null;
            }
            StringBuffer buf = new StringBuffer(32);
            buf.append((char)i);
            do {
                if ((i = this.input.read()) < 0) {
                    return buf.toString();
                }
                buf.append((char)i);
            } while (i != 35);
            int i2 = this.input.read();
            int i3 = this.input.read();
            if (i2 >= 0) {
                buf.append((char)i2);
            }
            if (i3 >= 0) {
                buf.append((char)i3);
            }
            return buf.toString();
        }

        protected class StepProbe
        implements Simulator.Probe {
            protected StepProbe() {
            }

            public void fireBefore(State s, int pc) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("--IN STEP PROBE @ " + StringUtil.addrToString(pc) + "--");
                }
                if (GDBMonitor.this.isStepping) {
                    GDBMonitor.this.isStepping = false;
                    GDBMonitor.this.commandLoop("T05");
                }
            }

            public void fireAfter(State s, int pc) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("--AFTER STEP PROBE @ " + StringUtil.addrToString(pc) + "--");
                }
            }
        }

        protected class BreakpointProbe
        extends Simulator.Probe.Empty {
            protected BreakpointProbe() {
            }

            public void fireBefore(State s, int pc) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("--IN BREAKPOINT PROBE @ " + StringUtil.addrToString(pc) + "--");
                }
                GDBMonitor.this.isStepping = false;
                GDBMonitor.this.commandLoop("T05");
            }
        }

        protected class StartupProbe
        implements Simulator.Probe {
            protected StartupProbe() {
            }

            public void fireBefore(State s, int pc) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("--IN STARTUP PROBE @ " + StringUtil.addrToString(pc) + "--");
                }
                Terminal.println("GDBServer listening on port " + GDBMonitor.this.port + "...");
                Terminal.flush();
                try {
                    GDBMonitor.this.socket = GDBMonitor.this.serverSocket.accept();
                    GDBMonitor.this.input = GDBMonitor.this.socket.getInputStream();
                    GDBMonitor.this.output = GDBMonitor.this.socket.getOutputStream();
                    if (GDBMonitor.this.printer.enabled) {
                        GDBMonitor.this.printer.println("Connection established with: " + GDBMonitor.this.socket.getInetAddress().getCanonicalHostName());
                    }
                    GDBMonitor.this.serverSocket.close();
                }
                catch (IOException e) {
                    throw Util.failure("Unexpected IOException: " + e);
                }
                GDBMonitor.this.commandLoop(null);
            }

            public void fireAfter(State s, int pc) {
                GDBMonitor.this.simulator.removeProbe(this, pc);
            }
        }

        protected class ExceptionWatch
        extends Simulator.Watch.Empty {
            protected final String segment;

            protected ExceptionWatch(String s) {
                this.segment = s;
            }

            public void fireBeforeRead(State s, int address) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("GDB caught invalid read of " + this.segment + " at " + address);
                }
                GDBMonitor.this.commandLoop("T11");
            }

            public void fireBeforeWrite(State s, int address, byte val) {
                if (GDBMonitor.this.printer.enabled) {
                    GDBMonitor.this.printer.println("GDB caught invalid write of " + this.segment + " at " + address);
                }
                GDBMonitor.this.commandLoop("T11");
            }
        }
    }
}

