/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.legacy.LegacyInstr;
import avrora.core.ControlFlowGraph;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.text.TermUtil;
import cck.text.Terminal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class EnergyProfiler
extends MonitorFactory {
    public EnergyProfiler() {
        super("The \"energy profile\" monitor tracks the power consumption of procedures and displays a report at the end of execution.");
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class EnergyProfile {
        public long cycles = 0L;
        public SourceMapping.Location location;

        public EnergyProfile(SourceMapping.Location loc) {
            this.location = loc;
        }
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        private final Simulator simulator;
        private final Program program;
        private final HashMap labelLookup;
        private final LinkedList profiles;
        private final ProcedureProbe procedureProbe;
        private final SleepProbe sleepProbe;
        private EnergyProfile currentMode;
        private long lastChange;
        private long sleepCycles;

        Monitor(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.labelLookup = new HashMap();
            this.profiles = new LinkedList();
            this.procedureProbe = new ProcedureProbe();
            this.sleepCycles = 0L;
            this.sleepProbe = new SleepProbe();
            this.findSleep();
            this.setupLabels();
            this.lastChange = 0L;
            this.currentMode = this.nearestLabel(0);
            Iterator it = this.program.getCFG().getSortedBlockIterator();
            while (it.hasNext()) {
                ControlFlowGraph.Block block = (ControlFlowGraph.Block)it.next();
                int size = block.getSize();
                int address = block.getAddress();
                if (size <= 0 || this.program.readInstr(address) == null) continue;
                this.labelLookup.put(new Integer(address), this.nearestLabel(address));
                s.insertProbe(this.procedureProbe, address);
            }
        }

        private void setupLabels() {
            Iterator it = this.program.getSourceMapping().getIterator();
            while (it.hasNext()) {
                SourceMapping.Location tempLoc = (SourceMapping.Location)it.next();
                if (!".text".equals(tempLoc.section)) continue;
                this.profiles.add(new EnergyProfile(tempLoc));
            }
        }

        private EnergyProfile nearestLabel(int address) {
            Iterator it = this.profiles.iterator();
            EnergyProfile match = null;
            while (it.hasNext()) {
                EnergyProfile temp = (EnergyProfile)it.next();
                if (temp.location.lma_addr > address || match != null && temp.location.lma_addr <= match.location.lma_addr) continue;
                match = temp;
            }
            return match;
        }

        private void findSleep() {
            int i = 0;
            while (i < this.program.program_length) {
                LegacyInstr instr = (LegacyInstr)this.program.readInstr(i);
                if (instr != null) {
                    if ("sleep".equals(instr.properties.name)) {
                        this.simulator.insertProbe(this.sleepProbe, i);
                    }
                    i += instr.getSize();
                    continue;
                }
                ++i;
            }
        }

        public void report() {
            long cycles = this.simulator.getState().getCycles() - this.lastChange;
            if (cycles > 0L) {
                if (this.currentMode != null) {
                    this.currentMode.cycles += cycles;
                } else {
                    this.sleepCycles += cycles;
                }
            }
            TermUtil.printSeparator("Energy breakdown for node " + this.simulator.getID());
            Terminal.printCyan("notation: procedureName@Address: cycles\n");
            for (EnergyProfile profile : this.profiles) {
                if (profile.cycles <= 0L) continue;
                Terminal.println("   " + profile.location.name + '@' + profile.location.lma_addr + ": " + profile.cycles);
            }
            if (this.sleepCycles > 0L) {
                Terminal.println("   sleeping: " + this.sleepCycles);
            }
            Terminal.println("");
        }

        public class SleepProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State s, int pc) {
                long cycles = Monitor.this.simulator.getState().getCycles() - Monitor.this.lastChange;
                if (cycles > 0L) {
                    if (Monitor.this.currentMode != null) {
                        ((Monitor)Monitor.this).currentMode.cycles += cycles;
                    } else {
                        Monitor.this.sleepCycles += cycles;
                    }
                }
                Monitor.this.lastChange = Monitor.this.simulator.getState().getCycles();
                Monitor.this.currentMode = null;
            }
        }

        public class ProcedureProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State s, int pc) {
                long cycles = Monitor.this.simulator.getState().getCycles() - Monitor.this.lastChange;
                if (cycles > 0L) {
                    if (Monitor.this.currentMode != null) {
                        ((Monitor)Monitor.this).currentMode.cycles += cycles;
                    } else {
                        Monitor.this.sleepCycles += cycles;
                    }
                }
                Monitor.this.lastChange = Monitor.this.simulator.getState().getCycles();
                Monitor.this.currentMode = (EnergyProfile)Monitor.this.labelLookup.get(new Integer(pc));
            }
        }
    }
}

