/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.clock.Clock;
import avrora.sim.clock.MainClock;
import avrora.sim.energy.Energy;
import avrora.sim.energy.EnergyControl;
import avrora.sim.energy.EnergyObserver;
import avrora.sim.platform.Platform;
import avrora.sim.util.SimUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

public class EnergyMonitor
extends MonitorFactory {
    protected final Option.Double BATTERY = this.newOption("battery", 0.0, "This option specifies the number of joules in each node's battery. During simulation, the energy consumption of each node is tracked, and if the node runs out of battery, it will be shut down and removed from the simulation.");
    protected final Option.Str LOG = this.newOption("logfile", "", "This option specifies whether the energy monitor should log changes to each node's energy state. If this option is specified, then each node's energy state transitions will be written to <option>.#, where '#' represents the node ID.");

    public EnergyMonitor() {
        super("The \"energy\" is a monitor to trace energy consumption.");
    }

    public EnergyMonitor(String s2) {
        super(s2);
    }

    public avrora.monitors.Monitor newMonitor(Simulator s) {
        return new Monitor(s);
    }

    public class Monitor
    implements avrora.monitors.Monitor {
        protected Simulator simulator;
        protected Platform platform;
        protected EnergyControl.Instance instance;
        private double energy;
        protected BatteryCheck batteryCheck;
        protected Logger logger;

        Monitor(Simulator s) {
            double d;
            this.simulator = s;
            this.platform = s.getMicrocontroller().getPlatform();
            EnergyControl.activate();
            this.instance = EnergyControl.getCurrentInstance();
            EnergyControl.nextInstance();
            this.energy = EnergyMonitor.this.BATTERY.get();
            if (d > 0.0) {
                this.batteryCheck = new BatteryCheck();
            }
            if (!EnergyMonitor.this.LOG.isBlank()) {
                this.logger = new Logger();
            }
        }

        public void report() {
            TermUtil.printSeparator("Energy consumption results for node " + this.simulator.getID());
            MainClock clock = this.simulator.getClock();
            long cycles = ((Clock)clock).getCount();
            Terminal.println("Node lifetime: " + cycles + " cycles,  " + clock.cyclesToMillis(cycles) / 1000.0 + " seconds\n");
            for (Energy en : this.instance.consumer) {
                int modes = en.getModeNumber();
                Terminal.println(en.getName() + ": " + en.getTotalConsumedEnergy() + " Joule");
                for (int j = 0; j < modes; ++j) {
                    if (modes > 10 && en.getCycles(j) <= 0L) continue;
                    Terminal.println("   " + en.getModeName(j) + ": " + en.getConsumedEnergy(j) + " Joule, " + en.getCycles(j) + " cycles");
                }
                Terminal.nextln();
            }
            if (this.logger != null) {
                this.logger.finish();
            }
        }

        public class Logger
        implements EnergyObserver {
            private BufferedWriter file;
            protected State state;

            Logger() {
                this.state = Monitor.this.simulator.getState();
                Monitor.this.instance.subscribe(this);
                String fileName = EnergyMonitor.this.LOG.get() + Monitor.this.simulator.getID();
                try {
                    this.file = new BufferedWriter(new FileWriter(fileName));
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
                this.write("cycle ");
                for (Energy en : Monitor.this.instance.consumer) {
                    this.write(en.getName() + " ");
                }
                this.write("total");
                this.newLine();
                this.logCurrentState();
            }

            private void write(String text) {
                try {
                    this.file.write(text);
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
            }

            private void newLine() {
                try {
                    this.file.newLine();
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
            }

            public void finish() {
                this.logCurrentState();
                try {
                    this.file.flush();
                    this.file.close();
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
            }

            public void stateChange(Energy energy) {
                this.logOldState(energy);
                this.logCurrentState();
            }

            private void logCurrentState() {
                this.write(this.state.getCycles() + " ");
                double total = 0.0;
                for (Energy en : Monitor.this.instance.consumer) {
                    double ampere = en.getCurrentAmpere();
                    total += ampere;
                    this.write(ampere + " ");
                }
                this.write(total + "");
                this.newLine();
            }

            private void logOldState(Energy energy) {
                this.write(this.state.getCycles() - 1L + " ");
                double total = 0.0;
                for (Energy en : Monitor.this.instance.consumer) {
                    double ampere = en == energy ? en.getOldAmpere() : en.getCurrentAmpere();
                    total += ampere;
                    this.write(ampere + " ");
                }
                this.write(total + "");
                this.newLine();
            }
        }

        public class BatteryCheck
        implements Simulator.Event {
            private static final int interval = 737280;

            public BatteryCheck() {
                Monitor.this.simulator.insertEvent(this, 737280L);
            }

            public void fire() {
                double totalEnergy = 0.0;
                Iterator it = Monitor.this.instance.consumer.iterator();
                while (it.hasNext()) {
                    totalEnergy += ((Energy)it.next()).getTotalConsumedEnergy();
                }
                if (totalEnergy <= Monitor.this.energy) {
                    Monitor.this.simulator.insertEvent(this, 737280L);
                } else {
                    String itstr = SimUtil.getIDTimeString(Monitor.this.simulator);
                    Terminal.print(itstr);
                    Terminal.printYellow("energy limit exceeded: " + totalEnergy + " joules");
                    Terminal.nextln();
                    Monitor.this.simulator.stop();
                }
            }
        }
    }
}

