/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.SourceMapping;
import avrora.monitors.CallTrace;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.MCUProperties;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;

public class CallTreeProfiler
extends MonitorFactory {
    private static final int MAX_CALL_DEPTH = 100;
    final Option.Long DEPTH;
    final Option.Double THRESHOLD;

    public CallTreeProfiler() {
        super("The call tree monitor builds a complete call tree and records the time spent executing each function, both internally and in nested calls.");
        this.DEPTH = this.options.newOption("profile-depth", 5L, "This option controls how deep the display of the whole-program profiler goes.");
        this.THRESHOLD = this.options.newOption("profile-threshold", 0.0, "This option controls the threshold at which call subtrees are show in the profiler.");
    }

    public Monitor newMonitor(Simulator s) {
        return new ProfileMonitor(s);
    }

    static class Entry
    implements Comparable {
        final String name;
        final int count;

        Entry(String name, int count) {
            this.name = name;
            this.count = count;
        }

        public int compareTo(Object o) {
            Entry e = (Entry)o;
            if (this.count < e.count) {
                return -1;
            }
            if (this.count == e.count) {
                return this.name.compareTo(e.name);
            }
            return 1;
        }
    }

    public class ProfileMonitor
    implements CallTrace.Monitor,
    Monitor {
        private final CallTreeNode[] stack = new CallTreeNode[100];
        private final CallTreeNode[] interrupts;
        private final double threshold;
        private int stackDepth;
        private final Simulator simulator;
        private final SourceMapping sourceMapping;
        private final MainClock clock;

        ProfileMonitor(Simulator sim) {
            this.threshold = CallTreeProfiler.this.THRESHOLD.get();
            this.stack[0] = new CallTreeNode();
            this.simulator = sim;
            this.sourceMapping = this.simulator.getProgram().getSourceMapping();
            this.clock = this.simulator.getClock();
            new CallTrace(sim).attachMonitor(this);
            this.interrupts = new CallTreeNode[this.simulator.getInterpreter().getInterruptTable().getNumberOfInterrupts()];
            for (int i = 0; i < this.interrupts.length; ++i) {
                this.interrupts[i] = new CallTreeNode();
                this.interrupts[i].address = -1 - i;
            }
        }

        public void fireBeforeCall(long time, int pc, int target) {
            CallTreeNode parent = this.stack[this.stackDepth];
            CallTreeNode thisNode = parent.children;
            while (thisNode != null && thisNode.address != target) {
                thisNode = thisNode.sibling;
            }
            if (thisNode == null) {
                thisNode = new CallTreeNode();
                thisNode.address = target;
                thisNode.sibling = parent.children;
                parent.children = thisNode;
            }
            thisNode.startcycles = time;
            this.stack[++this.stackDepth] = thisNode;
        }

        public void fireAfterReturn(long time, int pc, int retaddr) {
            this.popStack(time);
        }

        private void popStack(long time) {
            CallTreeNode thisNode = this.stack[this.stackDepth--];
            ++thisNode.count;
            long elapsed = time - thisNode.startcycles;
            thisNode.accumulated += elapsed;
            if (thisNode.address < 0) {
                this.stack[this.stackDepth].accumulated -= elapsed;
            }
        }

        public void fireBeforeInterrupt(long time, int pc, int inum) {
            CallTreeNode thisNode = this.interrupts[inum];
            thisNode.startcycles = time;
            this.stack[++this.stackDepth] = thisNode;
        }

        public void fireAfterInterruptReturn(long time, int pc, int retaddr) {
            this.popStack(time);
        }

        public void report() {
            while (this.stackDepth > 0) {
                this.fireAfterReturn(this.clock.getCount(), 0, 0);
            }
            long total = 0L;
            CallTreeNode root = this.stack[0];
            CallTreeNode child = root.children;
            while (child != null) {
                total += child.accumulated;
                child = child.sibling;
            }
            root.accumulated = total;
            this.reportSubTree(root, 0, root.accumulated);
            for (int i = 0; i < this.interrupts.length; ++i) {
                if (this.interrupts[i].count <= 0) continue;
                this.reportSubTree(this.interrupts[i], 0, this.interrupts[i].accumulated);
            }
        }

        private void reportSubTree(CallTreeNode node, int indent, double pval) {
            long nested;
            long inside = nested = node.accumulated;
            CallTreeNode child = node.children;
            while (child != null) {
                inside -= child.accumulated;
                child = child.sibling;
            }
            float insidePercent = this.asPercent(inside, pval);
            float nestedPercent = this.asPercent(nested, pval);
            Terminal.print(StringUtil.space(indent * 4));
            Terminal.printGreen(StringUtil.leftJustify(this.getNodeName(node), 40));
            Terminal.printCyan("" + inside);
            Terminal.print(" cycles ");
            Terminal.printCyan(StringUtil.toFixedFloat(insidePercent, 5));
            Terminal.print(" % / ");
            Terminal.printCyan("" + node.count);
            Terminal.print(" = ");
            if (node.count > 0) {
                Terminal.printCyan(StringUtil.toFixedFloat(inside / (long)node.count, 2));
            }
            Terminal.print(" (");
            Terminal.print("" + nested);
            Terminal.print(" total ");
            Terminal.print(StringUtil.toFixedFloat(nestedPercent, 5));
            Terminal.print(" %)");
            Terminal.nextln();
            if ((long)indent < CallTreeProfiler.this.DEPTH.get()) {
                child = node.children;
                while (child != null) {
                    this.reportSubTree(child, indent + 1, pval);
                    child = child.sibling;
                }
            }
        }

        String getNodeName(CallTreeNode node) {
            if (node.address > 0) {
                return this.sourceMapping.getName(node.address);
            }
            if (node.address < 0) {
                MCUProperties mcuProperties = this.simulator.getMicrocontroller().getProperties();
                int inum = 0 - node.address;
                return "#" + inum + " " + mcuProperties.getInterruptName(inum);
            }
            return "root";
        }

        private float asPercent(double nval, double pval) {
            return (float)(100.0 * nval / pval);
        }
    }

    static class CallTreeNode {
        int address;
        CallTreeNode sibling;
        CallTreeNode children;
        int count;
        long accumulated;
        long startcycles;

        CallTreeNode() {
        }
    }
}

