/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.sim.InterruptTable;
import avrora.sim.Simulator;
import avrora.sim.State;

public class CallTrace {
    protected final Simulator simulator;
    protected Monitor monitor;

    public CallTrace(Simulator sim) {
        this.simulator = sim;
        this.attachInstructionProbes(sim);
        this.attachInterruptProbes(sim);
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public void attachMonitor(Monitor m) {
        this.monitor = m;
    }

    private void attachInterruptProbes(Simulator sim) {
        InterruptTable table = sim.getInterpreter().getInterruptTable();
        table.insertProbe(new Probe_interrupt());
    }

    private void attachInstructionProbes(Simulator sim) {
        Program p = sim.getProgram();
        int pc = 0;
        while (pc < p.program_end) {
            LegacyInstr i = (LegacyInstr)p.readInstr(pc);
            if (i != null) {
                if (i instanceof LegacyInstr.CALL) {
                    sim.insertProbe(new Probe_call(this.targetOfCall(i)), pc);
                } else if (i instanceof LegacyInstr.RCALL) {
                    sim.insertProbe(new Probe_call(this.targetOfRCall(i, pc)), pc);
                } else if (i instanceof LegacyInstr.ICALL) {
                    sim.insertProbe(new Probe_icall(), pc);
                } else if (i instanceof LegacyInstr.RET) {
                    sim.insertProbe(new Probe_ret(), pc);
                } else if (i instanceof LegacyInstr.RETI) {
                    sim.insertProbe(new Probe_iret(), pc);
                }
            }
            pc = p.getNextPC(pc);
        }
    }

    private int targetOfCall(LegacyInstr i) {
        return ((LegacyInstr.CALL)i).imm1 * 2;
    }

    private int targetOfRCall(LegacyInstr i, int pc) {
        return ((LegacyInstr.RCALL)i).imm1 * 2 + pc + 2;
    }

    protected class Probe_interrupt
    extends Simulator.InterruptProbe.Empty {
        protected Probe_interrupt() {
        }

        public void fireBeforeInvoke(State s, int inum) {
            if (CallTrace.this.monitor != null) {
                CallTrace.this.monitor.fireBeforeInterrupt(s.getCycles(), s.getPC(), inum);
            }
        }
    }

    protected class Probe_iret
    extends Simulator.Probe.Empty {
        protected Probe_iret() {
        }

        public void fireBefore(State state, int pc) {
            if (CallTrace.this.monitor != null) {
                CallTrace.this.monitor.fireAfterInterruptReturn(state.getCycles(), pc, state.getPC());
            }
        }
    }

    protected class Probe_ret
    extends Simulator.Probe.Empty {
        protected Probe_ret() {
        }

        public void fireAfter(State state, int pc) {
            if (CallTrace.this.monitor != null) {
                CallTrace.this.monitor.fireAfterReturn(state.getCycles(), pc, state.getPC());
            }
        }
    }

    protected class Probe_icall
    extends Simulator.Probe.Empty {
        protected Probe_icall() {
        }

        public void fireBefore(State state, int pc) {
            if (CallTrace.this.monitor != null) {
                LegacyState lstate = (LegacyState)state;
                int target = 2 * lstate.getRegisterWord(LegacyRegister.Z);
                CallTrace.this.monitor.fireBeforeCall(state.getCycles(), pc, target);
            }
        }
    }

    protected class Probe_call
    extends Simulator.Probe.Empty {
        protected final int target;

        protected Probe_call(int tar) {
            this.target = tar;
        }

        public void fireBefore(State state, int pc) {
            if (CallTrace.this.monitor != null) {
                CallTrace.this.monitor.fireBeforeCall(state.getCycles(), pc, this.target);
            }
        }
    }

    public static interface Monitor {
        public void fireBeforeCall(long var1, int var3, int var4);

        public void fireAfterReturn(long var1, int var3, int var4);

        public void fireBeforeInterrupt(long var1, int var3, int var4);

        public void fireAfterInterruptReturn(long var1, int var3, int var4);
    }
}

