/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.CallStack;
import avrora.monitors.CallTrace;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;

public class CallTimeMonitor
extends MonitorFactory {
    final Option.Str METHOD = this.newOption("method", "", "This option specifies the name of the method to profile.");
    final Option.Bool IGNR_INTRS = this.newOption("ignore-interrupts", false, "This option selects whether this monitor will consider time spent in nested interrupts to be part of a method's execution time.");

    public CallTimeMonitor() {
        super("The \"MethodTimeMonitor\" monitor records profiling information about the method that consists of the time it takes (on average) to execute a call.");
    }

    public Monitor newMonitor(Simulator s) {
        return new CallTimeMon(s);
    }

    protected class CallTimeMon
    extends CallStack
    implements Monitor {
        final Simulator simulator;
        final Program program;
        final SourceMapping.Location start;
        final boolean ignore_interrupts;
        long cumul;
        long cumul_sqr;
        int count;
        long max;
        long min;
        int call_depth;
        long[] call_time = new long[256];
        long startInterrupt;
        long endInterrupt;

        CallTimeMon(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.cumul = 0L;
            this.cumul_sqr = 0L;
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.count = 0;
            this.ignore_interrupts = CallTimeMonitor.this.IGNR_INTRS.get();
            this.startInterrupt = 0L;
            this.endInterrupt = 0L;
            this.start = this.getLocation(CallTimeMonitor.this.METHOD.get());
            CallTrace trace = new CallTrace(s);
            trace.attachMonitor(this);
        }

        public void fireAfterReturn(long time, int pc, int retaddr) {
            if (this.getTarget(this.depth - 1) == this.start.lma_addr) {
                this.record(time - this.call_time[--this.call_depth] - (this.endInterrupt - this.startInterrupt));
                this.endInterrupt = 0L;
                this.startInterrupt = 0L;
            }
            this.pop();
        }

        public void fireAfterInterruptReturn(long time, int pc, int retaddr) {
            if (this.ignore_interrupts && this.findCallAddress(this.start.lma_addr)) {
                this.endInterrupt = time;
            }
            super.fireAfterInterruptReturn(time, pc, retaddr);
        }

        public void fireBeforeCall(long time, int pc, int target) {
            if (target == this.start.lma_addr) {
                this.call_time[this.call_depth++] = time;
            }
            super.fireBeforeCall(time, pc, target);
        }

        public void fireBeforeInterrupt(long time, int pc, int inum) {
            if (this.ignore_interrupts && this.findCallAddress(this.start.lma_addr)) {
                this.startInterrupt = time;
            }
            super.fireBeforeInterrupt(time, pc, inum);
        }

        private boolean findCallAddress(int address) {
            for (int i = this.depth - 1; i >= 0; --i) {
                if (this.getTarget(i) != address) continue;
                return true;
            }
            return false;
        }

        private void record(long time) {
            this.cumul += time;
            this.cumul_sqr += time * time;
            this.max = Math.max(this.max, time);
            this.min = Math.min(this.min, time);
            ++this.count;
        }

        private SourceMapping.Location getLocation(String src) {
            SourceMapping lm = this.program.getSourceMapping();
            SourceMapping.Location loc = lm.getLocation(src);
            if (loc == null) {
                Util.userError("Invalid program address: ", src);
            }
            if (this.program.readInstr(loc.lma_addr) == null) {
                Util.userError("Invalid program address: ", src);
            }
            return loc;
        }

        public void report() {
            TermUtil.printSeparator("Call time results for node " + this.simulator.getID());
            Terminal.printGreen(" function                 calls         avg       cumul        max        min");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            float avg = (float)this.cumul / (float)this.count;
            double std2 = Math.sqrt((double)this.cumul_sqr / (double)this.count - (double)(avg * avg));
            Terminal.println(" " + StringUtil.leftJustify(CallTimeMonitor.this.METHOD.get(), 20) + "  " + StringUtil.rightJustify(this.count, 8) + "  " + StringUtil.rightJustify(avg, 10) + "  " + StringUtil.rightJustify(this.cumul, 10) + "  " + StringUtil.rightJustify((float)this.max, 9) + "  " + StringUtil.rightJustify((float)this.min, 9));
            Terminal.nextln();
        }
    }
}

