/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.CallTrace;
import cck.util.Util;

public class CallStack
implements CallTrace.Monitor {
    public static final int MAXDEPTH = 200;
    protected int depth;
    protected final int maxDepth;
    protected final long[] stack;

    public CallStack() {
        this(200);
    }

    public CallStack(int maxdepth) {
        this.maxDepth = maxdepth;
        this.stack = new long[this.maxDepth];
    }

    protected void push(byte inum, int site, int target) {
        this.stack[this.depth++] = CallStack.makeEntry(inum, site, target);
        if (this.depth >= this.maxDepth) {
            throw Util.failure("Stack overflow: more than " + this.maxDepth + " calls nested");
        }
    }

    protected void pop() {
        --this.depth;
        if (this.depth < 0) {
            this.depth = 0;
        }
    }

    public void fireBeforeCall(long time, int pc, int target) {
        this.push((byte)-1, pc, target);
    }

    public void fireAfterReturn(long time, int pc, int retaddr) {
        this.pop();
    }

    public void fireBeforeInterrupt(long time, int pc, int inum) {
        this.push((byte)inum, pc, (inum - 1) * 4);
    }

    public void fireAfterInterruptReturn(long time, int pc, int retaddr) {
        this.pop();
    }

    public static long makeEntry(byte inum, int site, int target) {
        return (long)inum << 48 | (long)target << 24 | (long)site;
    }

    public int getDepth() {
        return this.depth;
    }

    public void clear() {
        this.depth = 0;
    }

    public int getSite(int indx) {
        return (int)(this.stack[indx] & 0xFFFFFFL);
    }

    public int getTarget(int indx) {
        return (int)(this.stack[indx] >> 24 & 0xFFFFFFL);
    }

    public byte getInterrupt(int indx) {
        return (byte)(this.stack[indx] >> 48 & 0xFFFFFFL);
    }
}

