/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.SourceMapping;
import avrora.monitors.CallStack;
import avrora.monitors.CallTrace;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;

public class CallMonitor
extends MonitorFactory {
    protected final Option.Bool SITE = this.newOption("call-sites", true, "When this option is specified, the call monitor will report the address of the instruction in the caller when a call or an interrupt occurs.");
    protected final Option.Bool SHOW = this.newOption("show-stack", true, "When this option is specified, the call monitor trace will print the call stack with each call, interrupt or return. When this option is set to false, this monitor will only indent calls and returns, without printing the entire call stack.");
    protected final Option.Bool EDGE = this.newOption("edge-types", true, "When this option is specified, the call monitor trace will print the type of each call or return. For example, if an interrupt occurs, then the interrupt number and name will be reported.");

    public CallMonitor() {
        super("The \"calls\" monitor tracks the call/return behavior of the program as it executes, displaying the stacking up of function calls and interrupt handlers.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    class Mon
    implements Monitor,
    CallTrace.Monitor {
        private final CallStack stack;
        private final Simulator simulator;
        private final MCUProperties props;
        private final SourceMapping sourceMap;
        private String[] shortNames;

        Mon(Simulator s) {
            this.simulator = s;
            this.sourceMap = s.getProgram().getSourceMapping();
            CallTrace trace = new CallTrace(s);
            this.props = this.simulator.getMicrocontroller().getProperties();
            trace.attachMonitor(this);
            this.buildInterruptNames();
            this.stack = new CallStack();
        }

        private void buildInterruptNames() {
            int cntr;
            String[] longNames = new String[this.props.num_interrupts + 1];
            for (cntr = 0; cntr < this.props.num_interrupts; ++cntr) {
                longNames[cntr] = this.getLongInterruptName(cntr);
            }
            this.shortNames = new String[this.props.num_interrupts + 1];
            for (cntr = 0; cntr < this.props.num_interrupts; ++cntr) {
                this.shortNames[cntr] = this.getShortInterruptName(cntr);
            }
        }

        public void report() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void push(int callsite, int color, String edge, int inum, int target) {
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                this.printStack(this.stack.getDepth(), callsite);
                if (CallMonitor.this.EDGE.get()) {
                    Terminal.print(" --(");
                    Terminal.print(color, edge);
                    Terminal.print(")-> ");
                } else {
                    Terminal.print(" --> ");
                }
                this.printStackEntry(inum, target);
                Terminal.nextln();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        }

        private void printStack(int depth, int callsite) {
            Terminal.print(SimUtil.getIDTimeString(this.simulator));
            for (int cntr = 0; cntr < depth; ++cntr) {
                if (CallMonitor.this.SHOW.get()) {
                    this.printStackEntry(cntr);
                    if (cntr == depth) continue;
                    Terminal.print(":");
                    continue;
                }
                Terminal.print("    ");
            }
            if (CallMonitor.this.SITE.get()) {
                Terminal.print(" @ ");
                Terminal.printBrightCyan(StringUtil.addrToString(callsite));
            }
        }

        private void printStackEntry(int indx) {
            this.printStackEntry(this.stack.getInterrupt(indx), this.stack.getTarget(indx));
        }

        private void printStackEntry(int inum, int target) {
            if (inum >= 0) {
                Terminal.printRed(this.shortNames[inum]);
            }
            Terminal.printGreen(this.sourceMap.getName(target));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pop(int callsite, String edge, int color) {
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                this.printStack(this.stack.getDepth() - 1, callsite);
                if (CallMonitor.this.EDGE.get()) {
                    Terminal.print(" <-(");
                    Terminal.print(color, edge);
                    Terminal.print(")-- ");
                } else {
                    Terminal.print(" <-- ");
                }
                this.printStackEntry(this.stack.getDepth() - 1);
                Terminal.nextln();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        public void fireBeforeCall(long time, int pc, int target) {
            this.push(pc, 3, "CALL", -1, target);
            this.stack.fireBeforeCall(time, pc, target);
        }

        public void fireBeforeInterrupt(long time, int pc, int inum) {
            this.push(pc, 1, this.shortNames[inum], inum, (inum - 1) * 4);
            if (inum == 1) {
                this.stack.clear();
            }
            this.stack.fireBeforeInterrupt(time, pc, inum);
        }

        public void fireAfterReturn(long time, int pc, int retaddr) {
            this.pop(pc, "RET ", 3);
            this.stack.fireAfterReturn(time, pc, retaddr);
        }

        public void fireAfterInterruptReturn(long time, int pc, int retaddr) {
            this.pop(pc, "RETI", 1);
            this.stack.fireAfterInterruptReturn(time, pc, retaddr);
        }

        private String getLongInterruptName(int inum) {
            return inum == 1 ? "RESET" : "#" + inum + "," + this.props.getInterruptName(inum);
        }

        private String getShortInterruptName(int inum) {
            return inum == 1 ? "RESET" : "#" + inum + " ";
        }
    }
}

