/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.AbstractInstr;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.CallStack;
import avrora.monitors.CallTrace;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.Terminal;

public class BreakMonitor
extends MonitorFactory {
    public BreakMonitor() {
        super("The \"break\" monitor watches for execution of an AVR break instruction, which can be used to implement things like assertion failures.  When a break is executed the simulator prints a stack trace.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        public final Simulator simulator;
        public final CallTrace trace;
        public final CallStack stack;
        private final SourceMapping sourceMap;

        Mon(Simulator s) {
            this.simulator = s;
            this.trace = new CallTrace(s);
            this.stack = new CallStack();
            this.trace.attachMonitor(this.stack);
            Program p = s.getProgram();
            this.sourceMap = p.getSourceMapping();
            int pc = 0;
            while (pc < p.program_end) {
                AbstractInstr i = p.readInstr(pc);
                if (i != null && i instanceof LegacyInstr.BREAK) {
                    s.insertProbe(new BreakProbe(), pc);
                }
                pc = p.getNextPC(pc);
            }
        }

        private void printStack(String idstr) {
            int depth = this.stack.getDepth();
            for (int cntr = depth - 1; cntr >= 0; --cntr) {
                Terminal.print(idstr);
                Terminal.print("      @ ");
                byte inum = this.stack.getInterrupt(cntr);
                if (inum >= 0) {
                    Terminal.printRed("#" + inum + ' ');
                }
                Terminal.printGreen(this.sourceMap.getName(this.stack.getTarget(cntr)));
                Terminal.nextln();
            }
        }

        public void report() {
        }

        public class BreakProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State state, int pc) {
                String idstr = SimUtil.getIDTimeString(Mon.this.simulator);
                Terminal.print(idstr);
                Terminal.print("break instruction @ ");
                Terminal.printBrightCyan(StringUtil.addrToString(pc));
                Terminal.print(", r30:r31 = ");
                LegacyState s = (LegacyState)Mon.this.simulator.getState();
                int v = s.getRegisterWord(LegacyRegister.getRegisterByNumber(30));
                Terminal.printGreen(StringUtil.to0xHex(v, 4));
                Terminal.nextln();
                Mon.this.printStack(idstr);
            }
        }
    }
}

