/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.GraphNumbers;
import avrora.gui.MonitorPanel;
import avrora.gui.SingleNodeMonitor;
import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.MCUProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VisualStackMonitor
extends SingleNodeMonitor
implements Simulation.Monitor {
    public VisualStackMonitor() {
        super("stack");
    }

    protected SingleNodeMonitor.SingleNodePanel newPanel(Simulation.Node n, MonitorPanel p) {
        return new SPMon(n, p);
    }

    public class SPMon
    extends SingleNodeMonitor.SingleNodePanel
    implements Simulator.Event,
    MonitorPanel.Updater {
        public Simulator simulator;
        public GraphNumbers graph;
        boolean spinit;
        int stacktop;
        int splAddress;
        int sphAddress;
        InitWatch spl;
        InitWatch sph;

        public void fire() {
            int height = this.spinit ? this.stacktop - this.simulator.getState().getSP() : 0;
            this.graph.recordNumber(height);
            this.simulator.insertEvent(this, 1L);
        }

        SPMon(Simulation.Node n, MonitorPanel p) {
            super(n, p);
        }

        public void construct(Simulator s) {
            JPanel displayPanel = this.panel.displayPanel;
            displayPanel.removeAll();
            displayPanel.setLayout(new BorderLayout());
            this.graph = new GraphNumbers(displayPanel);
            displayPanel.add((Component)this.graph.chalkboardAndBar(), "Center");
            displayPanel.validate();
            JPanel optionsPanel = this.panel.optionsPanel;
            optionsPanel.removeAll();
            optionsPanel.setLayout(new BorderLayout());
            optionsPanel.add((Component)this.graph.getOptionsPanel(), "Center");
            optionsPanel.validate();
            this.panel.setUpdater(this);
            this.simulator = s;
            this.simulator.insertEvent(this, 1L);
            this.spl = new InitWatch();
            this.sph = new InitWatch();
            MCUProperties mp = this.simulator.getMicrocontroller().getProperties();
            this.splAddress = mp.getIOReg("SPL") + 32;
            this.sphAddress = mp.getIOReg("SPH") + 32;
            this.simulator.insertWatch(this.spl, this.splAddress);
            this.simulator.insertWatch(this.sph, this.sphAddress);
        }

        public void destruct() {
            this.simulator.removeEvent(this);
        }

        public void remove() {
            this.simulator.removeEvent(this);
        }

        public void update() {
            if (this.graph.internalUpdate()) {
                this.graph.paint(this.graph.getGraphics());
            }
        }

        class InitWatch
        extends Simulator.Watch.Empty {
            boolean init;

            InitWatch() {
            }

            public void fireAfterWrite(State s, int addr, byte val) {
                this.init = true;
                if (SPMon.this.spl.init && SPMon.this.sph.init) {
                    SPMon.this.spinit = true;
                    SPMon.this.stacktop = s.getSP();
                    SPMon.this.simulator.removeWatch(SPMon.this.spl, SPMon.this.splAddress);
                    SPMon.this.simulator.removeWatch(SPMon.this.sph, SPMon.this.sphAddress);
                }
            }
        }
    }
}

