/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.gui.GraphEvents;
import avrora.gui.GraphNumbers;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.ProgramProfiler;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VisualRegMonitor
extends MonitorFactory {
    public VisualRegMonitor() {
        super("The \"Reg26\" monitor tracks the current value of the reg 26.");
    }

    public Monitor newMonitor(Simulator s) {
        return new VisualMonitor(s);
    }

    public class VisualMonitor
    implements avrora.gui.VisualMonitor,
    Simulator.Probe {
        public final Simulator simulator;
        public final Program program;
        public final ProgramProfiler profile;
        public JPanel visualPanel;
        public JPanel visualOptionsPanel;
        public GraphNumbers theGraph;
        GraphEvents tempEvent;

        public GraphEvents getGraph() {
            return this.tempEvent;
        }

        public void updateDataAndPaint() {
            if (this.theGraph.internalUpdate()) {
                this.theGraph.paint(this.theGraph.getGraphics());
            }
        }

        public void setVisualPanel(JPanel thePanel, JPanel theOptionsPanel) {
            this.visualPanel = thePanel;
            this.visualPanel.removeAll();
            this.visualPanel.setLayout(new BorderLayout());
            this.theGraph = new GraphNumbers(this.visualPanel);
            this.visualPanel.add((Component)this.theGraph, "Center");
            this.visualPanel.validate();
            this.visualOptionsPanel = theOptionsPanel;
            this.visualOptionsPanel.removeAll();
            this.visualOptionsPanel.setLayout(new BorderLayout());
            this.visualOptionsPanel.add((Component)this.theGraph.getOptionsPanel(), "Center");
            this.visualOptionsPanel.validate();
        }

        public void fireBefore(State s, int address) {
        }

        public void fireAfter(State s, int address) {
            int regvalue = ((LegacyState)s).getRegisterUnsigned(LegacyRegister.R26);
            this.theGraph.recordNumber(regvalue);
        }

        VisualMonitor(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.profile = new ProgramProfiler(this.program);
            s.insertProbe(this);
        }

        public void report() {
            this.theGraph.repaint();
        }
    }
}

