/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.core.Program;
import avrora.gui.GraphEvents;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.util.ProgramProfiler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VisualRadioMonitor
extends MonitorFactory {
    public static JPanel masterPanel = new JPanel();
    public static JPanel optionsPanel;
    public static boolean isDisplayed;
    public static Vector allCurrentMonitors;
    public static Vector allCurrentGraphEvents;
    public static int numofnodes;

    public VisualRadioMonitor() {
        super("The \"radio\" monitor tracks radio usage.");
    }

    public Monitor newMonitor(Simulator s) {
        return new VisualMonitor(s);
    }

    static {
        masterPanel.setLayout(new GridLayout(1, 1));
        optionsPanel = new JPanel(false);
        JLabel optionsFiller = new JLabel("Options for the monitor can be set here. ");
        optionsPanel.setLayout(new GridLayout(1, 1));
        optionsPanel.add(optionsFiller);
        isDisplayed = false;
        allCurrentMonitors = new Vector();
        allCurrentGraphEvents = new Vector();
        numofnodes = 1;
    }

    public class VisualMonitor
    implements avrora.gui.VisualMonitor {
        public final Simulator simulator;
        public final Program program;
        public final ProgramProfiler profile;
        public JPanel visualPanel;
        public JPanel visualOptionsPanel;
        public GraphEvents theGraph;
        public Object vSync;

        public void updateDataAndPaint() {
            if (this.theGraph.internalUpdate()) {
                this.theGraph.paint(this.theGraph.getGraphics());
            }
        }

        public GraphEvents getGraph() {
            return this.theGraph;
        }

        public void setVisualPanel(JPanel thePanel, JPanel theOptionsPanel) {
            allCurrentMonitors.add(this);
            this.visualPanel = thePanel;
            this.visualPanel.removeAll();
            this.visualPanel.setLayout(new BorderLayout());
            this.theGraph = new GraphEvents(0, 500, 3.0);
            allCurrentGraphEvents.add(this.theGraph);
            this.theGraph.setParentPanel(this.visualPanel);
            this.visualPanel.add((Component)this.theGraph.chalkboardAndBar(), "Center");
            this.visualPanel.validate();
        }

        VisualMonitor(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.profile = new ProgramProfiler(this.program);
        }

        public void report() {
            this.updateDataAndPaint();
            allCurrentMonitors = new Vector();
            allCurrentGraphEvents = new Vector();
        }
    }
}

