/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import cck.text.StringUtil;
import cck.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.LinkedList;

public class TimeScale {
    final int height;
    long startTime;
    final Color backgroundColor = Color.GRAY;
    final Color borderColor = Color.WHITE;
    final Color tickColor = Color.DARK_GRAY;
    final Color fontColor = Color.RED;
    static final long hz;
    static final double nsPerCycle;
    static final int SCROLL_SIZE = 35;
    static final int MIN_TICK_WIDTH = 40;
    static ZoomLevel[] zooms;
    static int startZoom;
    static final double ONE_BILLION = 1.0E9;
    static final String[] units;
    int zoom = startZoom;

    TimeScale() {
        this.height = 20;
    }

    static ZoomLevel newZoomLevel(double scale) {
        long nsecs = 1L;
        double cycles = TimeScale.getCycles(1L);
        double max = 2L * hz;
        int cntr = 0;
        while (cycles < max) {
            double tickWidth = cycles / scale;
            if (tickWidth > 40.0) {
                int dec = (300 - cntr) % 3;
                return new ZoomLevel(scale, dec, nsecs, units[(cntr + 2) / 3]);
            }
            cycles *= 10.0;
            nsecs *= 10L;
            ++cntr;
        }
        throw Util.failure("Zoom level not supported: " + scale);
    }

    public int getMaxZoom() {
        return zooms.length - 1;
    }

    public void drawScale(Dimension dim, Graphics g) {
        g.setColor(this.backgroundColor);
        int y = dim.height - this.height;
        int my = (int)((double)y + (double)this.height * 0.6);
        int medy = (int)((double)y + (double)this.height * 0.4);
        g.fillRect(0, y, dim.width, dim.height);
        g.setFont(g.getFont().deriveFont(9.0f));
        ZoomLevel zl = this.getZoomLevel();
        long startNsecs = (long)this.getNS(this.startTime);
        long ns = startNsecs - startNsecs % zl.nsecs;
        double startPos = (TimeScale.getCycles(ns) - (double)this.startTime) / zl.scale;
        int count = (int)(ns / zl.nsecs % 1000L);
        double cycWidth = 1.0 / zl.scale;
        if (cycWidth >= 2.0) {
            g.setColor(this.borderColor);
            for (double pos = 0.0; pos < (double)dim.width; pos += cycWidth) {
                int xpos = (int)pos;
                g.drawLine(xpos, y, xpos, y + 4);
            }
        }
        g.setColor(this.tickColor);
        double max = (double)dim.width + zl.majorTickWidth;
        for (double pos = startPos; pos < max; pos += zl.majorTickWidth) {
            for (int mt = 1; mt < 10; ++mt) {
                int mx = (int)(pos + zl.minorTickWidth * (double)mt);
                if (mt == 5) {
                    g.drawLine(mx, medy, mx, dim.height);
                    continue;
                }
                g.drawLine(mx, my, mx, dim.height);
            }
            int xpos = (int)pos;
            g.drawLine(xpos, 0, xpos, dim.height);
            this.drawTickLabel(zl, count, g, xpos, y);
            if (++count != 1000) continue;
            count = 0;
        }
        g.setColor(this.borderColor);
        g.drawLine(0, y, dim.width, y);
    }

    private double getNS(long cycles) {
        return (double)cycles * nsPerCycle;
    }

    private static double getCycles(long nsecs) {
        return (double)nsecs / nsPerCycle;
    }

    private void drawTickLabel(ZoomLevel zl, int tick, Graphics g, int cntr, int y) {
        String str = StringUtil.toDecimal(tick, zl.dec);
        FontMetrics m = g.getFontMetrics();
        String stru = str + " " + this.getZoomLevel().units;
        int width = m.stringWidth(stru);
        g.setColor(this.fontColor);
        g.drawString(stru, cntr - width + 5, y - 2);
        g.setColor(this.tickColor);
    }

    public int getZoom() {
        return this.zoom;
    }

    private ZoomLevel getZoomLevel() {
        return zooms[this.zoom];
    }

    public int getX(long time) {
        if (time < this.startTime) {
            return -1;
        }
        return (int)((double)(time - this.startTime) / this.getZoomLevel().scale);
    }

    public void setZoom(int nzoom) {
        if (nzoom >= zooms.length) {
            nzoom = zooms.length - 1;
        }
        if (nzoom < 0) {
            nzoom = 0;
        }
        this.zoom = nzoom;
    }

    public void zoomin() {
        if (this.zoom < zooms.length - 1) {
            ++this.zoom;
        }
    }

    public void zoomout() {
        if (this.zoom > 0) {
            --this.zoom;
        }
    }

    public int getExtent(int width, long maxtime) {
        return width / 35;
    }

    public int getScrollBarSize(long maxtime) {
        return this.size(maxtime);
    }

    public void setPosition(int np) {
        this.startTime = (long)((double)(np * 35) * this.getZoomLevel().scale);
    }

    public int getPosition() {
        return this.size(this.startTime);
    }

    private int size(long cycles) {
        return (int)((double)cycles / this.getZoomLevel().scale / 35.0);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getScale() {
        return this.getZoomLevel().scale;
    }

    static {
        units = new String[]{"ns", "us", "ms", "s"};
        hz = 0x708000L;
        nsPerCycle = 1.0E9 / (double)hz;
        double scaleup = 1.25895;
        double s100 = (double)hz / 100.0;
        zooms = new ZoomLevel[0];
        LinkedList<ZoomLevel> lout = new LinkedList<ZoomLevel>();
        for (double scale = s100; scale > 1.0; scale /= scaleup) {
            lout.add(TimeScale.newZoomLevel(scale));
        }
        ZoomLevel[] zout = lout.toArray(zooms);
        LinkedList<ZoomLevel> lin = new LinkedList<ZoomLevel>();
        for (double scale = 1.0; scale > 0.02; scale /= scaleup) {
            lin.add(TimeScale.newZoomLevel(scale));
        }
        ZoomLevel[] zin = lin.toArray(zooms);
        zooms = new ZoomLevel[lout.size() + lin.size()];
        System.arraycopy(zout, 0, zooms, 0, zout.length);
        System.arraycopy(zin, 0, zooms, zout.length, zin.length);
        startZoom = zout.length;
    }

    static class ZoomLevel {
        final double scale;
        final int dec;
        final long nsecs;
        final String units;
        final double majorTickWidth;
        final double minorTickWidth;

        ZoomLevel(double s, int d, long ns, String un) {
            this.scale = s;
            this.dec = d;
            this.nsecs = ns;
            this.units = un;
            this.majorTickWidth = TimeScale.getCycles(this.nsecs) / this.scale;
            this.minorTickWidth = this.majorTickWidth / 10.0;
        }
    }
}

