/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.AvroraGui;
import avrora.gui.MonitorPanel;
import avrora.sim.Simulation;
import avrora.sim.Simulator;
import java.util.HashMap;
import java.util.List;

public abstract class SingleNodeMonitor
implements Simulation.Monitor {
    final HashMap panelMap = new HashMap();
    final HashMap monitorMap = new HashMap();
    final String monitorName;

    public SingleNodeMonitor(String n) {
        this.monitorName = n;
    }

    public void attach(Simulation sim, List nodes) {
        for (Simulation.Node n : nodes) {
            if (this.panelMap.containsKey(n)) continue;
            MonitorPanel p = AvroraGui.instance.createMonitorPanel(this.monitorName + " - " + n.id);
            SingleNodePanel snp = this.newPanel(n, p);
            this.panelMap.put(n, snp);
            n.addMonitor(this);
        }
    }

    public void construct(Simulation sim, Simulation.Node n, Simulator s) {
        SingleNodePanel snp = (SingleNodePanel)this.panelMap.get(n);
        snp.construct(s);
    }

    public void destruct(Simulation sim, Simulation.Node n, Simulator s) {
        SingleNodePanel snp = (SingleNodePanel)this.panelMap.get(n);
        snp.destruct();
    }

    public void remove(Simulation sim, List nodes) {
        for (Simulation.Node n : nodes) {
            this.removeOne(n);
        }
    }

    private void removeOne(Simulation.Node n) {
        SingleNodePanel snp = (SingleNodePanel)this.panelMap.get(n);
        if (snp == null) {
            return;
        }
        snp.remove();
        AvroraGui.instance.removeMonitorPanel(snp.panel);
        this.panelMap.remove(n);
        n.removeMonitor(this);
    }

    protected abstract SingleNodePanel newPanel(Simulation.Node var1, MonitorPanel var2);

    protected abstract class SingleNodePanel {
        protected final Simulation.Node node;
        protected final MonitorPanel panel;

        SingleNodePanel(Simulation.Node n, MonitorPanel p) {
            this.node = n;
            this.panel = p;
        }

        protected abstract void construct(Simulator var1);

        protected abstract void destruct();

        protected abstract void remove();
    }
}

