/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.AvroraGui;
import avrora.sim.Simulation;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ManageTopology {
    public JPanel topologyVisual;
    public JTable table;
    public DefaultTableModel theModel;

    public static ManageTopology createManageTopology() {
        ManageTopology theSetup = new ManageTopology();
        theSetup.topologyVisual = new JPanel();
        theSetup.createSimpleAirTable();
        theSetup.topologyVisual.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Manage Topology"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return theSetup;
    }

    public void createSimpleAirTable() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Node ID");
        columnNames.add("Program");
        columnNames.add("Monitors");
        this.theModel = new DefaultTableModel(columnNames, 0);
        this.table = new JTable(this.theModel);
        Iterator ni = AvroraGui.instance.getSimulation().getNodeIterator();
        while (ni.hasNext()) {
            Simulation.Node currentNode = (Simulation.Node)ni.next();
            Vector<Object> tempVector = new Vector<Object>();
            tempVector.add(new Integer(currentNode.id));
            tempVector.add(currentNode.getProgram().getName());
            Iterator i = currentNode.getMonitors().iterator();
            StringBuffer mstrBuffer = new StringBuffer(100);
            while (i.hasNext()) {
                mstrBuffer.append(i.next());
                if (!i.hasNext()) continue;
                mstrBuffer.append(",");
            }
            tempVector.add(mstrBuffer.toString());
            this.theModel.addRow(tempVector);
        }
        JScrollPane scrollpane = new JScrollPane(this.table);
        this.topologyVisual.removeAll();
        this.topologyVisual.add(scrollpane);
        this.table.setAutoResizeMode(4);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.topologyVisual.revalidate();
    }

    public void removeSelectedNodes() {
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Integer integer = (Integer)this.theModel.getValueAt(selectedRows[i], 0);
            AvroraGui.instance.getSimulation().removeNode(integer);
        }
        this.createSimpleAirTable();
    }
}

