/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.AvroraGui;
import avrora.gui.DebugStream;
import avrora.sim.Simulation;
import cck.text.Terminal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class ManageSimTime {
    public JPanel simTimeEverything;
    private JToolBar simTimeToolbar;
    private JSlider simTimeSlider;
    private SpinnerNumberModel simTimeDelaySpinner;
    private SpinnerNumberModel simTimeCycleSpinner;
    private JComboBox simTimeIorCSelect;
    private static int[] simTimeDelayDefaults;
    private static int[] simTimeCycleDefaults;
    private static int numofdefaults;
    private static final String REWIND = "rewind";
    private static final String STOP = "stop";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String FASTFORWARD = "fastforward";
    private int olddelay;
    private long oldinbetweenperiod;
    private boolean oldiorc;
    private int oldeventtype;

    public static ManageSimTime createManageSimTime() {
        ManageSimTime thesetup = new ManageSimTime();
        numofdefaults = 6;
        simTimeDelayDefaults = new int[numofdefaults];
        simTimeCycleDefaults = new int[numofdefaults];
        ManageSimTime.simTimeDelayDefaults[0] = 0;
        ManageSimTime.simTimeCycleDefaults[0] = 0;
        ManageSimTime.simTimeDelayDefaults[1] = 0;
        ManageSimTime.simTimeCycleDefaults[1] = 0;
        ManageSimTime.simTimeDelayDefaults[2] = 100;
        ManageSimTime.simTimeCycleDefaults[2] = 1000;
        ManageSimTime.simTimeDelayDefaults[3] = 1000;
        ManageSimTime.simTimeCycleDefaults[3] = 10;
        ManageSimTime.simTimeDelayDefaults[4] = 1000;
        ManageSimTime.simTimeCycleDefaults[4] = 1;
        ManageSimTime.simTimeDelayDefaults[5] = 0;
        ManageSimTime.simTimeCycleDefaults[5] = 0;
        Hashtable<Integer, JLabel> temptable = new Hashtable<Integer, JLabel>();
        temptable.put(new Integer(-1), new JLabel("Custom"));
        temptable.put(new Integer(0), new JLabel("Full Speed"));
        temptable.put(new Integer(1), new JLabel("Real Time"));
        temptable.put(new Integer(2), new JLabel("Slow"));
        temptable.put(new Integer(3), new JLabel("Slower"));
        temptable.put(new Integer(4), new JLabel("Slowest"));
        temptable.put(new Integer(5), new JLabel("Single Step"));
        thesetup.simTimeSlider = new JSlider(-1, 5, 0);
        thesetup.simTimeSlider.setInverted(true);
        thesetup.simTimeSlider.setMajorTickSpacing(1);
        thesetup.simTimeSlider.setMinorTickSpacing(1);
        thesetup.simTimeSlider.setPaintLabels(true);
        thesetup.simTimeSlider.setPaintTicks(true);
        thesetup.simTimeSlider.setSnapToTicks(true);
        thesetup.simTimeSlider.setLabelTable(temptable);
        thesetup.simTimeSlider.addChangeListener(AvroraGui.instance);
        thesetup.simTimeDelaySpinner = new SpinnerNumberModel();
        thesetup.simTimeDelaySpinner.setValue(new Integer(0));
        thesetup.simTimeDelaySpinner.setMinimum(new Integer(0));
        thesetup.simTimeDelaySpinner.setStepSize(new Integer(1));
        thesetup.simTimeDelaySpinner.addChangeListener(AvroraGui.instance);
        thesetup.simTimeCycleSpinner = new SpinnerNumberModel();
        thesetup.simTimeCycleSpinner.setValue(new Integer(0));
        thesetup.simTimeCycleSpinner.setMinimum(new Integer(0));
        thesetup.simTimeCycleSpinner.setStepSize(new Integer(1));
        thesetup.simTimeCycleSpinner.addChangeListener(AvroraGui.instance);
        Vector<String> iorcvector = new Vector<String>();
        iorcvector.add("cycles");
        iorcvector.add("instructions");
        thesetup.simTimeIorCSelect = new JComboBox(iorcvector);
        thesetup.simTimeIorCSelect.addActionListener(AvroraGui.instance);
        thesetup.simTimeToolbar = new JToolBar("Avrora Simulation Toolbar");
        thesetup.simTimeToolbar.setFloatable(false);
        JButton newbutton = ManageSimTime.makeSimButton("Rewind24", REWIND, "Slow down simulation", "Slower", AvroraGui.instance);
        thesetup.simTimeToolbar.add(newbutton);
        newbutton = ManageSimTime.makeSimButton("Stop24", STOP, "Stop the simulation", "Stop", AvroraGui.instance);
        thesetup.simTimeToolbar.add(newbutton);
        newbutton = ManageSimTime.makeSimButton("Pause24", PAUSE, "Pause the simulation", "Pause", AvroraGui.instance);
        thesetup.simTimeToolbar.add(newbutton);
        newbutton = ManageSimTime.makeSimButton("Play24", RESUME, "Resume a paused/single stepped simulation or start sim", "Play", AvroraGui.instance);
        thesetup.simTimeToolbar.add(newbutton);
        newbutton = ManageSimTime.makeSimButton("FastForward24", FASTFORWARD, "Increase simulation speed", "Faster", AvroraGui.instance);
        thesetup.simTimeToolbar.add(newbutton);
        thesetup.simTimeToolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        thesetup.simTimeEverything = new JPanel();
        thesetup.simTimeEverything.setLayout(new BorderLayout());
        JPanel spinnersubpanel = new JPanel();
        spinnersubpanel.setLayout(new BoxLayout(spinnersubpanel, 0));
        JLabel delayfor = new JLabel(" Delay for ");
        delayfor.setHorizontalAlignment(4);
        spinnersubpanel.add(delayfor);
        spinnersubpanel.add(new JSpinner(thesetup.simTimeDelaySpinner));
        JLabel msevery = new JLabel("  ms every  ");
        msevery.setHorizontalAlignment(0);
        spinnersubpanel.add(msevery);
        spinnersubpanel.add(new JSpinner(thesetup.simTimeCycleSpinner));
        thesetup.simTimeIorCSelect.setPreferredSize(new Dimension(50, 20));
        thesetup.simTimeIorCSelect.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        spinnersubpanel.add(thesetup.simTimeIorCSelect);
        spinnersubpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel tempsubpanel = new JPanel();
        tempsubpanel.setLayout(new BorderLayout());
        tempsubpanel.add((Component)spinnersubpanel, "North");
        tempsubpanel.add((Component)thesetup.simTimeSlider, "South");
        tempsubpanel.setPreferredSize(new Dimension(430, 80));
        thesetup.simTimeEverything.add((Component)thesetup.simTimeToolbar, "West");
        thesetup.simTimeEverything.add((Component)tempsubpanel, "East");
        thesetup.simTimeEverything.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Manage Simulation Time"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return thesetup;
    }

    public boolean checkAndDispatch(ActionEvent e) {
        String cmd = e.getActionCommand();
        Simulation sim = AvroraGui.instance.getSimulation();
        if (STOP.equals(cmd)) {
            sim.stop();
            AvroraGui.instance.stopPaintThread();
            return true;
        }
        if (RESUME.equals(cmd)) {
            if (sim.isPaused()) {
                sim.resume();
            } else if (!(this.simTimeSlider.getValue() == 5 && sim.isRunning() || sim.isRunning())) {
                PrintStream tempstream = new PrintStream(new DebugStream(AvroraGui.instance));
                Terminal.setOutput(tempstream);
                sim.start();
                AvroraGui.instance.startPaintThread();
            }
            return true;
        }
        if (PAUSE.equals(cmd)) {
            sim.pause();
            return true;
        }
        if (REWIND.equals(cmd)) {
            int slideValue = this.simTimeSlider.getValue();
            if (slideValue > -1 && slideValue != numofdefaults) {
                this.simTimeSlider.setValue(slideValue + 1);
            }
            return true;
        }
        if (FASTFORWARD.equals(cmd)) {
            int slideValue = this.simTimeSlider.getValue();
            if (slideValue > 0) {
                this.simTimeSlider.setValue(slideValue - 1);
            }
            return true;
        }
        if (e.getSource() == this.simTimeIorCSelect) {
            this.updateSimChangeSpeedValues();
            return true;
        }
        return false;
    }

    public boolean sliderAndSpinnerDispatch(ChangeEvent e) {
        if (e.getSource() == this.simTimeSlider) {
            this.changeSpinnerBasedOnSlider();
            return true;
        }
        if (e.getSource() == this.simTimeDelaySpinner || e.getSource() == this.simTimeCycleSpinner) {
            boolean isadefault = false;
            int valueOfDelay = (Integer)this.simTimeDelaySpinner.getValue();
            int valueOfCycles = (Integer)this.simTimeCycleSpinner.getValue();
            if (valueOfDelay == 0 && valueOfCycles == 0) {
                this.updateSimChangeSpeedValues();
                return true;
            }
            for (int i = 0; i < numofdefaults; ++i) {
                if (simTimeDelayDefaults[i] != valueOfDelay || simTimeCycleDefaults[i] != valueOfCycles) continue;
                isadefault = true;
                this.simTimeSlider.setValue(i);
            }
            if (!isadefault) {
                this.simTimeSlider.setValue(-1);
            }
            this.updateSimChangeSpeedValues();
            return true;
        }
        return false;
    }

    private void changeSpinnerBasedOnSlider() {
        if (this.simTimeSlider.getValue() >= 0) {
            int sliderValue = this.simTimeSlider.getValue();
            this.simTimeDelaySpinner.setValue(new Integer(simTimeDelayDefaults[sliderValue]));
            this.simTimeCycleSpinner.setValue(new Integer(simTimeCycleDefaults[sliderValue]));
            this.simTimeSlider.setValue(sliderValue);
            this.updateSimChangeSpeedValues();
        } else {
            this.updateSimChangeSpeedValues();
        }
    }

    private void updateSimChangeSpeedValues() {
        int newdelay = (Integer)this.simTimeDelaySpinner.getValue();
        long newinbetweenperiod = ((Integer)this.simTimeCycleSpinner.getValue()).longValue();
        boolean newiorc = !"cycles".equals(this.simTimeIorCSelect.getSelectedItem());
        int slidervalue = this.simTimeSlider.getValue();
        int neweventtype = slidervalue == 0 ? 1 : (slidervalue == 1 ? 0 : (slidervalue == 5 ? 3 : 2));
        if (newdelay != this.olddelay || newinbetweenperiod != this.oldinbetweenperiod || this.oldiorc != newiorc || this.oldeventtype != neweventtype) {
            this.olddelay = newdelay;
            this.oldinbetweenperiod = newinbetweenperiod;
            this.oldiorc = newiorc;
            this.oldeventtype = neweventtype;
        }
    }

    private static JButton makeSimButton(String imageName, String actionCommand, String toolTipText, String altText, AvroraGui papp) {
        String imgLocation = "images/" + imageName + ".gif";
        URL imageURL = AvroraGui.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(papp);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            System.err.println("Resource not found: " + imgLocation);
        }
        return button;
    }
}

