/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.Defaults;
import avrora.core.LoadableProgram;
import avrora.gui.AvroraGui;
import avrora.sim.Simulation;
import avrora.sim.platform.PlatformFactory;
import cck.util.Option;
import cck.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ManageSimInput {
    File currentFileAllInfo;
    JLabel currentFile;
    JButton openFile;
    JFileChooser fc;
    int stageForFileSelection;
    JButton nextButton;
    JButton backButton;
    JDialog setOptionsDialog;
    LinkedList optionsDialogValues;
    JButton optionsDialogUpdate;
    JDialog fileSelectionDialog;
    JButton fileSelectionDialogUpdate;
    SpinnerNumberModel numOfNodesSpinner;

    public static ManageSimInput createManageSimInput() {
        ManageSimInput thesetup = new ManageSimInput();
        thesetup.fc = new JFileChooser();
        return thesetup;
    }

    public void createSetOptionsDialog() {
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.setOptionsDialog = new JDialog((Frame)AvroraGui.instance.masterFrame, "Set Simulator Options");
        JPanel internalPanel = new JPanel();
        internalPanel.setOpaque(true);
        internalPanel.setLayout(new BorderLayout());
        JLabel dialogBanner = new JLabel();
        dialogBanner.setText("Close window to cancel");
        internalPanel.add((Component)dialogBanner, "North");
        JPanel belowBannerPanel = new JPanel();
        belowBannerPanel.setLayout(new GridLayout(AvroraGui.instance.getOptionList().size(), 1));
        this.optionsDialogValues = new LinkedList();
        for (Option currentOption : AvroraGui.instance.getOptionList()) {
            belowBannerPanel.add(this.addOption(currentOption));
        }
        belowBannerPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        internalPanel.add((Component)belowBannerPanel, "Center");
        this.optionsDialogUpdate = new JButton();
        this.optionsDialogUpdate.setText("Update");
        this.optionsDialogUpdate.setToolTipText("Click to update the simulator options");
        this.optionsDialogUpdate.addActionListener(AvroraGui.instance);
        internalPanel.add((Component)this.optionsDialogUpdate, "South");
        internalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setOptionsDialog.setContentPane(internalPanel);
        this.setOptionsDialog.pack();
    }

    public void createFileSelectionDialog() {
        this.stageForFileSelection = 0;
        this.openFile = new JButton();
        this.openFile.setToolTipText("Get a simulation file");
        this.openFile.setMaximumSize(new Dimension(75, 40));
        this.openFile.addActionListener(AvroraGui.instance);
        this.openFile.setText("Select File");
        this.currentFile = new JLabel("<SELECT A FILE>");
        this.currentFile.setHorizontalAlignment(0);
        this.fc = new JFileChooser();
        this.numOfNodesSpinner = new SpinnerNumberModel();
        this.numOfNodesSpinner.setValue(new Integer(1));
        this.numOfNodesSpinner.setMinimum(new Integer(1));
        this.numOfNodesSpinner.setStepSize(new Integer(1));
        this.numOfNodesSpinner.addChangeListener(AvroraGui.instance);
        this.fileSelectionDialogUpdate = new JButton();
        this.fileSelectionDialogUpdate.setText("Update");
        this.fileSelectionDialogUpdate.setToolTipText("Click to add the node(s) to the sim");
        this.fileSelectionDialogUpdate.addActionListener(AvroraGui.instance);
        this.nextButton = new JButton();
        this.nextButton.setText("NEXT>>");
        this.nextButton.addActionListener(AvroraGui.instance);
        this.backButton = new JButton();
        this.backButton.setText("<<BACK");
        this.backButton.addActionListener(AvroraGui.instance);
        this.currentFileAllInfo = null;
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.fileSelectionDialog = new JDialog((Frame)AvroraGui.instance.masterFrame, "Add Nodes to Simulation");
        this.updateFileSelectionDialog();
    }

    private void updateFileSelectionDialog() {
        JPanel internalPanel = new JPanel();
        internalPanel.setOpaque(true);
        internalPanel.setLayout(new BorderLayout());
        JPanel belowBannerPanel = new JPanel();
        JPanel navigationPanel = new JPanel();
        if (this.stageForFileSelection == 0) {
            JLabel dialogBanner = new JLabel();
            dialogBanner.setText("Step 1: Specify File");
            internalPanel.add((Component)dialogBanner, "North");
            belowBannerPanel.setLayout(new BorderLayout());
            JPanel tempPanel = new JPanel();
            tempPanel.add(this.openFile);
            belowBannerPanel.add((Component)tempPanel, "North");
            belowBannerPanel.add((Component)this.currentFile, "South");
            navigationPanel.setLayout(new BorderLayout());
            navigationPanel.add((Component)this.nextButton, "East");
        } else if (this.stageForFileSelection == 1) {
            JLabel dialogBanner = new JLabel();
            dialogBanner.setText("Step 2: Specify Number of Nodes");
            internalPanel.add((Component)dialogBanner, "North");
            belowBannerPanel.setLayout(new BorderLayout());
            belowBannerPanel.add((Component)this.currentFile, "North");
            JLabel userInstr = new JLabel("Select the number of duplicate nodes based upon selected file");
            this.currentFile.setHorizontalAlignment(0);
            belowBannerPanel.add((Component)userInstr, "Center");
            JSpinner tempSpin = new JSpinner(this.numOfNodesSpinner);
            JPanel tempPanel2 = new JPanel();
            tempPanel2.add(tempSpin);
            belowBannerPanel.add((Component)tempPanel2, "South");
            navigationPanel.setLayout(new BorderLayout());
            JPanel tempPanel = new JPanel();
            tempPanel.setLayout(new FlowLayout());
            tempPanel.add(this.backButton);
            tempPanel.add(this.fileSelectionDialogUpdate);
            navigationPanel.add((Component)tempPanel, "East");
        }
        internalPanel.add((Component)belowBannerPanel, "Center");
        internalPanel.add((Component)navigationPanel, "South");
        internalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        internalPanel.setPreferredSize(new Dimension(400, 150));
        this.fileSelectionDialog.setContentPane(internalPanel);
        this.fileSelectionDialog.pack();
        this.fileSelectionDialog.validate();
    }

    private Component addOption(Option theOption) {
        if (theOption instanceof Option.Bool) {
            JCheckBox theCheckBox = new JCheckBox(theOption.getName());
            theCheckBox.setSelected(((Option.Bool)theOption).get());
            theCheckBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.optionsDialogValues.add(theCheckBox);
            return theCheckBox;
        }
        if (theOption instanceof Option.Double) {
            JPanel outerShell = new JPanel();
            outerShell.setLayout(new BorderLayout());
            SpinnerNumberModel theSpinner = new SpinnerNumberModel();
            theSpinner.setValue(new Double(((Option.Double)theOption).get()));
            JLabel spinnerTitle = new JLabel();
            spinnerTitle.setText(theOption.getName() + " ");
            outerShell.add((Component)spinnerTitle, "West");
            outerShell.add((Component)new JSpinner(theSpinner), "Center");
            outerShell.setPreferredSize(new Dimension(150, 30));
            outerShell.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.optionsDialogValues.add(theSpinner);
            return outerShell;
        }
        if (theOption instanceof Option.Str) {
            JPanel outerShell = new JPanel();
            outerShell.setLayout(new BorderLayout());
            JTextField theText = new JTextField();
            theText.setText(((Option.Str)theOption).get());
            JLabel textBoxTitle = new JLabel();
            textBoxTitle.setText(theOption.getName() + " ");
            outerShell.add((Component)textBoxTitle, "West");
            outerShell.add((Component)theText, "Center");
            outerShell.setPreferredSize(new Dimension(150, 30));
            outerShell.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.optionsDialogValues.add(theText);
            return outerShell;
        }
        return null;
    }

    private void updateOption(Option theOption, Object theComponent) {
        if (theOption instanceof Option.Bool) {
            theOption.set(Boolean.toString(((JCheckBox)theComponent).isSelected()));
        } else if (theOption instanceof Option.Double) {
            SpinnerNumberModel tempSpinnerModel = (SpinnerNumberModel)theComponent;
            theOption.set(Double.toString(tempSpinnerModel.getNumber().doubleValue()));
        } else if (theOption instanceof Option.Str) {
            JTextField theText = (JTextField)theComponent;
            theOption.set(theText.getText());
        }
    }

    public boolean checkAndDispatch(ActionEvent e) {
        if (e.getSource() == this.optionsDialogUpdate) {
            return this.optionsUpdate();
        }
        if (e.getSource() == this.openFile) {
            return this.openFileUpdate();
        }
        if (e.getSource() == this.fileSelectionDialogUpdate) {
            return this.fileSelectionUpdate();
        }
        if (e.getSource() == this.nextButton) {
            return this.nextButtonUpdate();
        }
        if (e.getSource() == this.backButton) {
            return this.backButtonUpdate();
        }
        return false;
    }

    private boolean openFileUpdate() {
        int returnVal = this.fc.showOpenDialog(null);
        if (returnVal == 0) {
            this.currentFileAllInfo = this.fc.getSelectedFile();
        }
        return true;
    }

    private boolean setOptionsUpdate() {
        this.createSetOptionsDialog();
        this.setOptionsDialog.setLocationRelativeTo(null);
        this.setOptionsDialog.setVisible(true);
        return true;
    }

    private boolean optionsUpdate() {
        Iterator optionIter = AvroraGui.instance.getOptionList().iterator();
        ListIterator componentIter = this.optionsDialogValues.listIterator(0);
        while (optionIter.hasNext()) {
            Option currentOption = (Option)optionIter.next();
            this.updateOption(currentOption, componentIter.next());
        }
        this.setOptionsDialog.setVisible(false);
        return true;
    }

    private boolean backButtonUpdate() {
        this.stageForFileSelection = 0;
        this.updateFileSelectionDialog();
        return true;
    }

    private boolean nextButtonUpdate() {
        if (this.currentFileAllInfo == null) {
            return true;
        }
        this.stageForFileSelection = 1;
        this.updateFileSelectionDialog();
        return true;
    }

    private boolean fileSelectionUpdate() {
        if (this.currentFileAllInfo == null) {
            return true;
        }
        LoadableProgram pp = new LoadableProgram(this.currentFileAllInfo);
        try {
            pp.load();
        }
        catch (Exception e) {
            throw Util.failure(e.toString());
        }
        PlatformFactory pf = Defaults.getPlatform("mica2");
        Simulation s = AvroraGui.instance.getSimulation();
        int max = (Integer)this.numOfNodesSpinner.getValue();
        for (int i = 0; i < max; ++i) {
            Simulation.Node n = s.createNode(pf, pp);
        }
        AvroraGui.instance.topologyBox.createSimpleAirTable();
        this.fileSelectionDialog.setVisible(false);
        return true;
    }
}

