/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.AvroraGui;
import avrora.gui.GUIDefaults;
import avrora.sim.Simulation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ManageMonitors {
    JDialog chooseMonitorsDialog;
    JButton monitorsDialogUpdate;
    LinkedList checkBoxContainer;

    public static ManageMonitors createManageMonitors() {
        ManageMonitors thesetup = new ManageMonitors();
        return thesetup;
    }

    public void createMonitorsDialog() {
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.checkBoxContainer = new LinkedList();
        this.chooseMonitorsDialog = new JDialog((Frame)AvroraGui.instance.masterFrame, "Add Monitors to Selected Nodes");
        JPanel internalPanel = new JPanel();
        internalPanel.setOpaque(true);
        internalPanel.setLayout(new BorderLayout());
        JLabel dialogBanner = new JLabel();
        dialogBanner.setText("Check the monitors you want to add");
        internalPanel.add((Component)dialogBanner, "North");
        JPanel belowBannerPanel = new JPanel();
        this.addMonitorsFromClassMap(belowBannerPanel);
        belowBannerPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        internalPanel.add((Component)belowBannerPanel, "Center");
        this.monitorsDialogUpdate = new JButton();
        this.monitorsDialogUpdate.setText("Update");
        this.monitorsDialogUpdate.setToolTipText("Click to update the monitors list");
        this.monitorsDialogUpdate.addActionListener(AvroraGui.instance);
        internalPanel.add((Component)this.monitorsDialogUpdate, "South");
        internalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.chooseMonitorsDialog.setContentPane(internalPanel);
        this.chooseMonitorsDialog.pack();
    }

    private void addMonitorsFromClassMap(JPanel belowBannerPanel) {
        List monitorList = AvroraGui.instance.getMonitorList();
        Iterator monitorIter = monitorList.iterator();
        belowBannerPanel.setLayout(new GridLayout(monitorList.size(), 1));
        while (monitorIter.hasNext()) {
            String currentMonitor = (String)monitorIter.next();
            JCheckBox theCheckBox = new JCheckBox(currentMonitor);
            theCheckBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            belowBannerPanel.add(theCheckBox);
            this.checkBoxContainer.add(theCheckBox);
        }
    }

    public boolean checkAndDispatch(ActionEvent e) {
        if (e.getSource() == this.monitorsDialogUpdate) {
            Vector<String> toMONITORS = new Vector<String>();
            for (JCheckBox currentBox : this.checkBoxContainer) {
                if (!currentBox.isSelected()) continue;
                toMONITORS.add(currentBox.getText());
            }
            LinkedList nodes = this.getNodeList();
            for (int j = 0; j < toMONITORS.size(); ++j) {
                String currentMonitor = (String)toMONITORS.elementAt(j);
                Simulation.Monitor mf = this.getMonitorFactory(currentMonitor);
                mf.attach(AvroraGui.instance.getSimulation(), nodes);
            }
            this.chooseMonitorsDialog.setVisible(false);
            AvroraGui.instance.topologyBox.createSimpleAirTable();
            return true;
        }
        return false;
    }

    private Simulation.Monitor getMonitorFactory(String n) {
        return GUIDefaults.getMonitor(n);
    }

    private LinkedList getNodeList() {
        Simulation sim = AvroraGui.instance.getSimulation();
        LinkedList<Simulation.Node> nodes = new LinkedList<Simulation.Node>();
        int[] selectedRows = AvroraGui.instance.topologyBox.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object v = AvroraGui.instance.topologyBox.theModel.getValueAt(selectedRows[i], 0);
            int nid = (Integer)v;
            Simulation.Node node = sim.getNode(nid);
            nodes.add(node);
        }
        return nodes;
    }
}

