/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.gui.TimeScale;
import cck.stat.Sequence;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphNumbers
extends JPanel
implements ChangeListener,
AdjustmentListener {
    private Sequence publicNumbers;
    private Sequence privateNumbers;
    private final JPanel parentPanel;
    private static final int valueMargin = 5;
    public JScrollBar horzBar;
    TimeScale timeScale;
    public SpinnerNumberModel stepsizeVisual;
    public int maxvalue;
    public SpinnerNumberModel maxvalueVisual;
    private Color lineColor;
    private Color backColor;
    private Color cursorColor;
    private int minvalue;
    protected static final int VALUE_SCALE_WIDTH = 15;
    protected static final int MIN__VALUE__TICK = 3;

    public GraphNumbers(JPanel parent) {
        this.parentPanel = parent;
        this.publicNumbers = new Sequence();
        this.privateNumbers = new Sequence();
        this.lineColor = Color.GREEN;
        this.backColor = Color.BLACK;
        this.cursorColor = Color.CYAN;
        this.minvalue = 0;
        this.maxvalue = 0;
        this.timeScale = new TimeScale();
    }

    public JPanel chalkboardAndBar() {
        JPanel temppanel = new JPanel();
        temppanel.setLayout(new BorderLayout());
        this.horzBar = new JScrollBar(0);
        this.horzBar.addAdjustmentListener(this);
        this.updateHorzBar();
        JPanel innertemppanel = new JPanel();
        innertemppanel.setLayout(new OverlayLayout(innertemppanel));
        innertemppanel.add(this);
        temppanel.add((Component)innertemppanel, "North");
        Dimension newDimen = this.parentPanel.getSize();
        newDimen.height -= this.horzBar.getPreferredSize().height;
        this.setPreferredSize(newDimen);
        temppanel.add((Component)this, "North");
        temppanel.add((Component)this.horzBar, "South");
        return temppanel;
    }

    public synchronized void updateHorzBar() {
        int width = this.getSize().width;
        long maxtime = this.privateNumbers.size();
        int newExtent = this.timeScale.getExtent(width, maxtime);
        int size = this.timeScale.getScrollBarSize(maxtime);
        if (size < newExtent) {
            this.horzBar.setValues(0, 0, 0, 0);
            return;
        }
        int newValue = this.horzBar.getValue();
        if (newValue + this.horzBar.getModel().getExtent() == this.horzBar.getMaximum()) {
            newValue = size - newExtent;
        }
        this.horzBar.setValues(newValue, newExtent, 0, size);
    }

    public JPanel getZoomLevelOption() {
        if (this.stepsizeVisual == null) {
            this.makeZoomLevelOption();
        }
        JPanel returnthis = new JPanel();
        returnthis.setLayout(new BorderLayout());
        JLabel stepSizeLabel = new JLabel("Zoom Level: ");
        returnthis.add((Component)stepSizeLabel, "West");
        JSpinner spinit = new JSpinner(this.stepsizeVisual);
        spinit.setPreferredSize(new Dimension(80, 20));
        returnthis.add((Component)spinit, "East");
        returnthis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return returnthis;
    }

    private void makeZoomLevelOption() {
        this.stepsizeVisual = new SpinnerNumberModel();
        this.stepsizeVisual.setValue(new Integer(this.timeScale.getZoom() + 1));
        this.stepsizeVisual.setMinimum(new Integer(1));
        this.stepsizeVisual.setMaximum(new Integer(this.timeScale.getMaxZoom() + 1));
        this.stepsizeVisual.addChangeListener(this);
    }

    public JPanel visualSetMaxValue() {
        if (this.maxvalueVisual == null) {
            this.createmaxvalueVisual();
        }
        JPanel returnthis = new JPanel();
        returnthis.setLayout(new BorderLayout());
        JLabel maxvalueLabel = new JLabel("Y-Axis max value");
        returnthis.add((Component)maxvalueLabel, "West");
        JSpinner spinit = new JSpinner(this.maxvalueVisual);
        spinit.setPreferredSize(new Dimension(80, 20));
        returnthis.add((Component)spinit, "East");
        returnthis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return returnthis;
    }

    private void createmaxvalueVisual() {
        this.maxvalueVisual = new SpinnerNumberModel();
        this.maxvalueVisual.setValue(new Integer(this.maxvalue));
        this.stepsizeVisual.setMinimum(new Integer(1));
        this.maxvalueVisual.addChangeListener(this);
    }

    public JPanel getOptionsPanel() {
        JPanel allOptions = new JPanel();
        allOptions.setLayout(new GridLayout(10, 1));
        allOptions.add(this.getZoomLevelOption());
        allOptions.add(this.visualSetMaxValue());
        allOptions.add(new JPanel());
        return allOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordNumber(int number) {
        GraphNumbers graphNumbers = this;
        synchronized (graphNumbers) {
            this.publicNumbers.add(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalUpdate() {
        Sequence newNumbers = this.publicNumbers;
        GraphNumbers graphNumbers = this;
        synchronized (graphNumbers) {
            if (newNumbers.size() == 0) {
                return false;
            }
            this.publicNumbers = new Sequence();
        }
        this.privateNumbers.addAll(newNumbers);
        int max = this.privateNumbers.max();
        if (max > this.maxvalue) {
            this.maxvalue = max;
        }
        this.updateHorzBar();
        return true;
    }

    public void paint(Graphics g) {
        Dimension panelDimen = this.getSize();
        g.setColor(this.backColor);
        g.fillRect(0, 0, panelDimen.width, panelDimen.height);
        this.timeScale.setPosition(this.horzBar.getValue());
        this.timeScale.drawScale(panelDimen, g);
        long startTime = this.timeScale.getStartTime();
        this.drawValueScale(panelDimen, g);
        int height = panelDimen.height - this.timeScale.height;
        int maxY = height - 5;
        double scalingfactor = (double)(maxY - 5) / (double)(this.maxvalue - this.minvalue);
        int eofpx = 0;
        int eofpy = 0;
        boolean firstone = true;
        Sequence.Iterator mi = this.privateNumbers.iterator((int)startTime);
        g.setColor(this.lineColor);
        long i = startTime;
        while (mi.hasNext()) {
            double currentValue = mi.next();
            if (firstone) {
                eofpy = maxY - (int)(currentValue * scalingfactor);
                eofpx = this.timeScale.getX(i);
                g.drawLine(0, eofpy, eofpx, eofpy);
                firstone = false;
            } else {
                int npy = maxY - (int)(currentValue * scalingfactor);
                int npx = this.timeScale.getX(i);
                g.drawLine(eofpx, eofpy, eofpx, npy);
                g.drawLine(eofpx, npy, npx, npy);
                eofpy = npy;
                eofpx = npx;
            }
            if (!mi.hasNext()) {
                g.setColor(Color.DARK_GRAY);
                g.fillRect(eofpx, 0, panelDimen.width, height);
                g.setColor(this.cursorColor);
                g.drawLine(eofpx, 0, eofpx, height);
            }
            if (eofpx > panelDimen.width) break;
            ++i;
        }
    }

    private void drawValueScale(Dimension dim, Graphics g) {
        int y;
        int vtick;
        int height = dim.height - this.timeScale.height;
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, 15, height);
        int startY = height - 5;
        double scale = (double)(startY - 5) / (double)(this.maxvalue - this.minvalue);
        for (vtick = 1; vtick < 1000000000 && !(scale * (double)vtick > 3.0); vtick *= 10) {
        }
        int majorTick = vtick * 10;
        int value = this.minvalue / majorTick * majorTick;
        if (this.minvalue < 0) {
            value -= majorTick;
        }
        g.setColor(Color.DARK_GRAY);
        g.setFont(g.getFont().deriveFont(9.0f));
        while ((y = (int)((double)startY - (double)(value - this.minvalue) * scale)) > 0) {
            int modulus = value % majorTick;
            if (modulus == 0) {
                g.drawLine(0, y, dim.width, y);
                g.setColor(Color.RED);
                g.drawString(Integer.toString(value), 18, y + 3);
                g.setColor(Color.DARK_GRAY);
            } else if (modulus == 5) {
                g.drawLine(5, y, 14, y);
            } else {
                g.drawLine(8, y, 14, y);
            }
            value += vtick;
        }
        g.setColor(Color.WHITE);
        g.drawLine(15, 0, 15, height);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.stepsizeVisual) {
            this.adjustZoom();
            this.repaint();
        } else if (e.getSource() == this.maxvalueVisual) {
            this.maxvalue = (Integer)this.maxvalueVisual.getValue();
            this.repaint();
        }
    }

    private void adjustZoom() {
        int zoomlevel = (Integer)this.stepsizeVisual.getValue() - 1;
        this.timeScale.setZoom(zoomlevel);
        this.horzBar.setValue(this.timeScale.getPosition());
        this.updateHorzBar();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }
}

