/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import cck.text.Terminal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphEvents
extends JPanel
implements ChangeListener,
AdjustmentListener {
    private MyVector[] publicNumbers;
    private MyVector[] privateNumbers;
    private static final int VECSIZE = 5;
    private JPanel parentPanel;
    private Object vSync = new Object();
    public JScrollBar horzBar;
    public double stepsize;
    public SpinnerNumberModel stepsizeVisual;
    private Color backColor;
    private Color tickColor;

    public GraphEvents(int pminvalue, int pmaxvalue, double pstepsize) {
        this.publicNumbers = new MyVector[5];
        this.privateNumbers = new MyVector[5];
        for (int i = 0; i < 5; ++i) {
            this.publicNumbers[i] = new MyVector();
            this.privateNumbers[i] = new MyVector();
        }
        Color lineColor = Color.GREEN;
        this.backColor = Color.BLACK;
        this.tickColor = Color.LIGHT_GRAY;
        int xAxisMajorTickMark = 20;
        int minvalue = pminvalue;
        int maxvalue = pmaxvalue;
        this.stepsize = pstepsize;
    }

    public JPanel chalkboardAndBar() {
        JPanel temppanel = new JPanel();
        temppanel.setLayout(new BorderLayout());
        this.horzBar = new JScrollBar(0);
        this.horzBar.addAdjustmentListener(this);
        this.updateHorzBar();
        JPanel innertemppanel = new JPanel();
        innertemppanel.setLayout(new OverlayLayout(innertemppanel));
        innertemppanel.add(this);
        temppanel.add((Component)innertemppanel, "North");
        Dimension newDimen = this.parentPanel.getSize();
        newDimen.height -= this.horzBar.getPreferredSize().height;
        this.setPreferredSize(newDimen);
        temppanel.add((Component)this, "North");
        temppanel.add((Component)this.horzBar, "South");
        return temppanel;
    }

    public synchronized void updateHorzBar() {
        int newExtent = (int)((double)this.getSize().width / this.stepsize);
        int maxvalue = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.privateNumbers[i].size() == 0 || maxvalue >= this.privateNumbers[i].getLast()) continue;
            maxvalue = this.privateNumbers[i].getLast();
        }
        if (maxvalue < newExtent) {
            this.horzBar.setValues(0, 0, 0, 0);
            return;
        }
        int newValue = this.horzBar.getValue();
        if (this.horzBar.getValue() + this.horzBar.getModel().getExtent() == this.horzBar.getMaximum()) {
            newValue = maxvalue - newExtent;
        }
        this.horzBar.setValues(newValue, newExtent, 0, maxvalue);
    }

    public int getHorzBarValue() {
        return this.horzBar.getValue();
    }

    public double getStepSize() {
        return this.stepsize;
    }

    public void setStepSize(double pstepsize) {
        this.stepsize = pstepsize;
    }

    public JPanel visualSetStepSize() {
        if (this.stepsizeVisual == null) {
            this.createstepsizeVisual();
        }
        JPanel returnthis = new JPanel();
        returnthis.setLayout(new BorderLayout());
        JLabel stepSizeLabel = new JLabel("X-Axis Step Size: ");
        returnthis.add((Component)stepSizeLabel, "West");
        JSpinner spinit = new JSpinner(this.stepsizeVisual);
        spinit.setPreferredSize(new Dimension(80, 20));
        returnthis.add((Component)spinit, "East");
        returnthis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return returnthis;
    }

    private void createstepsizeVisual() {
        this.stepsizeVisual = new SpinnerNumberModel();
        this.stepsizeVisual.setValue(new Double(this.stepsize));
        this.stepsizeVisual.setMinimum(new Double(0.0));
        this.stepsizeVisual.addChangeListener(this);
    }

    public JPanel getOptionsPanel() {
        JPanel allOptions = new JPanel();
        allOptions.setLayout(new GridLayout(10, 1));
        allOptions.add(this.visualSetStepSize());
        allOptions.add(new JPanel());
        return allOptions;
    }

    public void setParentPanel(JPanel pparentPanel) {
        this.parentPanel = pparentPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToVector(int vecnum, int anAddress) {
        Object object = this.vSync;
        synchronized (object) {
            this.publicNumbers[vecnum].add(anAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalUpdate() {
        boolean somethingchanged = false;
        Object object = this.vSync;
        synchronized (object) {
            for (int i = 0; i < 5; ++i) {
                if (this.publicNumbers[i].size() == 0) continue;
                somethingchanged = true;
                try {
                    this.privateNumbers[i].addAll(this.publicNumbers[i]);
                }
                catch (OutOfMemoryError e) {
                    Terminal.println("RAN OUT OF HEAP SPACE FOR MONITOR");
                    Terminal.println("SIZE OF MONITORS VECTOR AT THE TIME: " + Integer.toString(this.privateNumbers[i].size()));
                }
                this.publicNumbers[i].removeAllElements();
            }
        }
        this.updateHorzBar();
        return somethingchanged;
    }

    public void paint(Graphics g) {
        Dimension panelDimen = this.getSize();
        g.setColor(this.backColor);
        g.fillRect(0, 0, panelDimen.width, panelDimen.height);
        int startingvalue = this.getHorzBarValue();
        for (int i = 0; i < panelDimen.width; i += 100) {
            g.setColor(this.tickColor);
            g.drawLine(i, 0, i, panelDimen.height);
            g.drawString(Integer.toString((int)((double)i * this.stepsize + (double)startingvalue)) + "ms", i, panelDimen.height - 10);
        }
        g.setColor(Color.BLUE);
        g.drawString("Transmit", 0, panelDimen.height / 4 - 10);
        g.setColor(Color.MAGENTA);
        g.drawString("Receive", 0, panelDimen.height / 2 - 10);
        g.setColor(this.tickColor);
        g.drawString("LEDs", 0, 3 * panelDimen.height / 4 - 10);
        for (int j = 0; j < 5; ++j) {
            int currentYPoint;
            int endingvalue = this.privateNumbers[j].size() == 0 ? 0 : ((double)((int)((double)panelDimen.width)) / this.stepsize < (double)this.privateNumbers[j].get(this.privateNumbers[j].size() - 1) ? startingvalue + (int)((double)panelDimen.width / this.stepsize) : this.privateNumbers[j].get(this.privateNumbers[j].size() - 1));
            if (j == 0) {
                currentYPoint = panelDimen.height / 4;
                g.setColor(Color.BLUE);
            } else if (j == 1) {
                currentYPoint = panelDimen.height / 2;
                g.setColor(Color.MAGENTA);
            } else if (j == 2) {
                currentYPoint = 3 * panelDimen.height / 4 - 20;
                g.setColor(Color.RED);
            } else if (j == 3) {
                currentYPoint = 3 * panelDimen.height / 4;
                g.setColor(Color.YELLOW);
            } else {
                currentYPoint = 3 * panelDimen.height / 4 + 20;
                g.setColor(Color.GREEN);
            }
            if (this.privateNumbers[j].size() == 0 || this.privateNumbers[j].get(this.privateNumbers[j].size() - 1) <= startingvalue) continue;
            int i = 0;
            while (this.privateNumbers[j].get(i) < startingvalue) {
                ++i;
            }
            boolean startColorOn = false;
            if (i % 2 == 1) {
                startColorOn = true;
            }
            while (this.privateNumbers[j].get(i) <= endingvalue || startColorOn) {
                if (j == 2 || j == 3 || j == 4) {
                    int currentXPoint2;
                    int currentXPoint1;
                    if (startColorOn) {
                        currentXPoint1 = 0;
                        startColorOn = false;
                    } else {
                        currentXPoint1 = (int)((double)(this.privateNumbers[j].get(i) - startingvalue) * this.stepsize);
                        ++i;
                    }
                    if (i < this.privateNumbers[j].size()) {
                        currentXPoint2 = (int)((double)(this.privateNumbers[j].get(i) - startingvalue) * this.stepsize);
                        ++i;
                    } else {
                        currentXPoint2 = panelDimen.width;
                    }
                    g.fillOval(currentXPoint1 - 2, currentYPoint - 2, 4, 4);
                    g.fillOval(currentXPoint2 - 2, currentYPoint - 2, 4, 4);
                    g.drawLine(currentXPoint1, currentYPoint, currentXPoint2, currentYPoint);
                } else {
                    int currentXPoint = (int)((double)(this.privateNumbers[j].get(i) - startingvalue) * this.stepsize);
                    ++i;
                    g.fillOval(currentXPoint - 2, currentYPoint - 2, 4, 4);
                }
                if (i < this.privateNumbers[j].size()) continue;
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.stepsizeVisual) {
            this.stepsize = (Double)this.stepsizeVisual.getValue();
            this.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public class MyVector {
        int[] vec = new int[100];
        int current = 0;

        public void add(int a) {
            if (this.current == this.vec.length) {
                int[] vec2 = new int[this.vec.length * 2];
                System.arraycopy(this.vec, 0, vec2, 0, this.vec.length);
                this.vec = vec2;
            }
            this.vec[this.current] = a;
            ++this.current;
        }

        public int get(int i) {
            if (i < this.current && i >= 0) {
                return this.vec[i];
            }
            return 0;
        }

        public void addAll(MyVector a) {
            for (int i = 0; i < a.size(); ++i) {
                this.add(a.get(i));
            }
        }

        public int size() {
            return this.current;
        }

        public int getLast() {
            if (this.current > 0) {
                return this.get(this.current - 1);
            }
            return 0;
        }

        public void removeAllElements() {
            this.vec = new int[100];
            this.current = 0;
        }
    }
}

