/*
 * Decompiled with CFR 0.152.
 */
package avrora.gui;

import avrora.Version;
import avrora.gui.GUIDefaults;
import avrora.gui.ManageSimTime;
import avrora.gui.ManageTopology;
import avrora.gui.MonitorPanel;
import avrora.gui.SimMenuBar;
import avrora.gui.VisualMonitor;
import avrora.gui.VisualRadioMonitor;
import avrora.sim.Simulation;
import avrora.sim.types.SensorSimulation;
import cck.util.Options;
import cck.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AvroraGui
implements ActionListener,
ChangeListener {
    public static AvroraGui instance;
    public String[] args;
    public JFrame masterFrame;
    public SimMenuBar topMenu;
    public ManageSimTime simTimeBox;
    public ManageTopology topologyBox;
    public JTabbedPane monitorResults;
    private JLabel versioningInfo;
    private JPanel monitorOptions;
    private JTextArea debugOutput;
    private JPanel debugPanel;
    private HashMap monitorTabMap;
    private MonitorPanel currentMonitorDisplayed;
    private static final String AVRORA_VERSION;
    private static final String AVRORA_GUI_VERSION = "Avrora Gui v.0.3.2";
    private static final int PAINT_THREAD_SLEEP_TIME = 200;
    PaintThread newPaintThread;
    private SensorSimulation simulation;
    static final String LOOKANDFEEL;

    public static void init(Options opt, String[] args) {
        new AvroraGui(opt, args);
    }

    private AvroraGui(Options opts, String[] a) {
        instance = this;
        AvroraGui.initLookAndFeel();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.monitorTabMap = new HashMap();
        this.masterFrame = new JFrame("Avrora GUI");
        this.masterFrame.setDefaultCloseOperation(3);
        this.simulation = new SensorSimulation();
        this.args = a;
        this.simTimeBox = ManageSimTime.createManageSimTime();
        this.topMenu = SimMenuBar.createSimMenuBar();
        this.masterFrame.setJMenuBar(this.topMenu.menuBar);
        JPanel toolAndFile = new JPanel();
        toolAndFile.setLayout(new BorderLayout());
        toolAndFile.add((Component)this.simTimeBox.simTimeEverything, "West");
        this.masterFrame.getContentPane().add((Component)toolAndFile, "North");
        this.createDebugOutput();
        this.createMonitorResults();
        this.masterFrame.getContentPane().add((Component)this.monitorResults, "Center");
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new GridLayout(2, 1));
        this.topologyBox = ManageTopology.createManageTopology();
        westPanel.add(this.topologyBox.topologyVisual);
        this.monitorOptions = new JPanel();
        this.monitorOptions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Monitor Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        westPanel.add(this.monitorOptions);
        this.masterFrame.getContentPane().add((Component)westPanel, "West");
        this.createVersioningInfo();
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel blankPanel = new JPanel();
        southPanel.add((Component)blankPanel, "Center");
        southPanel.add((Component)this.versioningInfo, "South");
        this.masterFrame.getContentPane().add((Component)southPanel, "South");
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public List getMonitorList() {
        return GUIDefaults.getMonitorList();
    }

    public List getOptionList() {
        return GUIDefaults.getOptionList();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.simTimeBox.checkAndDispatch(e) || this.topMenu.checkAndDispatch(e)) {
            // empty if block
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.simTimeBox.sliderAndSpinnerDispatch(e) && e.getSource() == this.monitorResults) {
            JPanel monitorPanel = (JPanel)this.monitorResults.getComponentAt(this.monitorResults.getSelectedIndex());
            JPanel thePanel = this.getOptionsFromMonitor(monitorPanel);
            String titleOfPanel = this.getMonitorName(monitorPanel);
            this.currentMonitorDisplayed = this.getMonitorPanel(monitorPanel);
            if (thePanel == null) {
                thePanel = new JPanel(false);
                titleOfPanel = "Monitor";
            }
            this.monitorOptions.removeAll();
            this.monitorOptions.setLayout(new GridLayout(1, 1));
            this.monitorOptions.add(thePanel);
            this.monitorOptions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(titleOfPanel + " Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.monitorOptions.validate();
        }
    }

    private MonitorPanel getMonitorPanel(JPanel monitorPanel) {
        MonitorPanel p = (MonitorPanel)this.monitorTabMap.get(monitorPanel);
        if (p == null) {
            return null;
        }
        return p;
    }

    private String getMonitorName(JPanel monitorPanel) {
        MonitorPanel p = (MonitorPanel)this.monitorTabMap.get(monitorPanel);
        if (p == null) {
            return null;
        }
        return p.name;
    }

    private JPanel getOptionsFromMonitor(JPanel monitorPanel) {
        MonitorPanel p = (MonitorPanel)this.monitorTabMap.get(monitorPanel);
        if (p == null) {
            return null;
        }
        return p.optionsPanel;
    }

    private void createDebugOutput() {
        this.debugOutput = new JTextArea("Console initialized. Textual output from Avrora will be displayed here.\n");
        this.debugOutput.setFont(new Font("Courier", 0, 14));
        this.debugOutput.setBackground(Color.BLACK);
        this.debugOutput.setForeground(Color.WHITE);
        this.debugOutput.setLineWrap(true);
        this.debugOutput.setWrapStyleWord(true);
        this.debugOutput.setEditable(false);
        JScrollPane debugScrollPane = new JScrollPane(this.debugOutput);
        debugScrollPane.setVerticalScrollBarPolicy(22);
        this.debugPanel = new JPanel();
        this.debugPanel.setLayout(new OverlayLayout(this.debugPanel));
        this.debugPanel.add(debugScrollPane);
    }

    private void createMonitorResults() {
        this.monitorResults = new JTabbedPane(3);
        this.debugPanel.setPreferredSize(new Dimension(this.monitorResults.getSize()));
        this.monitorResults.addTab("Debug Information", this.debugPanel);
        this.monitorResults.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View Monitors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.monitorResults.addChangeListener(this);
    }

    private void createVersioningInfo() {
        this.versioningInfo = new JLabel(AVRORA_VERSION + "; " + AVRORA_GUI_VERSION, 4);
    }

    public void debugAppend(String b) {
        this.debugOutput.append(b);
    }

    public void showGui() {
        this.masterFrame.pack();
        this.masterFrame.setExtendedState(6);
        this.masterFrame.setVisible(true);
    }

    private static void initLookAndFeel() {
        if (LOOKANDFEEL != null) {
            String lookAndFeel;
            if ("Metal".equals(LOOKANDFEEL)) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if ("System".equals(LOOKANDFEEL)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if ("Motif".equals(LOOKANDFEEL)) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if ("GTK+".equals(LOOKANDFEEL)) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:" + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imageURL = AvroraGui.class.getResource(path);
        if (imageURL == null) {
            throw Util.failure("Resource not found: " + path);
        }
        return new ImageIcon(imageURL);
    }

    public void startPaintThread() {
        this.newPaintThread = new PaintThread();
        this.newPaintThread.start();
    }

    public void stopPaintThread() {
    }

    public MonitorPanel createMonitorPanel(String name) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel("This panel will update once the simulator is run.");
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        this.monitorResults.addTab(name, panel);
        JPanel optionsPanel = new JPanel(false);
        JLabel optionsFiller = new JLabel("Options for the monitor can be set here. ");
        optionsPanel.setLayout(new GridLayout(1, 1));
        optionsPanel.add(optionsFiller);
        MonitorPanel p = new MonitorPanel(name, panel, optionsPanel);
        this.monitorTabMap.put(panel, p);
        return p;
    }

    public void removeMonitorPanel(MonitorPanel p) {
        int i = this.monitorResults.indexOfTab(p.name);
        this.monitorResults.removeTabAt(i);
        this.monitorTabMap.remove(p.displayPanel);
    }

    static {
        AVRORA_VERSION = "Avrora " + Version.TAG;
        LOOKANDFEEL = null;
    }

    public class PaintThread
    extends Thread {
        public void run() {
            try {
                while (AvroraGui.this.getSimulation().isRunning()) {
                    if (AvroraGui.this.monitorResults.getSelectedIndex() != 0) {
                        if (AvroraGui.this.currentMonitorDisplayed == null) {
                            Vector allMons = VisualRadioMonitor.allCurrentMonitors;
                            Enumeration e = allMons.elements();
                            while (e.hasMoreElements()) {
                                VisualMonitor tempMon = (VisualMonitor)e.nextElement();
                                tempMon.updateDataAndPaint();
                            }
                        } else {
                            AvroraGui.this.currentMonitorDisplayed.paint();
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

