/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.core.Program;
import cck.text.StringUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class SourceMapping {
    protected final Program program;
    protected final HashMap labels;
    protected final HashMap reverseMap;
    public static Comparator LOCATION_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Location l1 = (Location)o1;
            Location l2 = (Location)o2;
            if (l1.lma_addr == l2.lma_addr) {
                if (l1.name == null) {
                    return 1;
                }
                if (l2.name == null) {
                    return -1;
                }
                return l1.name.compareTo(l2.name);
            }
            return l1.lma_addr - l2.lma_addr;
        }
    };

    public String getName(int address) {
        String s = (String)this.reverseMap.get(new Integer(address));
        return s == null ? StringUtil.addrToString(address) : s;
    }

    public SourceMapping(Program p) {
        this.program = p;
        this.labels = new HashMap();
        this.reverseMap = new HashMap();
    }

    public Program getProgram() {
        return this.program;
    }

    public Location getLocation(String name) {
        if (StringUtil.isHex(name)) {
            int val = StringUtil.evaluateIntegerLiteral(name);
            return new Location(null, null, val, val);
        }
        return (Location)this.labels.get(name);
    }

    public void newLocation(String section, String name, int vma_addr, int lma_addr) {
        Location l = new Location(section, name, vma_addr, lma_addr);
        this.labels.put(name, l);
        this.reverseMap.put(new Integer(lma_addr), name);
    }

    public Iterator getIterator() {
        return this.labels.values().iterator();
    }

    public class Location {
        public final String section;
        public final String name;
        public final int vma_addr;
        public final int lma_addr;

        Location(String s, String n, int vma_addr, int lma_addr) {
            this.section = s;
            this.name = n == null ? StringUtil.addrToString(lma_addr) : n;
            this.vma_addr = vma_addr;
            this.lma_addr = lma_addr;
        }

        public int hashCode() {
            if (this.name == null) {
                return this.lma_addr;
            }
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location l = (Location)o;
            return l.name.equals(this.name) && l.lma_addr == this.lma_addr;
        }

        public String toString() {
            return this.name;
        }
    }
}

