/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.arch.AbstractArchitecture;
import avrora.arch.ArchitectureRegistry;
import avrora.core.Program;
import avrora.core.SourceMapping;
import cck.help.HelpCategory;
import cck.text.StringUtil;
import cck.util.Option;
import cck.util.Util;
import java.util.ArrayList;

public abstract class ProgramReader
extends HelpCategory {
    public final Option.Str ARCH = this.newOption("arch", "avr", "This option specifies the name of the instruction set architecture for the specified program. This architecture option is used to retrieve an appropriate disassembler and interpreter for the program.");
    public final Option.List INDIRECT_EDGES = this.newOptionList("indirect-edges", "", "This option can be used to specify the possible targets of indirect calls and jumps within a program, which may be needed in performing stack analysis or building a control flow graph. Each element of the list is a pair of program addresses separated by a colon, where a program address can be a label or a hexadecimal number preceded by \"0x\". The first program address is the address of the indirect call or jump instruction and the second program address is a possible target.");
    public static ArrayList FileNames = new ArrayList();

    public abstract Program read(String[] var1) throws Exception;

    protected ProgramReader(String h) {
        super("reader", h);
        this.addSection("OVERVIEW", this.help);
        this.addOptionSection("Help for specific options is below.", this.options);
    }

    protected void addIndirectEdges(Program p) {
        for (String s : this.INDIRECT_EDGES.get()) {
            int ind = s.indexOf(58);
            if (ind <= 0) {
                throw Util.failure("invalid indirect edge format: " + StringUtil.quote(s));
            }
            SourceMapping sm = p.getSourceMapping();
            SourceMapping.Location loc = sm.getLocation(s.substring(0, ind));
            SourceMapping.Location tar = sm.getLocation(s.substring(ind + 1));
            p.addIndirectEdge(loc.lma_addr, tar.lma_addr);
        }
    }

    public AbstractArchitecture getArchitecture() {
        return ArchitectureRegistry.getArchitecture(this.ARCH.get());
    }
}

