/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.arch.AbstractArchitecture;
import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.core.CFGBuilder;
import avrora.core.ControlFlowGraph;
import avrora.core.SourceMapping;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Program {
    private final AbstractArchitecture arch;
    private final HashMap indirectEdges;
    private SourceMapping sourceMapping;
    private ControlFlowGraph cfg;
    public final int program_start;
    public final int program_end;
    public final int program_length;
    protected final byte[] flash_data;
    protected final AbstractInstr[] flash_instrs;

    public Program(AbstractArchitecture a, int pstart, int pend) {
        this.arch = a;
        this.program_start = pstart;
        this.program_end = pend;
        this.program_length = pend - pstart;
        int size = this.program_end - this.program_start;
        this.flash_data = new byte[size];
        this.flash_instrs = this.arch.newInstrArray(size);
        Arrays.fill(this.flash_data, (byte)-1);
        this.indirectEdges = new HashMap();
    }

    public void writeInstr(AbstractInstr i, int address) {
        int size = i.getSize();
        this.checkAddress(address);
        this.checkAddress(address + size - 1);
        this.flash_instrs[address - this.program_start] = i;
        for (int cntr = 1; cntr < size; ++cntr) {
            this.flash_instrs[address - this.program_start + cntr] = null;
        }
    }

    public AbstractInstr readInstr(int address) {
        if (address < this.program_start || address >= this.program_end) {
            return null;
        }
        return this.flash_instrs[address - this.program_start];
    }

    public AbstractInstr disassembleInstr(int address) {
        int offset;
        if (address < this.program_start || address >= this.program_end) {
            return null;
        }
        AbstractDisassembler d = this.arch.getDisassembler();
        AbstractInstr instr = d.disassemble(this.program_start, offset = address - this.program_start, this.flash_data);
        if (instr != null) {
            this.flash_instrs[offset] = instr;
        }
        return instr;
    }

    public byte readProgramByte(int address) {
        this.checkAddress(address);
        return this.flash_data[address - this.program_start];
    }

    public void writeProgramByte(byte val, int byteAddress) {
        this.checkAddress(byteAddress);
        int offset = byteAddress - this.program_start;
        this.writeByteInto(val, offset);
    }

    private void writeByteInto(byte val, int offset) {
        this.flash_data[offset] = val;
    }

    public void writeProgramBytes(byte[] val, int byteAddress) {
        this.checkAddress(byteAddress);
        this.checkAddress(byteAddress + val.length - 1);
        int offset = byteAddress - this.program_start;
        for (int cntr = 0; cntr < val.length; ++cntr) {
            this.writeByteInto(val[cntr], offset + cntr);
        }
    }

    protected void checkAddress(int addr) {
        if (addr < this.program_start || addr >= this.program_end) {
            throw Util.failure("address out of range: " + StringUtil.addrToString(addr));
        }
    }

    public int getNextPC(int pc) {
        if (pc > this.program_end) {
            throw Util.failure("no next PC after: " + StringUtil.addrToString(pc));
        }
        AbstractInstr i = this.readInstr(pc);
        if (i == null) {
            return pc + 2;
        }
        return pc + i.getSize();
    }

    public List getIndirectEdges(int callsite) {
        return (List)this.indirectEdges.get(new Integer(callsite));
    }

    public void addIndirectEdge(int callsite, int target) {
        Integer c = new Integer(callsite);
        Integer t = new Integer(target);
        LinkedList<Integer> l = (LinkedList<Integer>)this.indirectEdges.get(c);
        if (l == null) {
            l = new LinkedList<Integer>();
            l.add(t);
            this.indirectEdges.put(c, l);
        } else {
            l.add(t);
        }
    }

    public AbstractArchitecture getArchitecture() {
        return this.arch;
    }

    public SourceMapping getSourceMapping() {
        return this.sourceMapping;
    }

    public void setSourceMapping(SourceMapping s) {
        this.sourceMapping = s;
    }

    public synchronized ControlFlowGraph getCFG() {
        if (this.cfg == null) {
            this.cfg = new CFGBuilder(this).buildCFG();
        }
        return this.cfg;
    }
}

