/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.core.ControlFlowGraph;
import avrora.core.ProcedureMap;
import avrora.core.Program;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ProcedureMapBuilder {
    private final Program program;
    private final ControlFlowGraph cfg;
    private HashSet ENTRYPOINTS;
    private HashMap ENTRYMAP;
    private final Object SHARED = new Object();

    public ProcedureMapBuilder(Program p) {
        this.program = p;
        this.cfg = p.getCFG();
    }

    public ProcedureMap buildMap() {
        this.discoverProcedures();
        HashMap procMap = this.buildProcedureBlockLists();
        return new ProcedureMap(this.ENTRYPOINTS, this.ENTRYMAP, procMap);
    }

    private void discoverProcedures() {
        this.discoverEntrypoints();
        this.ENTRYMAP = new HashMap();
        for (Object block : this.ENTRYPOINTS) {
            this.ENTRYMAP.put(block, block);
        }
        for (Object block : this.ENTRYPOINTS) {
            this.propagate((ControlFlowGraph.Block)block, (ControlFlowGraph.Block)block, new HashSet());
        }
    }

    private void discoverEntrypoints() {
        this.ENTRYPOINTS = new HashSet();
        Iterator edges = this.cfg.getEdgeIterator();
        while (edges.hasNext()) {
            ControlFlowGraph.Edge edge = (ControlFlowGraph.Edge)edges.next();
            if (!"CALL".equals(edge.getType())) continue;
            if (edge.getTarget() == null) {
                this.addIndirectEntrypoints(edge, this.cfg);
                continue;
            }
            this.ENTRYPOINTS.add(edge.getTarget());
        }
    }

    private void addIndirectEntrypoints(ControlFlowGraph.Edge edge, ControlFlowGraph cfg) {
        List l = this.program.getIndirectEdges(edge.getSource().getLastAddress());
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            int target_addr = (Integer)i.next();
            ControlFlowGraph.Block target = cfg.getBlockStartingAt(target_addr);
            if (target == null) continue;
            this.ENTRYPOINTS.add(target);
        }
    }

    private void propagate(ControlFlowGraph.Block entry, ControlFlowGraph.Block block, HashSet seen) {
        if (this.ENTRYMAP.get(block) == this.SHARED) {
            return;
        }
        Iterator edges = block.getEdgeIterator();
        while (edges.hasNext()) {
            ControlFlowGraph.Block target;
            ControlFlowGraph.Edge edge = (ControlFlowGraph.Edge)edges.next();
            if ("CALL".equals(edge.getType()) || (target = edge.getTarget()) == null) continue;
            this.mark(entry, target);
            if (!seen.contains(target)) {
                seen.add(target);
                this.propagate(entry, target, seen);
                continue;
            }
            seen.add(target);
        }
    }

    private void mark(ControlFlowGraph.Block entry, ControlFlowGraph.Block block) {
        Object c = this.ENTRYMAP.get(block);
        if (c == this.SHARED) {
            return;
        }
        if (c == null) {
            c = entry;
        }
        if (c != entry) {
            this.markShared(block);
        } else {
            this.ENTRYMAP.put(block, entry);
        }
    }

    private void markShared(ControlFlowGraph.Block block) {
        if (this.ENTRYMAP.get(block) == this.SHARED) {
            return;
        }
        this.ENTRYMAP.put(block, this.SHARED);
        Iterator edges = block.getEdgeIterator();
        while (edges.hasNext()) {
            ControlFlowGraph.Block target;
            ControlFlowGraph.Edge edge = (ControlFlowGraph.Edge)edges.next();
            if ("CALL".equals(edge.getType()) || (target = edge.getTarget()) == null) continue;
            this.markShared(target);
        }
    }

    private HashMap buildProcedureBlockLists() {
        HashMap procMap = new HashMap();
        for (ControlFlowGraph.Block entry : this.ENTRYPOINTS) {
            procMap.put(entry, new LinkedList());
        }
        Iterator block_iter = this.cfg.getBlockIterator();
        while (block_iter.hasNext()) {
            ControlFlowGraph.Block block = (ControlFlowGraph.Block)block_iter.next();
            Object mark = this.ENTRYMAP.get(block);
            if (mark == null || !(mark instanceof ControlFlowGraph.Block)) continue;
            ControlFlowGraph.Block entry = (ControlFlowGraph.Block)mark;
            LinkedList list = (LinkedList)procMap.get(entry);
            list.add(block);
        }
        return procMap;
    }
}

