/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.core.ControlFlowGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ProcedureMap {
    protected final HashSet entryPoints;
    protected final HashMap entryMap;
    protected final HashMap procMap;

    ProcedureMap(HashSet ep, HashMap em, HashMap pm) {
        this.entryPoints = ep;
        this.entryMap = em;
        this.procMap = pm;
    }

    public boolean isInAnyProcedure(ControlFlowGraph.Block b) {
        return this.entryMap.get(b) != null;
    }

    public boolean isSharedBetweenProcedures(ControlFlowGraph.Block b) {
        Object o = this.entryMap.get(b);
        return o != null && !(o instanceof ControlFlowGraph.Block);
    }

    public ControlFlowGraph.Block getProcedureContaining(ControlFlowGraph.Block b) {
        Object o = this.entryMap.get(b);
        if (o instanceof ControlFlowGraph.Block) {
            return (ControlFlowGraph.Block)o;
        }
        return null;
    }

    public Collection getProcedureBlocks(ControlFlowGraph.Block entry) {
        return (Collection)this.procMap.get(entry);
    }

    public Collection getProcedureEntrypoints() {
        return this.entryPoints;
    }
}

