/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.Main;
import avrora.core.Program;
import cck.util.Util;
import java.io.File;

public class LoadableProgram {
    public final String fname;
    public final File file;
    protected Program program;

    public LoadableProgram(File f) {
        this.file = f;
        this.fname = f.getAbsolutePath();
    }

    public LoadableProgram(String fname) {
        this.file = new File(fname);
        this.fname = fname;
    }

    public Program getProgram() {
        if (this.program == null) {
            throw Util.failure("Program " + this.file + " must be loaded before use");
        }
        return this.program;
    }

    public void load() throws Exception {
        this.program = Main.loadProgram(new String[]{this.fname});
    }

    public String getName() {
        return this.file.getName();
    }
}

