/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.arch.legacy.LegacyInstr;
import avrora.core.ProcedureMap;
import avrora.core.ProcedureMapBuilder;
import avrora.core.Program;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ControlFlowGraph {
    protected final HashMap blocks;
    protected final List allEdges;
    protected final Program program;
    public static final Comparator COMPARATOR = new BlockComparator();
    private ProcedureMap pmap;

    ControlFlowGraph(Program p) {
        this.program = p;
        this.blocks = new HashMap();
        this.allEdges = new LinkedList();
    }

    public Block newBlock(int address) {
        Block b = new Block(address);
        this.blocks.put(new Integer(address), b);
        return b;
    }

    public void addEdge(Block s, Block t, String type) {
        Edge edge = new Edge(type, s, t);
        s.edges.add(edge);
        this.allEdges.add(edge);
    }

    public void addEdge(Block s, Block t) {
        Edge edge = new Edge("", s, t);
        s.edges.add(edge);
        this.allEdges.add(edge);
    }

    public Block getBlockStartingAt(int address) {
        return (Block)this.blocks.get(new Integer(address));
    }

    public Block getBlockContaining(int address) {
        throw Util.unimplemented();
    }

    public Iterator getBlockIterator() {
        return this.blocks.values().iterator();
    }

    public Iterator getSortedBlockIterator() {
        ArrayList l = Collections.list(Collections.enumeration(this.blocks.values()));
        Collections.sort(l, COMPARATOR);
        return l.iterator();
    }

    public Iterator getEdgeIterator() {
        return this.allEdges.iterator();
    }

    public synchronized ProcedureMap getProcedureMap() {
        if (this.pmap == null) {
            this.pmap = new ProcedureMapBuilder(this.program).buildMap();
        }
        return this.pmap;
    }

    private static class BlockComparator
    implements Comparator {
        private BlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            Block b1 = (Block)o1;
            Block b2 = (Block)o2;
            return b1.address - b2.address;
        }
    }

    public class Block {
        private final int address;
        private int last_address;
        private int size;
        private int length;
        private final List instructions;
        private final List edges;

        Block(int addr) {
            this.last_address = this.address = addr;
            this.instructions = new LinkedList();
            this.edges = new LinkedList();
        }

        public void addInstr(LegacyInstr i) {
            this.instructions.add(i);
            this.last_address = this.address + this.size;
            this.size += i.getSize();
            ++this.length;
        }

        public int hashCode() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            return ((Block)o).address == this.address;
        }

        public int getAddress() {
            return this.address;
        }

        public int getLastAddress() {
            return this.last_address;
        }

        public int getSize() {
            return this.size;
        }

        public int getLength() {
            return this.length;
        }

        public Iterator getInstrIterator() {
            return this.instructions.iterator();
        }

        public Iterator getEdgeIterator() {
            return this.edges.iterator();
        }
    }

    public class Edge {
        private final String type;
        private final Block source;
        private final Block target;

        Edge(String t, Block s, Block b) {
            this.type = t;
            this.source = s;
            this.target = b;
        }

        public String getType() {
            return this.type;
        }

        public Block getSource() {
            return this.source;
        }

        public Block getTarget() {
            return this.target;
        }
    }
}

