/*
 * Decompiled with CFR 0.152.
 */
package avrora.core;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.core.ControlFlowGraph;
import avrora.core.Program;
import cck.text.StringUtil;
import cck.text.Verbose;
import cck.util.Util;

class CFGBuilder
implements LegacyInstrVisitor {
    final Program program;
    ControlFlowGraph cfg;
    InstrInfo[] info;
    private int pc;
    final Verbose.Printer printer = Verbose.getVerbosePrinter("cfg.builder");

    public CFGBuilder(Program p) {
        this.program = p;
    }

    public ControlFlowGraph buildCFG() {
        this.initializeInfo();
        this.discoverEntrypoints();
        this.buildBlocks();
        return this.cfg;
    }

    private void buildBlocks() {
        int size;
        this.cfg = new ControlFlowGraph(this.program);
        ControlFlowGraph.Block block = this.cfg.newBlock(0);
        for (int pc = 0; pc < this.program.program_end; pc += size) {
            ControlFlowGraph.Block nextblock = block;
            InstrInfo ii = this.info[pc];
            size = ii.instr == null ? 2 : ii.instr.getSize();
            for (int cntr = 1; cntr < size; ++cntr) {
                if (!this.info[pc + cntr].start && this.info[pc + cntr].instr == null) continue;
                Util.warning("misaligned branch target at " + StringUtil.addrToString(pc + cntr));
            }
            if (pc + size < this.program.program_end) {
                InstrInfo in2 = this.info[pc + size];
                if (in2.start) {
                    nextblock = this.cfg.getBlockStartingAt(pc + size);
                    if (nextblock == null) {
                        nextblock = this.cfg.newBlock(pc + size);
                    }
                    if (ii.fallthrough) {
                        this.cfg.addEdge(block, nextblock);
                    }
                }
            }
            if (ii.branchTo >= 0) {
                ControlFlowGraph.Block tblock;
                if (ii.indirect) {
                    tblock = null;
                } else {
                    tblock = this.cfg.getBlockStartingAt(ii.branchTo);
                    if (tblock == null) {
                        tblock = this.cfg.newBlock(ii.branchTo);
                    }
                }
                if (ii.call) {
                    this.cfg.addEdge(block, tblock, "CALL");
                } else {
                    this.cfg.addEdge(block, tblock);
                }
            }
            if (ii.ret) {
                this.cfg.addEdge(block, null, "RET");
            }
            if (ii.reti) {
                this.cfg.addEdge(block, null, "RETI");
            }
            if (ii.instr != null) {
                block.addInstr(ii.instr);
            }
            block = nextblock;
        }
        this.info = null;
    }

    private void discoverEntrypoints() {
        if (this.printer.enabled) {
            this.printer.println("CFGBuilder: discovering entrypoints...");
        }
        this.pc = 0;
        while (this.pc < this.program.program_end) {
            LegacyInstr i;
            if (this.printer.enabled) {
                this.printer.print(StringUtil.addrToString(this.pc) + ": ");
            }
            if ((i = (LegacyInstr)this.program.readInstr(this.pc)) == null) {
                if (this.printer.enabled) {
                    this.printer.println("(invalid)");
                }
                this.pc += 2;
                continue;
            }
            if (this.printer.enabled) {
                this.printer.print(StringUtil.leftJustify(i.toString(), 20));
            }
            i.accept(this);
            this.pc += i.getSize();
        }
    }

    private void initializeInfo() {
        this.info = new InstrInfo[this.program.program_end];
        for (int cntr = 0; cntr < this.program.program_end; ++cntr) {
            this.info[cntr] = new InstrInfo();
        }
        this.info[0].start = true;
    }

    private void enter(int byteAddress) {
        if (byteAddress < 0 || byteAddress >= this.program.program_end) {
            return;
        }
        this.info[byteAddress].start = true;
    }

    private void add(LegacyInstr i) {
        this.info[this.pc].instr = i;
        if (this.printer.enabled) {
            this.printer.println("    -> add");
        }
    }

    private void branch(LegacyInstr i, int byteAddress) {
        this.info[this.pc].instr = i;
        this.info[this.pc].branchTo = byteAddress;
        if (this.printer.enabled) {
            this.printer.println("    -> branch to " + StringUtil.addrToString(byteAddress));
        }
        this.enter(this.pc + i.getSize());
        this.enter(byteAddress);
    }

    private void call(LegacyInstr i, int byteAddress) {
        this.info[this.pc].call = true;
        this.info[this.pc].instr = i;
        this.info[this.pc].branchTo = byteAddress;
        if (this.printer.enabled) {
            this.printer.println("    -> call to " + StringUtil.addrToString(byteAddress));
        }
        this.enter(this.pc + i.getSize());
        this.enter(byteAddress);
    }

    private void end(LegacyInstr i) {
        this.info[this.pc].instr = i;
        this.info[this.pc].fallthrough = false;
        if (this.printer.enabled) {
            this.printer.println("    -> end");
        }
        this.enter(this.pc + i.getSize());
    }

    private void jump(LegacyInstr i, int byteAddress) {
        this.info[this.pc].instr = i;
        this.info[this.pc].fallthrough = false;
        this.info[this.pc].branchTo = byteAddress;
        if (this.printer.enabled) {
            this.printer.println("    -> jump to " + StringUtil.addrToString(byteAddress));
        }
        this.enter(this.pc + i.getSize());
        this.enter(byteAddress);
    }

    private int relative(int i) {
        return i * 2 + 2 + this.pc;
    }

    private int absolute(int i) {
        return i * 2;
    }

    private void skip(LegacyInstr i) {
        int npc = this.pc + i.getSize();
        LegacyInstr next = (LegacyInstr)this.program.readInstr(npc);
        this.branch(i, npc + next.getSize());
    }

    public void visit(LegacyInstr.ADC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ADD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ADIW i) {
        this.add(i);
    }

    public void visit(LegacyInstr.AND i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ANDI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ASR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.BCLR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.BLD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.BRBC i) {
        this.branch(i, this.relative(i.imm2));
    }

    public void visit(LegacyInstr.BRBS i) {
        this.branch(i, this.relative(i.imm2));
    }

    public void visit(LegacyInstr.BRCC i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRCS i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BREAK i) {
        this.end(i);
    }

    public void visit(LegacyInstr.BREQ i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRGE i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRHC i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRHS i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRID i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRIE i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRLO i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRLT i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRMI i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRNE i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRPL i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRSH i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRTC i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRTS i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRVC i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRVS i) {
        this.branch(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BSET i) {
        this.add(i);
    }

    public void visit(LegacyInstr.BST i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CALL i) {
        this.call(i, this.absolute(i.imm1));
    }

    public void visit(LegacyInstr.CBI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CBR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLH i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLN i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLS i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLT i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLV i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CLZ i) {
        this.add(i);
    }

    public void visit(LegacyInstr.COM i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CP i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CPC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CPI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.CPSE i) {
        this.add(i);
    }

    public void visit(LegacyInstr.DEC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.EICALL i) {
        this.info[this.pc].indirect = true;
        this.call(i, 0);
    }

    public void visit(LegacyInstr.EIJMP i) {
        this.info[this.pc].indirect = true;
        this.branch(i, 0);
    }

    public void visit(LegacyInstr.ELPM i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ELPMD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ELPMPI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.EOR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.FMUL i) {
        this.add(i);
    }

    public void visit(LegacyInstr.FMULS i) {
        this.add(i);
    }

    public void visit(LegacyInstr.FMULSU i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ICALL i) {
        this.info[this.pc].indirect = true;
        this.call(i, 0);
    }

    public void visit(LegacyInstr.IJMP i) {
        this.info[this.pc].indirect = true;
        this.info[this.pc].branchTo = 0;
        this.end(i);
    }

    public void visit(LegacyInstr.IN i) {
        this.add(i);
    }

    public void visit(LegacyInstr.INC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.JMP i) {
        this.jump(i, this.absolute(i.imm1));
    }

    public void visit(LegacyInstr.LD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LDD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LDI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LDPD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LDPI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LDS i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LPM i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LPMD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LPMPI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LSL i) {
        this.add(i);
    }

    public void visit(LegacyInstr.LSR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.MOV i) {
        this.add(i);
    }

    public void visit(LegacyInstr.MOVW i) {
        this.add(i);
    }

    public void visit(LegacyInstr.MUL i) {
        this.add(i);
    }

    public void visit(LegacyInstr.MULS i) {
        this.add(i);
    }

    public void visit(LegacyInstr.MULSU i) {
        this.add(i);
    }

    public void visit(LegacyInstr.NEG i) {
        this.add(i);
    }

    public void visit(LegacyInstr.NOP i) {
        this.add(i);
    }

    public void visit(LegacyInstr.OR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ORI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.OUT i) {
        this.add(i);
    }

    public void visit(LegacyInstr.POP i) {
        this.add(i);
    }

    public void visit(LegacyInstr.PUSH i) {
        this.add(i);
    }

    public void visit(LegacyInstr.RCALL i) {
        this.call(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.RET i) {
        this.info[this.pc].ret = true;
        this.end(i);
    }

    public void visit(LegacyInstr.RETI i) {
        this.info[this.pc].reti = true;
        this.end(i);
    }

    public void visit(LegacyInstr.RJMP i) {
        this.jump(i, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.ROL i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ROR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBCI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBIC i) {
        this.skip(i);
    }

    public void visit(LegacyInstr.SBIS i) {
        this.skip(i);
    }

    public void visit(LegacyInstr.SBIW i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBR i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SBRC i) {
        this.skip(i);
    }

    public void visit(LegacyInstr.SBRS i) {
        this.skip(i);
    }

    public void visit(LegacyInstr.SEC i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SEH i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SEI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SEN i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SER i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SES i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SET i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SEV i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SEZ i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SLEEP i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SPM i) {
        this.add(i);
    }

    public void visit(LegacyInstr.ST i) {
        this.add(i);
    }

    public void visit(LegacyInstr.STD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.STPD i) {
        this.add(i);
    }

    public void visit(LegacyInstr.STPI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.STS i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SUB i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SUBI i) {
        this.add(i);
    }

    public void visit(LegacyInstr.SWAP i) {
        this.add(i);
    }

    public void visit(LegacyInstr.TST i) {
        this.add(i);
    }

    public void visit(LegacyInstr.WDR i) {
        this.add(i);
    }

    static class InstrInfo {
        boolean start = false;
        boolean fallthrough = true;
        boolean ret;
        boolean reti;
        boolean call;
        boolean indirect;
        LegacyInstr instr;
        int branchTo = -1;

        InstrInfo() {
        }
    }
}

