/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import java.util.HashMap;

public class MSP430Symbol {
    public final String symbol;
    public final int value;

    MSP430Symbol(String sym, int v) {
        this.symbol = sym;
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public int getEncodingValue() {
        return this.value;
    }

    public static GPR get_GPR(String name) {
        return (GPR)GPR.set.get(name);
    }

    public static class GPR
    extends MSP430Symbol {
        private static HashMap set = new HashMap();
        public static final GPR PC = GPR.newGPR("pc", 0);
        public static final GPR SP = GPR.newGPR("sp", 1);
        public static final GPR SR = GPR.newGPR("sr", 2);
        public static final GPR R0 = GPR.newGPR("r0", 0);
        public static final GPR R1 = GPR.newGPR("r1", 1);
        public static final GPR R2 = GPR.newGPR("r2", 2);
        public static final GPR R3 = GPR.newGPR("r3", 3);
        public static final GPR R4 = GPR.newGPR("r4", 4);
        public static final GPR R5 = GPR.newGPR("r5", 5);
        public static final GPR R6 = GPR.newGPR("r6", 6);
        public static final GPR R7 = GPR.newGPR("r7", 7);
        public static final GPR R8 = GPR.newGPR("r8", 8);
        public static final GPR R9 = GPR.newGPR("r9", 9);
        public static final GPR R10 = GPR.newGPR("r10", 10);
        public static final GPR R11 = GPR.newGPR("r11", 11);
        public static final GPR R12 = GPR.newGPR("r12", 12);
        public static final GPR R13 = GPR.newGPR("r13", 13);
        public static final GPR R14 = GPR.newGPR("r14", 14);
        public static final GPR R15 = GPR.newGPR("r15", 15);

        private static GPR newGPR(String n, int v) {
            GPR obj = new GPR(n, v);
            set.put(n, obj);
            return obj;
        }

        GPR(String sym, int v) {
            super(sym, v);
        }
    }
}

