/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.AbstractInstr;
import avrora.arch.msp430.MSP430DataSegment;
import avrora.arch.msp430.MSP430Symbol;
import avrora.sim.ActiveRegister;
import avrora.sim.Interpreter;
import avrora.sim.Segment;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.util.Util;

public abstract class MSP430State
extends Interpreter
implements State {
    public static final int NUM_REGS = 16;
    public static final int PC_REG = 0;
    public static final int SP_REG = 1;
    public static final int SREG_REG = 2;
    protected int pc;
    protected int nextpc;
    protected int sreg;
    protected char[] regs;
    protected ActiveRegister[] ioregs;
    protected MSP430DataSegment data;
    protected boolean C;
    protected boolean N;
    protected boolean Z;
    protected boolean V;

    protected MSP430State(Simulator sim) {
        super(sim);
    }

    public int getPC() {
        return this.pc;
    }

    public int getSP() {
        return this.regs[1];
    }

    public byte getSRAM(int address) {
        return this.data.get(address);
    }

    public char getIOReg(int ior) {
        throw Util.unimplemented();
    }

    public char getRegister(MSP430Symbol.GPR reg) {
        return this.regs[reg.value];
    }

    public char getRegister(int reg) {
        return this.regs[reg];
    }

    public long getCycles() {
        return this.clock.getCount();
    }

    public char getSREG() {
        return this.regs[2];
    }

    public boolean isEnabled(int inum) {
        return this.interrupts.isEnabled(inum);
    }

    public boolean isPosted(int inum) {
        return this.interrupts.isPosted(inum);
    }

    public boolean isPending(int inum) {
        return this.interrupts.isPending(inum);
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public AbstractInstr getInstr(int address) {
        return this.data.readInstr(address);
    }

    protected int map_get(char[] array, int ind) {
        return array[ind];
    }

    protected void map_set(char[] array, int ind, int val) {
        if (ind == 0) {
            this.nextpc = val;
        }
        array[ind] = (char)val;
    }

    protected int map_get(Segment s, int addr) {
        return s.read(addr);
    }

    protected void map_set(Segment s, int addr, int val) {
        s.write(addr, (byte)val);
    }
}

