/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.msp430.MSP430InstrBuilder;
import avrora.arch.msp430.MSP430OperandVisitor;
import avrora.arch.msp430.MSP430Symbol;

public abstract class MSP430Operand {
    public static final byte SREG_val = 1;
    public static final byte AIREG_B_val = 2;
    public static final byte AIREG_W_val = 3;
    public static final byte IREG_val = 4;
    public static final byte IMM_val = 5;
    public static final byte IMML_val = 6;
    public static final byte INDX_val = 7;
    public static final byte SYMB_val = 8;
    public static final byte ABSO_val = 9;
    public static final byte JUMP_val = 10;
    public final byte op_type;

    public abstract void accept(MSP430OperandVisitor var1);

    protected MSP430Operand(byte t) {
        this.op_type = t;
    }

    public static class JUMP
    extends Rel {
        public static final int low = -512;
        public static final int high = 511;

        JUMP(int pc, int rel) {
            super((byte)10, pc + 2 + 2 * rel, MSP430InstrBuilder.checkValue(rel, -512, 511));
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class ABSO
    extends Addr {
        public static final int low = Short.MIN_VALUE;
        public static final int high = 65535;

        ABSO(int addr) {
            super((byte)9, MSP430InstrBuilder.checkValue(addr, Short.MIN_VALUE, 65535));
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class SYMB
    extends Rel {
        public static final int low = Short.MIN_VALUE;
        public static final int high = 65535;

        SYMB(int pc, int rel) {
            super((byte)8, pc + 1 + rel, MSP430InstrBuilder.checkValue(rel, Short.MIN_VALUE, 65535));
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class INDX
    extends MSP430Operand {
        public final SREG reg;
        public final IMM index;

        public INDX(SREG reg, IMM index) {
            super((byte)7);
            this.reg = reg;
            this.index = index;
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMML
    extends Int {
        public static final int low = Short.MIN_VALUE;
        public static final int high = 65536;

        IMML(int val) {
            super((byte)6, MSP430InstrBuilder.checkValue(val, Short.MIN_VALUE, 65536));
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM
    extends Int {
        public static final int low = Short.MIN_VALUE;
        public static final int high = 65536;

        IMM(int val) {
            super((byte)5, MSP430InstrBuilder.checkValue(val, Short.MIN_VALUE, 65536));
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IREG
    extends Sym {
        IREG(String s) {
            super((byte)4, MSP430Symbol.get_GPR(s));
        }

        IREG(MSP430Symbol.GPR sym) {
            super((byte)4, sym);
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class AIREG_W
    extends Sym {
        AIREG_W(String s) {
            super((byte)3, MSP430Symbol.get_GPR(s));
        }

        AIREG_W(MSP430Symbol.GPR sym) {
            super((byte)3, sym);
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class AIREG_B
    extends Sym {
        AIREG_B(String s) {
            super((byte)2, MSP430Symbol.get_GPR(s));
        }

        AIREG_B(MSP430Symbol.GPR sym) {
            super((byte)2, sym);
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    public static class SREG
    extends Sym {
        SREG(String s) {
            super((byte)1, MSP430Symbol.get_GPR(s));
        }

        SREG(MSP430Symbol.GPR sym) {
            super((byte)1, sym);
        }

        public void accept(MSP430OperandVisitor v) {
            v.visit(this);
        }
    }

    static abstract class Rel
    extends MSP430Operand {
        public final int value;
        public final int relative;

        Rel(byte t, int addr, int rel) {
            super(t);
            this.value = addr;
            this.relative = rel;
        }

        public String toString() {
            if (this.relative >= 0) {
                return ".+" + this.relative;
            }
            return "." + this.relative;
        }
    }

    static abstract class Addr
    extends MSP430Operand {
        public final int value;

        Addr(byte t, int addr) {
            super(t);
            this.value = addr;
        }

        public String toString() {
            String hs = Integer.toHexString(this.value);
            StringBuffer buf = new StringBuffer("0x");
            for (int cntr = hs.length(); cntr < 4; ++cntr) {
                buf.append('0');
            }
            buf.append(hs);
            return buf.toString();
        }
    }

    static abstract class Sym
    extends MSP430Operand {
        public final MSP430Symbol value;

        Sym(byte t, MSP430Symbol sym) {
            super(t);
            if (sym == null) {
                throw new Error();
            }
            this.value = sym;
        }

        public String toString() {
            return this.value.symbol;
        }
    }

    static abstract class Int
    extends MSP430Operand {
        public final int value;

        Int(byte t, int val) {
            super(t);
            this.value = val;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

