/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.msp430.MSP430AddrModeVisitor;
import avrora.arch.msp430.MSP430DataSegment;
import avrora.arch.msp430.MSP430Instr;
import avrora.arch.msp430.MSP430InstrInterpreter;
import avrora.arch.msp430.MSP430InstrVisitor;
import avrora.arch.msp430.MSP430Properties;
import avrora.arch.msp430.MSP430Symbol;
import avrora.core.Program;
import avrora.sim.Interpreter;
import avrora.sim.InterpreterFactory;
import avrora.sim.InterruptTable;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.mcu.RegisterSet;
import avrora.sim.util.MulticastProbe;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Util;

public class MSP430Interpreter
extends MSP430InstrInterpreter {
    public static Factory FACTORY = new Factory();
    protected final RegisterSet registers;
    protected final MSP430Instr[] shared_instr;
    protected final STOP_instr STOP;
    protected boolean innerLoop;
    protected boolean shouldRun;
    protected boolean sleeping;
    protected MulticastProbe globalProbe;

    public MSP430Interpreter(Simulator simulator, Program p, MSP430Properties pr) {
        super(simulator);
        Compiler.compileClass(this.getClass());
        if (p.program_end > 65536) {
            throw Util.failure("program will not fit into 65536 bytes");
        }
        this.regs = new char[16];
        this.registers = simulator.getMicrocontroller().getRegisterSet();
        this.data = new MSP430DataSegment(pr.sram_size, pr.code_start, this.registers.share(), this);
        this.interrupts = new InterruptTable(this, pr.num_interrupts);
        this.shared_instr = this.data.shareInstr();
        this.data.loadProgram(p);
        this.pc = pr.code_start;
        this.globalProbe = new MulticastProbe();
        this.STOP = new STOP_instr();
    }

    protected void runLoop() {
        while (this.shouldRun) {
            if (this.globalProbe.isEmpty()) {
                this.fastLoop();
                continue;
            }
            this.instrumentedLoop();
        }
    }

    private void fastLoop() {
        this.innerLoop = true;
        while (this.innerLoop) {
            int curpc = this.pc;
            this.execute(this.fetch(curpc));
        }
    }

    private void instrumentedLoop() {
        this.innerLoop = true;
        while (this.innerLoop) {
            int curpc = this.pc;
            this.globalProbe.fireBefore(this, curpc);
            this.execute(this.fetch(curpc));
            this.globalProbe.fireAfter(this, curpc);
        }
    }

    private MSP430Instr fetch(int curpc) {
        MSP430Instr i = this.shared_instr[curpc];
        if (i == null) {
            SimUtil.warning(this.simulator, StringUtil.to0xHex(curpc, 4), "invalid instruction");
            i = this.STOP;
        }
        this.regs[0] = (char)(curpc + 2);
        this.nextpc = curpc + i.getSize();
        return i;
    }

    private void execute(MSP430Instr i) {
        i.accept(this);
        this.regs[0] = (char)this.nextpc;
        this.pc = this.regs[0];
        this.clock.advance(1L);
    }

    protected void bumpPC() {
        this.regs[0] = (char)(this.regs[0] + 2);
    }

    protected int bit(boolean b) {
        return b ? 1 : 0;
    }

    protected int popByte() {
        int sp = this.getSP();
        byte b = this.data.read(sp);
        this.regs[1] = (char)(sp + 1);
        return b;
    }

    protected void pushByte(int b) {
        int sp = this.getSP();
        int nsp = sp - 1;
        this.data.write(nsp, (byte)b);
        this.regs[1] = (char)nsp;
    }

    protected void disableInterrupts() {
    }

    protected void enableInterrupts() {
    }

    protected int popWord() {
        byte b1 = (byte)this.popByte();
        byte b2 = (byte)this.popByte();
        return this.uword(b1, b2);
    }

    protected void pushWord(int b) {
        int sp = this.getSP();
        int nsp = sp - 2;
        this.data.write(nsp, (byte)b);
        this.data.write(nsp + 1, (byte)(b >> 8));
        this.regs[1] = (char)nsp;
    }

    public State getState() {
        return this;
    }

    public void start() {
        this.shouldRun = true;
        this.runLoop();
    }

    public int step() {
        throw Util.unimplemented();
    }

    public void stop() {
        this.shouldRun = false;
        this.innerLoop = false;
    }

    protected void insertProbe(Simulator.Probe p, int addr) {
        throw Util.unimplemented();
    }

    protected void insertErrorWatch(Simulator.Watch watch) {
        throw Util.unimplemented();
    }

    protected void insertProbe(Simulator.Probe p) {
        this.globalProbe.add(p);
        this.innerLoop = false;
    }

    protected void removeProbe(Simulator.Probe p, int addr) {
        throw Util.unimplemented();
    }

    public void removeProbe(Simulator.Probe b) {
        this.globalProbe.remove(b);
    }

    protected void insertWatch(Simulator.Watch p, int data_addr) {
        throw Util.unimplemented();
    }

    protected void removeWatch(Simulator.Watch p, int data_addr) {
        throw Util.unimplemented();
    }

    protected void delay(long cycles) {
        throw Util.unimplemented();
    }

    public void setRegister(MSP430Symbol.GPR reg, char val) {
        this.regs[reg.value] = val;
    }

    public void setData(int address, char val) {
        this.data.set(address, (byte)val);
        this.data.set(address + 1, (byte)(val >> 8));
    }

    class STOP_instr
    extends MSP430Instr {
        STOP_instr() {
            super("stop", 0);
        }

        public void accept(MSP430InstrVisitor v) {
            MSP430Interpreter.this.stop();
        }

        public void accept(MSP430AddrModeVisitor v) {
        }
    }

    public static class Factory
    extends InterpreterFactory {
        public Interpreter newInterpreter(Simulator s, Program p, MCUProperties pr) {
            return new MSP430Interpreter(s, p, (MSP430Properties)pr);
        }
    }
}

