/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.msp430.MSP430Instr;
import avrora.arch.msp430.MSP430InstrVisitor;
import avrora.arch.msp430.MSP430Operand;
import avrora.arch.msp430.MSP430State;
import avrora.sim.Simulator;
import cck.util.Util;

public abstract class MSP430InstrInterpreter
extends MSP430State
implements MSP430InstrVisitor {
    public MSP430InstrInterpreter(Simulator s) {
        super(s);
    }

    boolean bit_get(int v, int bit) {
        return (v & 1 << bit) != 0;
    }

    int bit_set(int v, int bit, boolean value) {
        if (value) {
            return v | 1 << bit;
        }
        return v & ~(1 << bit);
    }

    int bit_update(int v, int mask, int e) {
        return v & ~mask | e & mask;
    }

    int b2i(boolean v, int val) {
        if (v) {
            return val;
        }
        return 0;
    }

    int $read_poly_int8(MSP430Operand o) {
        switch (o.op_type) {
            case 4: {
                return this.$read_int8((MSP430Operand.IREG)o);
            }
            case 7: {
                return this.$read_int8((MSP430Operand.INDX)o);
            }
            case 2: {
                return this.$read_int8((MSP430Operand.AIREG_B)o);
            }
            case 5: {
                return this.$read_int8((MSP430Operand.IMM)o);
            }
            case 1: {
                return this.$read_int8((MSP430Operand.SREG)o);
            }
            case 9: {
                return this.$read_int8((MSP430Operand.ABSO)o);
            }
            case 8: {
                return this.$read_int8((MSP430Operand.SYMB)o);
            }
            case 6: {
                return this.$read_int8((MSP430Operand.IMML)o);
            }
        }
        throw Util.failure("invalid operand type in read");
    }

    int $read_poly_uint16(MSP430Operand o) {
        switch (o.op_type) {
            case 7: {
                return this.$read_uint16((MSP430Operand.INDX)o);
            }
            case 6: {
                return this.$read_uint16((MSP430Operand.IMML)o);
            }
            case 5: {
                return this.$read_uint16((MSP430Operand.IMM)o);
            }
            case 4: {
                return this.$read_uint16((MSP430Operand.IREG)o);
            }
            case 3: {
                return this.$read_uint16((MSP430Operand.AIREG_W)o);
            }
            case 9: {
                return this.$read_uint16((MSP430Operand.ABSO)o);
            }
            case 1: {
                return this.$read_uint16((MSP430Operand.SREG)o);
            }
            case 8: {
                return this.$read_uint16((MSP430Operand.SYMB)o);
            }
        }
        throw Util.failure("invalid operand type in read");
    }

    void $write_poly_int8(MSP430Operand o, int value) {
        switch (o.op_type) {
            case 9: {
                this.$write_int8((MSP430Operand.ABSO)o, value);
                return;
            }
            case 7: {
                this.$write_int8((MSP430Operand.INDX)o, value);
                return;
            }
            case 2: {
                this.$write_int8((MSP430Operand.AIREG_B)o, value);
                return;
            }
            case 4: {
                this.$write_int8((MSP430Operand.IREG)o, value);
                return;
            }
            case 8: {
                this.$write_int8((MSP430Operand.SYMB)o, value);
                return;
            }
            case 6: {
                this.$write_int8((MSP430Operand.IMML)o, value);
                return;
            }
            case 1: {
                this.$write_int8((MSP430Operand.SREG)o, value);
                return;
            }
            case 5: {
                this.$write_int8((MSP430Operand.IMM)o, value);
                return;
            }
        }
        throw Util.failure("invalid operand type in write");
    }

    void $write_poly_uint16(MSP430Operand o, int value) {
        switch (o.op_type) {
            case 5: {
                this.$write_uint16((MSP430Operand.IMM)o, value);
                return;
            }
            case 1: {
                this.$write_uint16((MSP430Operand.SREG)o, value);
                return;
            }
            case 6: {
                this.$write_uint16((MSP430Operand.IMML)o, value);
                return;
            }
            case 3: {
                this.$write_uint16((MSP430Operand.AIREG_W)o, value);
                return;
            }
            case 7: {
                this.$write_uint16((MSP430Operand.INDX)o, value);
                return;
            }
            case 4: {
                this.$write_uint16((MSP430Operand.IREG)o, value);
                return;
            }
            case 9: {
                this.$write_uint16((MSP430Operand.ABSO)o, value);
                return;
            }
            case 8: {
                this.$write_uint16((MSP430Operand.SYMB)o, value);
                return;
            }
        }
        throw Util.failure("invalid operand type in write");
    }

    public int get_word(int addr) {
        return this.uword(this.map_get(this.data, addr), this.map_get(this.data, addr + 1));
    }

    public void set_word(int addr, int value) {
        this.map_set(this.data, addr, this.low(value));
        this.map_set(this.data, addr + 1, this.high(value));
    }

    public int performAddition(int r1, int r2, int carry) {
        int result = r1 + r2 + carry;
        boolean Rd7 = this.bit_get(r1, 7);
        boolean Rr7 = this.bit_get(r2, 7);
        boolean R7 = this.bit_get(result, 7);
        this.C = this.bit_get(result, 8);
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = Rd7 && Rr7 && !R7 || !Rd7 && !Rr7 && R7;
        return this.low(result);
    }

    public int performAdditionW(int r1, int r2, int carry) {
        int result = r1 + r2 + carry;
        boolean Rd15 = this.bit_get(r1, 15);
        boolean Rr15 = this.bit_get(r2, 15);
        boolean R15 = this.bit_get(result, 15);
        this.C = this.bit_get(result, 16);
        this.N = this.bit_get(result, 15);
        this.Z = result == 0;
        this.V = Rd15 && Rr15 && !R15 || !Rd15 && !Rr15 && R15;
        return result;
    }

    public int performSubtraction(int r1, int r2, int carry) {
        int result = r2 - r1 - carry;
        boolean Rd7 = this.bit_get(r1, 7);
        boolean Rr7 = this.bit_get(r2, 7);
        boolean R7 = this.bit_get(result, 7);
        this.C = !Rd7 && Rr7 || Rr7 && R7 || R7 && !Rd7;
        this.N = R7;
        this.Z = this.low(result) == 0;
        this.V = Rd7 && !Rr7 && !R7 || !Rd7 && Rr7 && R7;
        return this.low(result);
    }

    public int performSubtractionW(int r1, int r2, int carry) {
        int result = r2 - r1 - carry;
        boolean Rd15 = this.bit_get(r1, 15);
        boolean Rr15 = this.bit_get(r2, 15);
        boolean R15 = this.bit_get(result, 15);
        this.C = !Rd15 && Rr15 || Rr15 && R15 || R15 && !Rd15;
        this.N = R15;
        this.Z = this.low(result) == 0 && this.high(result) == 0;
        this.V = Rd15 && !Rr15 && !R15 || !Rd15 && Rr15 && R15;
        return result;
    }

    public int performAnd(int r1, int r2) {
        int result = r1 & r2;
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = false;
        this.C = !this.N;
        return this.low(result);
    }

    public int performAndW(int r1, int r2) {
        int result = r1 & r2;
        this.N = this.bit_get(result, 15);
        this.C = !this.N;
        this.Z = result == 0;
        this.V = false;
        return result;
    }

    public int performDeciAddCW(int r1, int r2, int carry) {
        int reg1 = r1;
        int reg2 = r2;
        int result = 0;
        if (((result = this.bit_update(result, 15, ((reg1 = this.bit_update(reg1, 15, (reg1 & 0xF) + carry)) & 0xF) + (reg2 & 0xF))) & 0xF) > 10) {
            result = this.bit_update(result, 15, (result & 0xF) - 10);
            reg1 = this.bit_update(reg1, 240, (reg1 >> 4 & 0xF) + 1 << 4);
        }
        if (((result = this.bit_update(result, 240, (reg1 >> 4 & 0xF) + (reg2 >> 4 & 0xF) << 4)) >> 4 & 0xF) > 10) {
            result = this.bit_update(result, 240, (result >> 4 & 0xF) - 10 << 4);
            reg1 = this.bit_update(reg1, 3840, (reg1 >> 8 & 0xF) + 1 << 8);
        }
        if (((result = this.bit_update(result, 3840, (reg1 >> 8 & 0xF) + (reg2 >> 8 & 0xF) << 8)) >> 8 & 0xF) > 10) {
            result = this.bit_update(result, 3840, (result >> 8 & 0xF) - 10 << 8);
            reg1 = this.bit_update(reg1, 61440, (reg1 >> 12 & 0xF) + 1 << 12);
        }
        if (((result = this.bit_update(result, 61440, (reg1 >> 12 & 0xF) + (reg2 >> 12 & 0xF) << 12)) >> 12 & 0xF) > 10) {
            result = this.bit_update(result, 61440, (result >> 12 & 0xF) - 10 << 12);
            this.C = true;
        }
        this.N = this.bit_get(result, 15);
        this.Z = result == 0;
        return result;
    }

    public int performDeciAddC(int r1, int r2, int carry) {
        int reg1 = r1;
        int reg2 = r2;
        int result = 0;
        if (((result = this.bit_update(result, 15, ((reg1 = this.bit_update(reg1, 15, (reg1 & 0xF) + carry)) & 0xF) + (reg2 & 0xF))) & 0xF) > 10) {
            result = this.bit_update(result, 15, (result & 0xF) - 10);
            reg1 = this.bit_update(reg1, 240, (reg1 >> 4 & 0xF) + 1 << 4);
        }
        if (((result = this.bit_update(result, 240, (reg1 >> 4 & 0xF) + (reg2 >> 4 & 0xF) << 4)) >> 4 & 0xF) > 10) {
            result = this.bit_update(result, 240, (result >> 4 & 0xF) - 10 << 4);
            this.C = true;
        }
        this.N = this.bit_get(result, 7);
        this.Z = result == 0;
        return result & 0xFF;
    }

    public int low(int v) {
        return v << 24 >> 24;
    }

    public int high(int v) {
        return v >> 8 << 24 >> 24;
    }

    public int uword(int low, int high) {
        return (high << 8 | low & 0xFF) & 0xFFFF;
    }

    protected abstract int bit(boolean var1);

    protected abstract int popByte();

    protected abstract void pushByte(int var1);

    protected abstract void disableInterrupts();

    protected abstract void enableInterrupts();

    protected abstract int popWord();

    protected abstract void pushWord(int var1);

    protected abstract void bumpPC();

    public int $read_uint16(MSP430Operand.SREG _this) {
        return this.map_get(this.regs, _this.value.value);
    }

    public int $read_int8(MSP430Operand.SREG _this) {
        return this.map_get(this.regs, _this.value.value) << 24 >> 24;
    }

    public void $write_uint16(MSP430Operand.SREG _this, int value) {
        this.map_set(this.regs, _this.value.value, value);
    }

    public void $write_int8(MSP430Operand.SREG _this, int value) {
        int $tmp_0 = _this.value.value;
        int $tmp_1 = this.map_get(this.regs, $tmp_0);
        $tmp_1 = this.bit_update($tmp_1, 255, value);
        this.map_set(this.regs, $tmp_0, $tmp_1);
    }

    public int $read_int8(MSP430Operand.AIREG_B _this) {
        int addr = this.map_get(this.regs, _this.value.value);
        this.map_set(this.regs, _this.value.value, addr + 1);
        return this.map_get(this.data, addr);
    }

    public void $write_int8(MSP430Operand.AIREG_B _this, int value) {
    }

    public int $read_uint16(MSP430Operand.AIREG_W _this) {
        int addr = this.map_get(this.regs, _this.value.value);
        this.map_set(this.regs, _this.value.value, addr + 2);
        return this.get_word(addr);
    }

    public void $write_uint16(MSP430Operand.AIREG_W _this, int value) {
    }

    public int $read_int8(MSP430Operand.IREG _this) {
        int addr = this.map_get(this.regs, _this.value.value);
        return this.map_get(this.data, addr);
    }

    public int $read_uint16(MSP430Operand.IREG _this) {
        return this.get_word(this.map_get(this.regs, _this.value.value));
    }

    public void $write_int8(MSP430Operand.IREG _this, int value) {
    }

    public void $write_uint16(MSP430Operand.IREG _this, int value) {
    }

    public int $read_int8(MSP430Operand.IMM _this) {
        return _this.value << 24 >> 24;
    }

    public int $read_uint16(MSP430Operand.IMM _this) {
        return _this.value & 0xFFFF;
    }

    public void $write_int8(MSP430Operand.IMM _this, int value) {
    }

    public void $write_uint16(MSP430Operand.IMM _this, int value) {
    }

    public int $read_int8(MSP430Operand.IMML _this) {
        this.bumpPC();
        return _this.value << 24 >> 24;
    }

    public int $read_uint16(MSP430Operand.IMML _this) {
        this.bumpPC();
        return _this.value & 0xFFFF;
    }

    public void $write_int8(MSP430Operand.IMML _this, int value) {
    }

    public void $write_uint16(MSP430Operand.IMML _this, int value) {
    }

    public int $read_int8(MSP430Operand.INDX _this) {
        this.bumpPC();
        return this.map_get(this.data, this.$read_uint16(_this.reg) + this.$read_uint16(_this.index));
    }

    public int $read_uint16(MSP430Operand.INDX _this) {
        this.bumpPC();
        return this.get_word(this.$read_uint16(_this.reg) + this.$read_uint16(_this.index));
    }

    public void $write_int8(MSP430Operand.INDX _this, int value) {
        this.map_set(this.data, this.$read_uint16(_this.reg) + this.$read_uint16(_this.index), value);
    }

    public void $write_uint16(MSP430Operand.INDX _this, int value) {
        this.set_word(this.$read_uint16(_this.reg) + this.$read_uint16(_this.index), value);
    }

    public int $read_int8(MSP430Operand.SYMB _this) {
        this.bumpPC();
        return this.map_get(this.data, _this.value);
    }

    public int $read_uint16(MSP430Operand.SYMB _this) {
        this.bumpPC();
        return this.get_word(_this.value);
    }

    public void $write_int8(MSP430Operand.SYMB _this, int value) {
        this.map_set(this.data, _this.value, value);
    }

    public void $write_uint16(MSP430Operand.SYMB _this, int value) {
        this.set_word(_this.value, value);
    }

    public int $read_int8(MSP430Operand.ABSO _this) {
        this.bumpPC();
        return this.map_get(this.data, _this.value);
    }

    public int $read_uint16(MSP430Operand.ABSO _this) {
        this.bumpPC();
        return this.get_word(_this.value);
    }

    public void $write_int8(MSP430Operand.ABSO _this, int value) {
        this.map_set(this.data, _this.value, value);
    }

    public void $write_uint16(MSP430Operand.ABSO _this, int value) {
        this.set_word(_this.value, value);
    }

    public int $read_uint16(MSP430Operand.JUMP _this) {
        return _this.value & 0xFFFF;
    }

    public void visit(MSP430Instr.ADD i) {
        int r1 = this.$read_poly_uint16(i.source);
        int r2 = this.$read_poly_uint16(i.dest);
        int result = this.performAdditionW(r1, r2, 0);
        this.$write_poly_uint16(i.dest, result);
    }

    public void visit(MSP430Instr.ADD_B i) {
        int r1 = this.$read_poly_int8(i.source);
        int r2 = this.$read_poly_int8(i.dest);
        int result = this.performAddition(r1, r2, 0);
        this.$write_poly_int8(i.dest, result);
    }

    public void visit(MSP430Instr.ADDC i) {
        int r1 = this.$read_poly_uint16(i.source);
        int r2 = this.$read_poly_uint16(i.dest);
        int result = this.performAdditionW(r1, r2, this.bit(this.C));
        this.$write_poly_uint16(i.dest, result);
    }

    public void visit(MSP430Instr.ADDC_B i) {
        int r1 = this.$read_poly_int8(i.source);
        int r2 = this.$read_poly_int8(i.dest);
        int result = this.performAddition(r1, r2, this.bit(this.C));
        this.$write_poly_int8(i.dest, result);
    }

    public void visit(MSP430Instr.AND i) {
        int r1 = this.$read_poly_uint16(i.source);
        int r2 = this.$read_poly_uint16(i.dest);
        int result = this.performAndW(r1, r2);
        this.$write_poly_uint16(i.dest, result);
    }

    public void visit(MSP430Instr.AND_B i) {
        int r1 = this.$read_poly_int8(i.source);
        int r2 = this.$read_poly_int8(i.dest);
        int result = this.performAnd(r1, r2);
        this.$write_poly_int8(i.dest, result);
    }

    public void visit(MSP430Instr.BIC i) {
        this.$write_poly_uint16(i.dest, ~this.$read_poly_uint16(i.source) & this.$read_poly_uint16(i.dest));
    }

    public void visit(MSP430Instr.BIC_B i) {
        this.$write_poly_int8(i.dest, ~this.$read_poly_int8(i.source) & this.$read_poly_int8(i.dest));
    }

    public void visit(MSP430Instr.BIS i) {
        this.$write_poly_uint16(i.dest, this.$read_poly_uint16(i.source) | this.$read_poly_uint16(i.dest));
    }

    public void visit(MSP430Instr.BIS_B i) {
        this.$write_poly_int8(i.dest, this.$read_poly_int8(i.source) | this.$read_poly_int8(i.dest));
    }

    public void visit(MSP430Instr.BIT i) {
        this.performAndW(this.$read_poly_uint16(i.source), this.$read_poly_uint16(i.dest));
    }

    public void visit(MSP430Instr.BIT_B i) {
        this.performAndW(this.$read_poly_int8(i.source), this.$read_poly_int8(i.dest));
    }

    public void visit(MSP430Instr.CALL i) {
        int temp = this.$read_poly_uint16(i.source);
        this.pushWord(this.nextpc);
        this.nextpc = temp;
    }

    public void visit(MSP430Instr.CMP i) {
        this.performAdditionW(this.$read_poly_uint16(i.source), ~this.$read_poly_uint16(i.dest), 1);
    }

    public void visit(MSP430Instr.CMP_B i) {
        this.performAddition(this.$read_poly_int8(i.source), ~this.$read_poly_int8(i.dest), 1);
    }

    public void visit(MSP430Instr.DADD i) {
        this.$write_poly_uint16(i.dest, this.performDeciAddCW(this.$read_poly_uint16(i.source), this.$read_poly_uint16(i.dest), this.bit(this.C)));
    }

    public void visit(MSP430Instr.DADD_B i) {
        this.$write_poly_int8(i.dest, this.performDeciAddC(this.$read_poly_int8(i.source), this.$read_poly_int8(i.dest), this.bit(this.C)));
    }

    public void visit(MSP430Instr.JC i) {
        if (this.C) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JHS i) {
        if (this.C) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JEQ i) {
        if (this.Z) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JZ i) {
        if (this.Z) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JGE i) {
        if (this.Z != this.N) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JL i) {
        if (this.N != this.V) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JMP i) {
        this.nextpc = this.$read_uint16(i.target);
    }

    public void visit(MSP430Instr.JN i) {
        if (this.N) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JNC i) {
        if (!this.C) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JLO i) {
        if (!this.C) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JNE i) {
        if (!this.Z) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.JNZ i) {
        if (!this.Z) {
            this.nextpc = this.$read_uint16(i.target);
        }
    }

    public void visit(MSP430Instr.MOV i) {
        this.$write_poly_uint16(i.dest, this.$read_poly_uint16(i.source));
    }

    public void visit(MSP430Instr.MOV_B i) {
        this.$write_poly_int8(i.dest, this.$read_poly_int8(i.source));
    }

    public void visit(MSP430Instr.PUSH i) {
        this.pushWord(this.$read_poly_uint16(i.source));
    }

    public void visit(MSP430Instr.PUSH_B i) {
        this.pushByte(this.$read_poly_int8(i.source));
    }

    public void visit(MSP430Instr.RETI i) {
        this.sreg = this.popWord();
        this.nextpc = this.popWord();
    }

    public void visit(MSP430Instr.RRA i) {
        int temp = this.$read_poly_uint16(i.source);
        this.C = this.bit_get(temp, 0);
        this.N = this.bit_get(temp >>= 1, 15);
        this.Z = temp == 0;
        this.V = false;
        this.$write_poly_uint16(i.source, temp);
    }

    public void visit(MSP430Instr.RRA_B i) {
        int temp = this.$read_poly_int8(i.source);
        this.C = this.bit_get(temp, 0);
        this.N = this.bit_get(temp >>= 1, 7);
        this.Z = temp == 0;
        this.V = false;
        this.$write_poly_int8(i.source, temp);
    }

    public void visit(MSP430Instr.RRC i) {
        int temp = this.$read_poly_uint16(i.source);
        int oldC = this.bit(this.C);
        this.C = this.bit_get(temp, 0);
        temp = temp >> 1 | oldC << 15;
        this.N = this.bit_get(temp, 15);
        this.Z = temp == 0;
        this.V = !this.bit_get(temp, 14) && oldC == 1;
        this.$write_poly_uint16(i.source, temp);
    }

    public void visit(MSP430Instr.RRC_B i) {
        int temp = this.$read_poly_int8(i.source);
        int oldC = this.bit(this.C);
        this.C = this.bit_get(temp, 0);
        temp = temp >> 1 | oldC << 7;
        this.N = this.bit_get(temp, 7);
        this.Z = temp == 0;
        this.V = !this.bit_get(temp, 6) && oldC == 1;
        this.$write_poly_int8(i.source, temp);
    }

    public void visit(MSP430Instr.SUB i) {
        int r1 = this.$read_poly_uint16(i.source);
        int r2 = this.$read_poly_uint16(i.dest);
        int results = this.performSubtractionW(r1, r2, 0);
        this.$write_poly_uint16(i.dest, results & 0xFFFF);
    }

    public void visit(MSP430Instr.SUB_B i) {
        int r1 = this.$read_poly_int8(i.source);
        int r2 = this.$read_poly_int8(i.dest);
        int results = this.performSubtraction(r1, r2, 0);
        this.$write_poly_int8(i.dest, this.low(results));
    }

    public void visit(MSP430Instr.SUBC i) {
        int r1 = this.$read_poly_uint16(i.source);
        int r2 = this.$read_poly_uint16(i.dest);
        int results = this.performSubtractionW(r1, r2, this.bit(this.C));
        this.$write_poly_uint16(i.dest, results & 0xFFFF);
    }

    public void visit(MSP430Instr.SUBC_B i) {
        int r1 = this.$read_poly_int8(i.source);
        int r2 = this.$read_poly_int8(i.dest);
        int results = this.performSubtraction(r1, r2, this.bit(this.C));
        this.$write_poly_int8(i.dest, this.low(results));
    }

    public void visit(MSP430Instr.SWPB i) {
        int temp1;
        int temp2 = temp1 = this.$read_poly_uint16(i.source);
        temp2 = this.bit_update(temp2, 65280, temp1 << 8 & 0xFF00);
        temp2 = this.bit_update(temp2, 255, temp1 >> 8 & 0xFF);
        this.$write_poly_uint16(i.source, temp2);
    }

    public void visit(MSP430Instr.SXT i) {
        int r1 = this.$read_poly_uint16(i.source) << 24 >> 24;
        this.N = this.bit_get(r1, 15);
        this.Z = r1 == 0;
        this.C = !this.Z;
        this.V = false;
        this.$write_poly_uint16(i.source, r1);
    }

    public void visit(MSP430Instr.TST i) {
        int r1 = this.$read_poly_uint16(i.source);
        this.N = this.bit_get(r1, 15);
        this.Z = r1 == 0;
        this.C = true;
        this.V = false;
    }

    public void visit(MSP430Instr.TST_B i) {
        int r1 = this.$read_poly_int8(i.source);
        this.N = this.bit_get(r1, 7);
        this.Z = r1 == 0;
        this.C = true;
        this.V = false;
    }

    public void visit(MSP430Instr.XOR i) {
        int src = this.$read_poly_uint16(i.source);
        int res = this.$read_poly_uint16(i.dest);
        this.N = this.bit_get(res ^= src, 15);
        this.Z = res == 0;
        this.C = !this.Z;
        this.V = src < 0 && res < 0;
        this.$write_poly_uint16(i.dest, res & 0xFFFF);
    }

    public void visit(MSP430Instr.XOR_B i) {
        int src = this.$read_poly_int8(i.source);
        int res = this.$read_poly_int8(i.dest);
        this.N = this.bit_get(res ^= src, 7);
        this.Z = res == 0;
        this.C = !this.Z;
        this.V = src < 0 && res < 0;
        this.$write_poly_int8(i.dest, this.low(res));
    }
}

