/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.arch.msp430.MSP430AddrMode;
import avrora.arch.msp430.MSP430Instr;
import avrora.arch.msp430.MSP430InstrBuilder;
import avrora.arch.msp430.MSP430Operand;
import avrora.arch.msp430.MSP430Symbol;
import java.util.Arrays;

public class MSP430Disassembler
implements AbstractDisassembler {
    static final MSP430Symbol.GPR[] GPR_table = new MSP430Symbol.GPR[]{MSP430Symbol.GPR.R0, MSP430Symbol.GPR.R1, MSP430Symbol.GPR.R2, MSP430Symbol.GPR.R3, MSP430Symbol.GPR.R4, MSP430Symbol.GPR.R5, MSP430Symbol.GPR.R6, MSP430Symbol.GPR.R7, MSP430Symbol.GPR.R8, MSP430Symbol.GPR.R9, MSP430Symbol.GPR.R10, MSP430Symbol.GPR.R11, MSP430Symbol.GPR.R12, MSP430Symbol.GPR.R13, MSP430Symbol.GPR.R14, MSP430Symbol.GPR.R15};
    public static final DTErrorTerm ERROR = new DTErrorTerm();
    public static final DTLoop LOOP = new DTLoop();
    private int size;
    private MSP430InstrBuilder builder;
    private MSP430AddrMode addrMode;
    private int state;
    private int pc;
    private static final int MOVE = 0;
    private static final int OK = 1;
    private static final int ERR = -1;
    private int word0;
    private int word1;
    private int word2;
    int terminated;
    private static final DTNode addr0 = MSP430Disassembler.make_addr0();
    private static final DTNode instr0 = MSP430Disassembler.make_instr0();

    static int readop_0(MSP430Disassembler d) {
        int result = d.word1 & 0xFFFF;
        return result;
    }

    static int readop_1(MSP430Disassembler d) {
        int result = d.word0 & 0xF;
        return result;
    }

    static int readop_4(MSP430Disassembler d) {
        int result = d.word0 & 0x3FF;
        return result;
    }

    static int readop_3(MSP430Disassembler d) {
        int result = d.word0 >>> 8 & 0xF;
        return result;
    }

    static int readop_2(MSP430Disassembler d) {
        int result = d.word2 & 0xFFFF;
        return result;
    }

    private static int signExtend(int val, int size) {
        int shift = 32 - size;
        return val << shift >> shift;
    }

    static DTNode make_addr0() {
        DTTerminal T1 = new DTTerminal(new SetReader(new IMMABS_5_reader()));
        DTTerminal T2 = new DTTerminal(new SetReader(new IMMIND_5_reader()));
        DTTerminal T3 = new DTTerminal(new SetReader(new IMMSYM_5_reader()));
        DTArrayNode N4 = new DTArrayNode(null, 0, 15, new DTNode[]{T3, T2, T1, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2});
        DTTerminal T5 = new DTTerminal(new SetReader(new AUTOABS_B_0_reader()));
        DTTerminal T6 = new DTTerminal(new SetReader(new AUTOIND_B_0_reader()));
        DTTerminal T7 = new DTTerminal(new SetReader(new AUTOSYM_B_0_reader()));
        DTArrayNode N8 = new DTArrayNode(null, 0, 15, new DTNode[]{T7, T6, T5, T6, T6, T6, T6, T6, T6, T6, T6, T6, T6, T6, T6, T6});
        DTTerminal T9 = new DTTerminal(new SetReader(new IMMABS_0_reader()));
        DTTerminal T10 = new DTTerminal(new SetReader(new IMMIND_0_reader()));
        DTTerminal T11 = new DTTerminal(new SetReader(new IMMSYM_0_reader()));
        DTArrayNode N12 = new DTArrayNode(null, 0, 15, new DTNode[]{T11, T10, T9, T10, T10, T10, T10, T10, T10, T10, T10, T10, T10, T10, T10, T10});
        DTTerminal T13 = new DTTerminal(new SetReader(new IMMLABS_0_reader()));
        DTTerminal T14 = new DTTerminal(new SetReader(new IMMLIND_0_reader()));
        DTTerminal T15 = new DTTerminal(new SetReader(new IMMLSYM_0_reader()));
        DTArrayNode N16 = new DTArrayNode(null, 0, 15, new DTNode[]{T15, T14, T13, T14, T14, T14, T14, T14, T14, T14, T14, T14, T14, T14, T14, T14});
        DTArrayNode N17 = new DTArrayNode(null, 8, 15, new DTNode[]{N16, N8, N4, N12, N8, N8, N8, N8, N8, N8, N8, N8, N8, N8, N8, N8});
        DTTerminal T18 = new DTTerminal(new SetReader(new REGREG_0_reader()));
        DTTerminal T19 = new DTTerminal(new SetReader(new IMMREG_1_reader()));
        DTArrayNode N20 = new DTArrayNode(null, 8, 15, new DTNode[]{T18, T18, T18, T19, T18, T18, T18, T18, T18, T18, T18, T18, T18, T18, T18, T18});
        DTTerminal T21 = new DTTerminal(new SetReader(new REGABS_0_reader()));
        DTTerminal T22 = new DTTerminal(new SetReader(new IMMABS_1_reader()));
        DTArrayNode N23 = new DTArrayNode(null, 8, 15, new DTNode[]{T21, T21, T21, T22, T21, T21, T21, T21, T21, T21, T21, T21, T21, T21, T21, T21});
        DTTerminal T24 = new DTTerminal(new SetReader(new REGIND_0_reader()));
        DTTerminal T25 = new DTTerminal(new SetReader(new IMMIND_1_reader()));
        DTArrayNode N26 = new DTArrayNode(null, 8, 15, new DTNode[]{T24, T24, T24, T25, T24, T24, T24, T24, T24, T24, T24, T24, T24, T24, T24, T24});
        DTTerminal T27 = new DTTerminal(new SetReader(new REGSYM_0_reader()));
        DTTerminal T28 = new DTTerminal(new SetReader(new IMMSYM_1_reader()));
        DTArrayNode N29 = new DTArrayNode(null, 8, 15, new DTNode[]{T27, T27, T27, T28, T27, T27, T27, T27, T27, T27, T27, T27, T27, T27, T27, T27});
        DTArrayNode N30 = new DTArrayNode(null, 0, 15, new DTNode[]{N29, N26, N23, N26, N26, N26, N26, N26, N26, N26, N26, N26, N26, N26, N26, N26});
        DTTerminal T31 = new DTTerminal(new SetReader(new AUTOABS_W_0_reader()));
        DTTerminal T32 = new DTTerminal(new SetReader(new AUTOIND_W_0_reader()));
        DTTerminal T33 = new DTTerminal(new SetReader(new AUTOSYM_W_0_reader()));
        DTArrayNode N34 = new DTArrayNode(null, 0, 15, new DTNode[]{T33, T32, T31, T32, T32, T32, T32, T32, T32, T32, T32, T32, T32, T32, T32, T32});
        DTArrayNode N35 = new DTArrayNode(null, 8, 15, new DTNode[]{N16, N34, N4, N12, N34, N34, N34, N34, N34, N34, N34, N34, N34, N34, N34, N34});
        DTTerminal T36 = new DTTerminal(new SetReader(new IMMREG_5_reader()));
        DTTerminal T37 = new DTTerminal(new SetReader(new AUTOREG_W_0_reader()));
        DTTerminal T38 = new DTTerminal(new SetReader(new IMMREG_0_reader()));
        DTTerminal T39 = new DTTerminal(new SetReader(new IMMLREG_0_reader()));
        DTArrayNode N40 = new DTArrayNode(null, 8, 15, new DTNode[]{T39, T37, T36, T38, T37, T37, T37, T37, T37, T37, T37, T37, T37, T37, T37, T37});
        DTTerminal T41 = new DTTerminal(new SetReader(new AUTOREG_B_0_reader()));
        DTArrayNode N42 = new DTArrayNode(null, 8, 15, new DTNode[]{T39, T41, T36, T38, T41, T41, T41, T41, T41, T41, T41, T41, T41, T41, T41, T41});
        DTTerminal T43 = new DTTerminal(new SetReader(new IMMREG_4_reader()));
        DTTerminal T44 = new DTTerminal(new SetReader(new IREGREG_0_reader()));
        DTTerminal T45 = new DTTerminal(new SetReader(new IMMREG_3_reader()));
        DTArrayNode N46 = new DTArrayNode(null, 8, 15, new DTNode[]{T44, T44, T43, T45, T44, T44, T44, T44, T44, T44, T44, T44, T44, T44, T44, T44});
        DTTerminal T47 = new DTTerminal(new SetReader(new ABSABS_0_reader()));
        DTTerminal T48 = new DTTerminal(new SetReader(new ABSIND_0_reader()));
        DTTerminal T49 = new DTTerminal(new SetReader(new ABSSYM_0_reader()));
        DTArrayNode N50 = new DTArrayNode(null, 0, 15, new DTNode[]{T49, T48, T47, T48, T48, T48, T48, T48, T48, T48, T48, T48, T48, T48, T48, T48});
        DTTerminal T51 = new DTTerminal(new SetReader(new INDABS_0_reader()));
        DTTerminal T52 = new DTTerminal(new SetReader(new INDIND_0_reader()));
        DTTerminal T53 = new DTTerminal(new SetReader(new INDSYM_0_reader()));
        DTArrayNode N54 = new DTArrayNode(null, 0, 15, new DTNode[]{T53, T52, T51, T52, T52, T52, T52, T52, T52, T52, T52, T52, T52, T52, T52, T52});
        DTTerminal T55 = new DTTerminal(new SetReader(new IMMABS_2_reader()));
        DTTerminal T56 = new DTTerminal(new SetReader(new IMMIND_2_reader()));
        DTTerminal T57 = new DTTerminal(new SetReader(new IMMSYM_2_reader()));
        DTArrayNode N58 = new DTArrayNode(null, 0, 15, new DTNode[]{T57, T56, T55, T56, T56, T56, T56, T56, T56, T56, T56, T56, T56, T56, T56, T56});
        DTTerminal T59 = new DTTerminal(new SetReader(new SYMABS_0_reader()));
        DTTerminal T60 = new DTTerminal(new SetReader(new SYMIND_0_reader()));
        DTTerminal T61 = new DTTerminal(new SetReader(new SYMSYM_0_reader()));
        DTArrayNode N62 = new DTArrayNode(null, 0, 15, new DTNode[]{T61, T60, T59, T60, T60, T60, T60, T60, T60, T60, T60, T60, T60, T60, T60, T60});
        DTArrayNode N63 = new DTArrayNode(null, 8, 15, new DTNode[]{N62, N54, N50, N58, N54, N54, N54, N54, N54, N54, N54, N54, N54, N54, N54, N54});
        DTTerminal T64 = new DTTerminal(new SetReader(new ABSREG_0_reader()));
        DTTerminal T65 = new DTTerminal(new SetReader(new INDREG_0_reader()));
        DTTerminal T66 = new DTTerminal(new SetReader(new IMMREG_2_reader()));
        DTTerminal T67 = new DTTerminal(new SetReader(new SYMREG_0_reader()));
        DTArrayNode N68 = new DTArrayNode(null, 8, 15, new DTNode[]{T67, T65, T64, T66, T65, T65, T65, T65, T65, T65, T65, T65, T65, T65, T65, T65});
        DTTerminal T69 = new DTTerminal(new SetReader(new IMMABS_4_reader()));
        DTTerminal T70 = new DTTerminal(new SetReader(new IMMIND_4_reader()));
        DTTerminal T71 = new DTTerminal(new SetReader(new IMMSYM_4_reader()));
        DTArrayNode N72 = new DTArrayNode(null, 0, 15, new DTNode[]{T71, T70, T69, T70, T70, T70, T70, T70, T70, T70, T70, T70, T70, T70, T70, T70});
        DTTerminal T73 = new DTTerminal(new SetReader(new IREGABS_0_reader()));
        DTTerminal T74 = new DTTerminal(new SetReader(new IREGIND_0_reader()));
        DTTerminal T75 = new DTTerminal(new SetReader(new IREGSYM_0_reader()));
        DTArrayNode N76 = new DTArrayNode(null, 0, 15, new DTNode[]{T75, T74, T73, T74, T74, T74, T74, T74, T74, T74, T74, T74, T74, T74, T74, T74});
        DTTerminal T77 = new DTTerminal(new SetReader(new IMMABS_3_reader()));
        DTTerminal T78 = new DTTerminal(new SetReader(new IMMIND_3_reader()));
        DTTerminal T79 = new DTTerminal(new SetReader(new IMMSYM_3_reader()));
        DTArrayNode N80 = new DTArrayNode(null, 0, 15, new DTNode[]{T79, T78, T77, T78, T78, T78, T78, T78, T78, T78, T78, T78, T78, T78, T78, T78});
        DTArrayNode N81 = new DTArrayNode(null, 8, 15, new DTNode[]{N76, N76, N72, N80, N76, N76, N76, N76, N76, N76, N76, N76, N76, N76, N76, N76});
        DTArrayNode N82 = new DTArrayNode(null, 4, 15, new DTNode[]{N20, N68, N46, N40, N20, N68, N46, N42, N30, N63, N81, N35, N30, N63, N81, N17});
        DTTerminal T83 = new DTTerminal(null);
        DTArrayNode N84 = new DTArrayNode(new SetReader(new JMP_0_reader()), 10, 3, new DTNode[]{T83, T83, T83, T83});
        DTTerminal T85 = new DTTerminal(new SetReader(new REG_0_reader()));
        DTTerminal T86 = new DTTerminal(new SetReader(new IMM_1_reader()));
        DTArrayNode N87 = new DTArrayNode(null, 0, 15, new DTNode[]{T85, T85, T85, T86, T85, T85, T85, T85, T85, T85, T85, T85, T85, T85, T85, T85});
        DTTerminal T88 = new DTTerminal(new SetReader(new IMM_5_reader()));
        DTTerminal T89 = new DTTerminal(new SetReader(new AUTO_B_0_reader()));
        DTTerminal T90 = new DTTerminal(new SetReader(new IMM_0_reader()));
        DTTerminal T91 = new DTTerminal(new SetReader(new IMML_0_reader()));
        DTArrayNode N92 = new DTArrayNode(null, 0, 15, new DTNode[]{T91, T89, T88, T90, T89, T89, T89, T89, T89, T89, T89, T89, T89, T89, T89, T89});
        DTTerminal T93 = new DTTerminal(new SetReader(new AUTO_W_0_reader()));
        DTArrayNode N94 = new DTArrayNode(null, 0, 15, new DTNode[]{T91, T93, T88, T90, T93, T93, T93, T93, T93, T93, T93, T93, T93, T93, T93, T93});
        DTTerminal T95 = new DTTerminal(null);
        DTArrayNode N96 = new DTArrayNode(new SetReader(new NULL_reader(2)), 0, 15, new DTNode[]{T95, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR, ERROR});
        DTTerminal T97 = new DTTerminal(new SetReader(new IMM_4_reader()));
        DTTerminal T98 = new DTTerminal(new SetReader(new IREG_0_reader()));
        DTTerminal T99 = new DTTerminal(new SetReader(new IMM_3_reader()));
        DTArrayNode N100 = new DTArrayNode(null, 0, 15, new DTNode[]{T98, T98, T97, T99, T98, T98, T98, T98, T98, T98, T98, T98, T98, T98, T98, T98});
        DTTerminal T101 = new DTTerminal(new SetReader(new ABS_0_reader()));
        DTTerminal T102 = new DTTerminal(new SetReader(new IND_0_reader()));
        DTTerminal T103 = new DTTerminal(new SetReader(new IMM_2_reader()));
        DTTerminal T104 = new DTTerminal(new SetReader(new SYM_0_reader()));
        DTArrayNode N105 = new DTArrayNode(null, 0, 15, new DTNode[]{T104, T102, T101, T103, T102, T102, T102, T102, T102, T102, T102, T102, T102, T102, T102, T102});
        DTSortedNode N106 = new DTSortedNode(null, 4, 255, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 48}, new DTNode[]{N87, N105, N100, N94, N87, N105, N100, N92, N87, N105, N100, N94, N87, N105, N100, N94, N87, N105, N100, N92, N87, N105, N100, N94, N87, N105, N100, N94, N87, N105, N100, N92, N87, N105, N100, N94, N96}, ERROR);
        DTSortedNode N107 = new DTSortedNode(null, 4, 255, new int[]{72, 73, 74, 75, 76, 77, 78, 79}, new DTNode[]{N87, N105, N100, N94, N87, N105, N100, N92}, ERROR);
        DTArrayNode N0 = new DTArrayNode(null, 12, 15, new DTNode[]{N107, N106, N84, N84, N82, N82, N82, N82, N82, N82, N82, N82, N82, N82, N82, N82});
        return N0;
    }

    static DTNode make_instr0() {
        DTTerminal T1 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.AND_B));
        DTTerminal T2 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.AND));
        DTArrayNode N3 = new DTArrayNode(null, 4, 15, new DTNode[]{T2, T2, T2, T2, T1, T1, T1, T1, T2, T2, T2, T2, T1, T1, T1, T1});
        DTTerminal T4 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.MOV_B));
        DTTerminal T5 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.MOV));
        DTArrayNode N6 = new DTArrayNode(null, 4, 15, new DTNode[]{T5, T5, T5, T5, T4, T4, T4, T4, T5, T5, T5, T5, T4, T4, T4, T4});
        DTTerminal T7 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SUB_B));
        DTTerminal T8 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SUB));
        DTArrayNode N9 = new DTArrayNode(null, 4, 15, new DTNode[]{T8, T8, T8, T8, T7, T7, T7, T7, T8, T8, T8, T8, T7, T7, T7, T7});
        DTTerminal T10 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIT_B));
        DTTerminal T11 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIT));
        DTArrayNode N12 = new DTArrayNode(null, 4, 15, new DTNode[]{T11, T11, T11, T11, T10, T10, T10, T10, T11, T11, T11, T11, T10, T10, T10, T10});
        DTTerminal T13 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JL));
        DTTerminal T14 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JGE));
        DTTerminal T15 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JMP));
        DTTerminal T16 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JN));
        DTArrayNode N17 = new DTArrayNode(null, 10, 3, new DTNode[]{T16, T14, T13, T15});
        DTTerminal T18 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SUBC_B));
        DTTerminal T19 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SUBC));
        DTArrayNode N20 = new DTArrayNode(null, 4, 15, new DTNode[]{T19, T19, T19, T19, T18, T18, T18, T18, T19, T19, T19, T19, T18, T18, T18, T18});
        DTTerminal T21 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIC_B));
        DTTerminal T22 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIC));
        DTArrayNode N23 = new DTArrayNode(null, 4, 15, new DTNode[]{T22, T22, T22, T22, T21, T21, T21, T21, T22, T22, T22, T22, T21, T21, T21, T21});
        DTTerminal T24 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JNC));
        DTTerminal T25 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JZ));
        DTTerminal T26 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JC));
        DTTerminal T27 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.JNZ));
        DTArrayNode N28 = new DTArrayNode(null, 10, 3, new DTNode[]{T27, T25, T24, T26});
        DTTerminal T29 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIS_B));
        DTTerminal T30 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.BIS));
        DTArrayNode N31 = new DTArrayNode(null, 4, 15, new DTNode[]{T30, T30, T30, T30, T29, T29, T29, T29, T30, T30, T30, T30, T29, T29, T29, T29});
        DTTerminal T32 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.CMP_B));
        DTTerminal T33 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.CMP));
        DTArrayNode N34 = new DTArrayNode(null, 4, 15, new DTNode[]{T33, T33, T33, T33, T32, T32, T32, T32, T33, T33, T33, T33, T32, T32, T32, T32});
        DTTerminal T35 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.ADDC_B));
        DTTerminal T36 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.ADDC));
        DTArrayNode N37 = new DTArrayNode(null, 4, 15, new DTNode[]{T36, T36, T36, T36, T35, T35, T35, T35, T36, T36, T36, T36, T35, T35, T35, T35});
        DTTerminal T38 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SWPB));
        DTTerminal T39 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.CALL));
        DTTerminal T40 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.RRA_B));
        DTTerminal T41 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.RRA));
        DTTerminal T42 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.RETI));
        DTTerminal T43 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.PUSH));
        DTTerminal T44 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.RRC_B));
        DTTerminal T45 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.RRC));
        DTTerminal T46 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.SXT));
        DTTerminal T47 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.PUSH_B));
        DTSortedNode N48 = new DTSortedNode(null, 4, 255, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 48}, new DTNode[]{T45, T45, T45, T45, T44, T44, T44, T44, T38, T38, T38, T38, T41, T41, T41, T41, T40, T40, T40, T40, T46, T46, T46, T46, T43, T43, T43, T43, T47, T47, T47, T47, T39, T39, T39, T39, T42}, ERROR);
        DTTerminal T49 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.XOR_B));
        DTTerminal T50 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.XOR));
        DTArrayNode N51 = new DTArrayNode(null, 4, 15, new DTNode[]{T50, T50, T50, T50, T49, T49, T49, T49, T50, T50, T50, T50, T49, T49, T49, T49});
        DTTerminal T52 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.DADD_B));
        DTTerminal T53 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.DADD));
        DTArrayNode N54 = new DTArrayNode(null, 4, 15, new DTNode[]{T53, T53, T53, T53, T52, T52, T52, T52, T53, T53, T53, T53, T52, T52, T52, T52});
        DTTerminal T55 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.ADD_B));
        DTTerminal T56 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.ADD));
        DTArrayNode N57 = new DTArrayNode(null, 4, 15, new DTNode[]{T56, T56, T56, T56, T55, T55, T55, T55, T56, T56, T56, T56, T55, T55, T55, T55});
        DTTerminal T58 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.TST));
        DTTerminal T59 = new DTTerminal(new SetBuilder(MSP430InstrBuilder.TST_B));
        DTSortedNode N60 = new DTSortedNode(null, 4, 255, new int[]{72, 73, 74, 75, 76, 77, 78, 79}, new DTNode[]{T58, T58, T58, T58, T59, T59, T59, T59}, ERROR);
        DTArrayNode N0 = new DTArrayNode(null, 12, 15, new DTNode[]{N60, N48, N28, N17, N6, N57, N37, N20, N9, N34, N54, N12, N23, N31, N51, N3});
        return N0;
    }

    public AbstractInstr disassemble(int base, int index, byte[] code) {
        return this.decode(base, index, code);
    }

    public MSP430Instr decode(int base, int index, byte[] code) {
        this.word0 = this.word(code, index);
        this.word1 = this.word(code, index + 2);
        this.word2 = this.word(code, index + 4);
        this.pc = base + index;
        return this.decode_root();
    }

    int word(byte[] code, int index) {
        if (index > code.length - 2) {
            return 0;
        }
        return code[index] & 0xFF | code[index + 1] << 8;
    }

    public MSP430Instr decode(int base, int index, char[] code) {
        this.word0 = this.word(code, index);
        this.word1 = this.word(code, index + 1);
        this.word2 = this.word(code, index + 2);
        this.pc = base + index * 2;
        return this.decode_root();
    }

    int word(char[] code, int index) {
        if (index > code.length - 1) {
            return 0;
        }
        return code[index];
    }

    public MSP430Instr decode(int base, int index, short[] code) {
        this.word0 = this.word(code, index);
        this.word1 = this.word(code, index + 1);
        this.word2 = this.word(code, index + 2);
        this.pc = base + index * 2;
        return this.decode_root();
    }

    int word(short[] code, int index) {
        if (index > code.length - 1) {
            return 0;
        }
        return code[index];
    }

    MSP430Instr decode_root() {
        this.size = 0;
        this.builder = null;
        this.addrMode = null;
        return this.run_decoder(addr0, instr0);
    }

    MSP430Instr run_decoder(DTNode addr, DTNode instr) {
        this.state = 0;
        this.terminated = 0;
        while (this.state == 0) {
            int bits = this.word0 >> addr.left_bit & addr.mask;
            addr = addr.move(this, bits);
            instr = instr.move(this, bits);
        }
        if (this.state == -1) {
            return null;
        }
        return this.builder.build(this.size, this.addrMode);
    }

    static abstract class OperandReader {
        OperandReader() {
        }

        abstract MSP430AddrMode read(MSP430Disassembler var1);
    }

    static class DTTerminal
    extends DTNode {
        DTTerminal(Action a) {
            super(a, 0, 0);
        }

        DTNode move(MSP430Disassembler d, int bits) {
            ++d.terminated;
            if (this.action != null) {
                this.action.execute(d);
            }
            return LOOP;
        }
    }

    static class DTLoop
    extends DTNode {
        DTLoop() {
            super(null, 0, 0);
        }

        DTNode move(MSP430Disassembler d, int bits) {
            if (d.terminated >= 2) {
                d.state = 1;
            }
            return this;
        }
    }

    static class SetReader
    extends Action {
        OperandReader reader;

        SetReader(OperandReader r) {
            this.reader = r;
        }

        void execute(MSP430Disassembler d) {
            d.addrMode = this.reader.read(d);
        }
    }

    static class SetBuilder
    extends Action {
        MSP430InstrBuilder builder;

        SetBuilder(MSP430InstrBuilder b) {
            this.builder = b;
        }

        void execute(MSP430Disassembler d) {
            d.builder = this.builder;
        }
    }

    static class ErrorAction
    extends Action {
        ErrorAction() {
        }

        void execute(MSP430Disassembler d) {
            d.state = -1;
        }
    }

    static abstract class Action {
        Action() {
        }

        abstract void execute(MSP430Disassembler var1);
    }

    static class DTErrorTerm
    extends DTNode {
        DTErrorTerm() {
            super(null, 0, 0);
        }

        DTNode move(MSP430Disassembler d, int bits) {
            d.state = -1;
            return this;
        }
    }

    static class DTSortedNode
    extends DTNode {
        final DTNode def;
        final DTNode[] nodes;
        final int[] values;

        DTSortedNode(Action a, int lb, int msk, int[] v, DTNode[] n, DTNode d) {
            super(a, lb, msk);
            this.values = v;
            this.nodes = n;
            this.def = d;
        }

        DTNode move(MSP430Disassembler d, int val) {
            int ind;
            if (this.action != null) {
                this.action.execute(d);
            }
            if ((ind = Arrays.binarySearch(this.values, val)) >= 0 && ind < this.values.length && this.values[ind] == val) {
                return this.nodes[ind];
            }
            return this.def;
        }
    }

    static class DTArrayNode
    extends DTNode {
        final DTNode[] nodes;

        DTArrayNode(Action a, int lb, int msk, DTNode[] n) {
            super(a, lb, msk);
            this.nodes = n;
        }

        DTNode move(MSP430Disassembler d, int val) {
            if (this.action != null) {
                this.action.execute(d);
            }
            return this.nodes[val];
        }
    }

    static abstract class DTNode {
        final int left_bit;
        final int mask;
        final Action action;

        DTNode(Action a, int lb, int msk) {
            this.action = a;
            this.left_bit = lb;
            this.mask = msk;
        }

        abstract DTNode move(MSP430Disassembler var1, int var2);
    }

    static class IMMREG_0_reader
    extends OperandReader {
        IMMREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(-1);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class IMMSYM_4_reader
    extends OperandReader {
        IMMSYM_4_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(4);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class SYMREG_0_reader
    extends OperandReader {
        SYMREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SYMB source = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.SYMREG(source, dest);
        }
    }

    static class IMMREG_5_reader
    extends OperandReader {
        IMMREG_5_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(8);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class IMML_0_reader
    extends OperandReader {
        IMML_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMML source = new MSP430Operand.IMML(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMML(source);
        }
    }

    static class IMMABS_0_reader
    extends OperandReader {
        IMMABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(-1);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class ABSREG_0_reader
    extends OperandReader {
        ABSREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.ABSO source = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.ABSREG(source, dest);
        }
    }

    static class IMMSYM_1_reader
    extends OperandReader {
        IMMSYM_1_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(0);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class SYM_0_reader
    extends OperandReader {
        SYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SYMB source = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.SYM(source);
        }
    }

    static class IMM_4_reader
    extends OperandReader {
        IMM_4_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(4);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class JMP_0_reader
    extends OperandReader {
        JMP_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.JUMP target = new MSP430Operand.JUMP(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_4(d), 10));
            return new MSP430AddrMode.JMP(target);
        }
    }

    static class IMMABS_4_reader
    extends OperandReader {
        IMMABS_4_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(4);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class ABSIND_0_reader
    extends OperandReader {
        ABSIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.ABSO source = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.ABSIND(source, dest);
        }
    }

    static class AUTO_W_0_reader
    extends OperandReader {
        AUTO_W_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.AIREG_W source = new MSP430Operand.AIREG_W(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.AUTO_W(source);
        }
    }

    static class IREGSYM_0_reader
    extends OperandReader {
        IREGSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IREG source = new MSP430Operand.IREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IREGSYM(source, dest);
        }
    }

    static class AUTO_B_0_reader
    extends OperandReader {
        AUTO_B_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.AIREG_B source = new MSP430Operand.AIREG_B(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.AUTO_B(source);
        }
    }

    static class IMMIND_2_reader
    extends OperandReader {
        IMMIND_2_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(1);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class IMMLSYM_0_reader
    extends OperandReader {
        IMMLSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.IMML source = new MSP430Operand.IMML(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.IMMLSYM(source, dest);
        }
    }

    static class INDABS_0_reader
    extends OperandReader {
        INDABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SREG source_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.IMM source_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX source = new MSP430Operand.INDX(source_reg, source_index);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.INDABS(source, dest);
        }
    }

    static class IMMABS_2_reader
    extends OperandReader {
        IMMABS_2_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(1);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class IMM_0_reader
    extends OperandReader {
        IMM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(-1);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class IMMSYM_3_reader
    extends OperandReader {
        IMMSYM_3_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(2);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class ABSABS_0_reader
    extends OperandReader {
        ABSABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.ABSO source = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.ABSABS(source, dest);
        }
    }

    static class IND_0_reader
    extends OperandReader {
        IND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SREG source_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM source_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX source = new MSP430Operand.INDX(source_reg, source_index);
            return new MSP430AddrMode.IND(source);
        }
    }

    static class AUTOSYM_W_0_reader
    extends OperandReader {
        AUTOSYM_W_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_W source = new MSP430Operand.AIREG_W(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.AUTOSYM_W(source, dest);
        }
    }

    static class IMMREG_2_reader
    extends OperandReader {
        IMMREG_2_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(1);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class IMMIND_5_reader
    extends OperandReader {
        IMMIND_5_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(8);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class AUTOREG_B_0_reader
    extends OperandReader {
        AUTOREG_B_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.AIREG_B source = new MSP430Operand.AIREG_B(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.AUTOREG_B(source, dest);
        }
    }

    static class IMMREG_3_reader
    extends OperandReader {
        IMMREG_3_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(2);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class INDREG_0_reader
    extends OperandReader {
        INDREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SREG source_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.IMM source_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX source = new MSP430Operand.INDX(source_reg, source_index);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.INDREG(source, dest);
        }
    }

    static class IMMIND_4_reader
    extends OperandReader {
        IMMIND_4_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(4);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class IREGABS_0_reader
    extends OperandReader {
        IREGABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IREG source = new MSP430Operand.IREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IREGABS(source, dest);
        }
    }

    static class IMMLABS_0_reader
    extends OperandReader {
        IMMLABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.IMML source = new MSP430Operand.IMML(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.IMMLABS(source, dest);
        }
    }

    static class IMMREG_4_reader
    extends OperandReader {
        IMMREG_4_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(4);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class AUTOIND_W_0_reader
    extends OperandReader {
        AUTOIND_W_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_W source = new MSP430Operand.AIREG_W(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.AUTOIND_W(source, dest);
        }
    }

    static class IMMABS_5_reader
    extends OperandReader {
        IMMABS_5_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(8);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class IREGREG_0_reader
    extends OperandReader {
        IREGREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IREG source = new MSP430Operand.IREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IREGREG(source, dest);
        }
    }

    static class IMM_2_reader
    extends OperandReader {
        IMM_2_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(1);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class REGIND_0_reader
    extends OperandReader {
        REGIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SREG source = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.REGIND(source, dest);
        }
    }

    static class IMM_5_reader
    extends OperandReader {
        IMM_5_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(8);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class IMMSYM_0_reader
    extends OperandReader {
        IMMSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(-1);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class AUTOIND_B_0_reader
    extends OperandReader {
        AUTOIND_B_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_B source = new MSP430Operand.AIREG_B(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.AUTOIND_B(source, dest);
        }
    }

    static class INDIND_0_reader
    extends OperandReader {
        INDIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SREG source_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.IMM source_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX source = new MSP430Operand.INDX(source_reg, source_index);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.INDIND(source, dest);
        }
    }

    static class SYMABS_0_reader
    extends OperandReader {
        SYMABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SYMB source = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.SYMABS(source, dest);
        }
    }

    static class REGREG_0_reader
    extends OperandReader {
        REGREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.SREG source = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.REGREG(source, dest);
        }
    }

    static class IMMIND_3_reader
    extends OperandReader {
        IMMIND_3_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(2);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class REGABS_0_reader
    extends OperandReader {
        REGABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SREG source = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.REGABS(source, dest);
        }
    }

    static class AUTOSYM_B_0_reader
    extends OperandReader {
        AUTOSYM_B_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_B source = new MSP430Operand.AIREG_B(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.AUTOSYM_B(source, dest);
        }
    }

    static class IMMSYM_5_reader
    extends OperandReader {
        IMMSYM_5_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(8);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class REGSYM_0_reader
    extends OperandReader {
        REGSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.SREG source = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.REGSYM(source, dest);
        }
    }

    static class IREGIND_0_reader
    extends OperandReader {
        IREGIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IREG source = new MSP430Operand.IREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IREGIND(source, dest);
        }
    }

    static class IMMSYM_2_reader
    extends OperandReader {
        IMMSYM_2_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(1);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMSYM(source, dest);
        }
    }

    static class REG_0_reader
    extends OperandReader {
        REG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.SREG source = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.REG(source);
        }
    }

    static class IREG_0_reader
    extends OperandReader {
        IREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IREG source = new MSP430Operand.IREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IREG(source);
        }
    }

    static class IMMLIND_0_reader
    extends OperandReader {
        IMMLIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.IMML source = new MSP430Operand.IMML(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMLIND(source, dest);
        }
    }

    static class IMM_3_reader
    extends OperandReader {
        IMM_3_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(2);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class IMMIND_0_reader
    extends OperandReader {
        IMMIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(-1);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class INDSYM_0_reader
    extends OperandReader {
        INDSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SREG source_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.IMM source_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX source = new MSP430Operand.INDX(source_reg, source_index);
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.INDSYM(source, dest);
        }
    }

    static class IMMLREG_0_reader
    extends OperandReader {
        IMMLREG_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMML source = new MSP430Operand.IMML(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMLREG(source, dest);
        }
    }

    static class ABSSYM_0_reader
    extends OperandReader {
        ABSSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.ABSO source = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.ABSSYM(source, dest);
        }
    }

    static class AUTOABS_B_0_reader
    extends OperandReader {
        AUTOABS_B_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_B source = new MSP430Operand.AIREG_B(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.AUTOABS_B(source, dest);
        }
    }

    static class AUTOREG_W_0_reader
    extends OperandReader {
        AUTOREG_W_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.AIREG_W source = new MSP430Operand.AIREG_W(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.AUTOREG_W(source, dest);
        }
    }

    static class IMMABS_3_reader
    extends OperandReader {
        IMMABS_3_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(2);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class ABS_0_reader
    extends OperandReader {
        ABS_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.ABSO source = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.ABS(source);
        }
    }

    static class IMM_1_reader
    extends OperandReader {
        IMM_1_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(0);
            return new MSP430AddrMode.IMM(source);
        }
    }

    static class SYMSYM_0_reader
    extends OperandReader {
        SYMSYM_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SYMB source = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SYMB dest = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            return new MSP430AddrMode.SYMSYM(source, dest);
        }
    }

    static class AUTOABS_W_0_reader
    extends OperandReader {
        AUTOABS_W_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.AIREG_W source = new MSP430Operand.AIREG_W(GPR_table[MSP430Disassembler.readop_3(d)]);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.AUTOABS_W(source, dest);
        }
    }

    static class IMMREG_1_reader
    extends OperandReader {
        IMMREG_1_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 2;
            MSP430Operand.IMM source = new MSP430Operand.IMM(0);
            MSP430Operand.SREG dest = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            return new MSP430AddrMode.IMMREG(source, dest);
        }
    }

    static class IMMABS_1_reader
    extends OperandReader {
        IMMABS_1_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(0);
            MSP430Operand.ABSO dest = new MSP430Operand.ABSO(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            return new MSP430AddrMode.IMMABS(source, dest);
        }
    }

    static class IMMIND_1_reader
    extends OperandReader {
        IMMIND_1_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 4;
            MSP430Operand.IMM source = new MSP430Operand.IMM(0);
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.IMMIND(source, dest);
        }
    }

    static class SYMIND_0_reader
    extends OperandReader {
        SYMIND_0_reader() {
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = 6;
            MSP430Operand.SYMB source = new MSP430Operand.SYMB(d.pc, MSP430Disassembler.signExtend(MSP430Disassembler.readop_0(d), 16));
            MSP430Operand.SREG dest_reg = new MSP430Operand.SREG(GPR_table[MSP430Disassembler.readop_1(d)]);
            MSP430Operand.IMM dest_index = new MSP430Operand.IMM(MSP430Disassembler.signExtend(MSP430Disassembler.readop_2(d), 16));
            MSP430Operand.INDX dest = new MSP430Operand.INDX(dest_reg, dest_index);
            return new MSP430AddrMode.SYMIND(source, dest);
        }
    }

    public static class NULL_reader
    extends OperandReader {
        final int size;

        NULL_reader(int sz) {
            this.size = sz;
        }

        MSP430AddrMode read(MSP430Disassembler d) {
            d.size = this.size;
            return null;
        }
    }

    public static class InvalidInstruction
    extends Exception {
        InvalidInstruction(int pc) {
            super("Invalid instruction at " + pc);
        }
    }
}

