/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.msp430;

import avrora.arch.msp430.MSP430Instr;
import avrora.arch.msp430.MSP430State;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.Segment;
import cck.util.Arithmetic;

public class MSP430DataSegment
extends Segment {
    private final int ioreg_end;
    private final int sram_end;
    private final int flash_start;
    private final ActiveRegister[] ioregs;
    private final MSP430Instr[] code;
    public static final int _1kb = 1024;
    public static final int DATA_SIZE = 65536;

    public MSP430DataSegment(int se, int fs, ActiveRegister[] ior, MSP430State st) {
        super("data", 65536, (byte)0, st);
        this.sram_end = se;
        this.flash_start = fs;
        this.ioregs = ior;
        this.ioreg_end = ior.length;
        this.code = new MSP430Instr[65536];
    }

    protected byte direct_read(int address) {
        if (address < this.ioreg_end) {
            return this.ioregs[address].read();
        }
        if (address < this.sram_end) {
            return this.segment_data[address];
        }
        if (address < this.flash_start) {
            this.error_watch.fireBeforeRead(this.state, address);
        }
        return this.segment_data[address];
    }

    protected void direct_write(int address, byte val) {
        if (address < this.ioreg_end) {
            this.ioregs[address].write(val);
        } else if (address < this.sram_end) {
            this.segment_data[address] = val;
        } else {
            this.error_watch.fireBeforeWrite(this.state, address, val);
        }
    }

    public void loadProgram(Program p) {
        int start = Arithmetic.max(p.program_start, this.flash_start);
        int max = Arithmetic.min(p.program_end, 65536);
        this.loadCode(p, start, max);
        this.loadData(p, start, max);
    }

    private void loadData(Program p, int start, int max) {
        for (int pos = start; pos < max; ++pos) {
            this.segment_data[pos] = p.readProgramByte(pos);
        }
    }

    private void loadCode(Program p, int start, int max) {
        for (int pos = start; pos < max; pos += 2) {
            this.code[pos] = (MSP430Instr)p.readInstr(pos);
        }
    }

    protected MSP430Instr[] shareInstr() {
        return this.code;
    }

    public MSP430Instr readInstr(int address) {
        return this.code[address];
    }
}

